/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.login.authentication.google.web.internal.portlet.action;

import com.liferay.login.authentication.google.web.internal.portlet.action.GoogleLoginAction;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_login_web_portlet_FastLoginPortlet", "javax.portlet.name=com_liferay_login_web_portlet_LoginPortlet", "mvc.command.name=/login/associate_google_user"}, service={MVCRenderCommand.class})
public class AssociateGoogleUserMVCRenderCommand
implements MVCRenderCommand {
    @Reference
    private UserLocalService _userLocalService;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        boolean googleAuthEnabled = PrefsPropsUtil.getBoolean((long)themeDisplay.getCompanyId(), (String)"google-auth-enabled", (boolean)true);
        if (!googleAuthEnabled) {
            throw new PortletException((Throwable)new PrincipalException.MustBeEnabled(themeDisplay.getCompanyId(), new String[]{GoogleLoginAction.class.getName()}));
        }
        long googleIncompleteUserId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"userId");
        if (googleIncompleteUserId != 0L) {
            User user = this._userLocalService.fetchUser(googleIncompleteUserId);
            return this.renderUpdateAccount((PortletRequest)renderRequest, user);
        }
        return "/login.jsp";
    }

    protected String renderUpdateAccount(PortletRequest portletRequest, User user) throws PortletException {
        portletRequest.setAttribute("selUser", (Object)user);
        return "/update_account.jsp";
    }
}

