/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.learn;

import com.liferay.learn.LearnMessage;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portal.kernel.webcache.WebCachePoolUtil;
import com.liferay.portal.util.PropsValues;

public class LearnMessageUtil {
    private static final Log _log = LogFactoryUtil.getLog(LearnMessageUtil.class);

    public static JSONObject getJSONObject(String resource) {
        return (JSONObject)WebCachePoolUtil.get((String)(JSONObjectWebCacheItem.class.getName() + "#" + resource), (WebCacheItem)new JSONObjectWebCacheItem(resource));
    }

    public static LearnMessage getLearnMessage(String key, String languageId, String resource) {
        JSONObject jsonObject = LearnMessageUtil.getJSONObject(resource);
        return new LearnMessage(jsonObject, key, languageId);
    }

    private static class JSONObjectWebCacheItem
    implements WebCacheItem {
        private final String _resource;

        public JSONObjectWebCacheItem(String resource) {
            this._resource = resource;
        }

        public JSONObject convert(String key) {
            try {
                if (!PropsValues.LEARN_RESOURCES_ENABLED) {
                    return JSONFactoryUtil.createJSONObject();
                }
                StringBundler sb = new StringBundler(5);
                sb.append("https://");
                if (!PropsValues.LEARN_RESOURCES_CDN_ENABLED) {
                    sb.append("s3.amazonaws.com/");
                }
                sb.append("learn-resources.liferay.com/");
                sb.append(this._resource);
                sb.append(".json");
                String url = sb.toString();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Reading " + url));
                }
                return JSONFactoryUtil.createJSONObject((String)HttpUtil.URLtoString((String)url));
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                return JSONFactoryUtil.createJSONObject();
            }
        }

        public long getRefreshTime() {
            return PropsValues.LEARN_RESOURCES_REFRESH_TIME;
        }
    }
}

