/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.test.util;

import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkServiceUtil;
import com.liferay.fragment.service.FragmentEntryLocalServiceUtil;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalServiceUtil;
import com.liferay.layout.provider.LayoutStructureProvider;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.test.ReflectionTestUtil;
import com.liferay.portal.kernel.test.portlet.MockLiferayPortletActionRequest;
import com.liferay.portal.kernel.test.portlet.MockLiferayPortletActionResponse;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.service.SegmentsExperienceLocalServiceUtil;
import java.util.Collection;
import java.util.Iterator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.springframework.mock.web.MockHttpServletRequest;

public class ContentLayoutTestUtil {
    private static final String _INPUT_HTML = StringBundler.concat((String[])new String[]{"<div class=\"${fragmentEntryLinkNamespace}-input\">", "<div id=\"${fragmentEntryLinkNamespace}-inputTemplateNode\">", "<p>InputName:${input.name}</p>", "<p>InputJSONObject:${input.toJSONObject()}</p></div></div>"});

    public static JSONObject addFormToLayout(boolean addCaptcha, String classNameId, String classTypeId, Layout layout, LayoutStructureProvider layoutStructureProvider, long segmentsExperienceId, InfoField ... infoFields) throws Exception {
        return ContentLayoutTestUtil.addFormToLayout(addCaptcha, classNameId, classTypeId, _INPUT_HTML, layout, layoutStructureProvider, segmentsExperienceId, infoFields);
    }

    public static JSONObject addFormToLayout(boolean addCaptcha, String classNameId, String classTypeId, String inputHTML, Layout layout, LayoutStructureProvider layoutStructureProvider, long segmentsExperienceId, InfoField ... infoFields) throws Exception {
        JSONObject jsonObject = ContentLayoutTestUtil.addItemToLayout(JSONUtil.put((String)"classNameId", (Object)classNameId).put("classTypeId", classTypeId).toString(), "form", layout, layoutStructureProvider, segmentsExperienceId);
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)layout.getGroupId(), (long)TestPropsValues.getUserId());
        String parentItemId = jsonObject.getString("addedItemId");
        for (int i = 0; i < infoFields.length; ++i) {
            InfoField infoField = infoFields[i];
            InfoFieldType infoFieldType = infoField.getInfoFieldType();
            FragmentEntry fragmentEntry = FragmentEntryLocalServiceUtil.addFragmentEntry((long)TestPropsValues.getUserId(), (long)layout.getGroupId(), (long)0L, (String)StringUtil.randomString(), (String)StringUtil.randomString(), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)inputHTML, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (boolean)false, (String)"{fieldSets: []}", null, (long)0L, (int)3, (String)JSONUtil.put((String)"fieldTypes", (Object)JSONUtil.put((Object)infoFieldType.getName())).toString(), (int)0, (ServiceContext)serviceContext);
            ContentLayoutTestUtil.addFragmentEntryLinkToLayout(JSONUtil.put((String)"com.liferay.fragment.entry.processor.freemarker.FreeMarkerFragmentEntryProcessor", (Object)JSONUtil.put((String)"inputFieldId", (Object)infoField.getUniqueId())).toString(), fragmentEntry.getCss(), fragmentEntry.getConfiguration(), fragmentEntry.getFragmentEntryId(), fragmentEntry.getHtml(), fragmentEntry.getJs(), layout, fragmentEntry.getFragmentEntryKey(), fragmentEntry.getType(), parentItemId, i, segmentsExperienceId);
        }
        if (addCaptcha) {
            FragmentEntry fragmentEntry = FragmentEntryLocalServiceUtil.addFragmentEntry((long)TestPropsValues.getUserId(), (long)layout.getGroupId(), (long)0L, (String)StringUtil.randomString(), (String)StringUtil.randomString(), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)inputHTML, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (boolean)false, (String)"{fieldSets: []}", null, (long)0L, (int)3, (String)JSONUtil.put((String)"fieldTypes", (Object)JSONUtil.put((Object)"captcha")).toString(), (int)0, (ServiceContext)serviceContext);
            ContentLayoutTestUtil.addFragmentEntryLinkToLayout("", fragmentEntry.getCss(), fragmentEntry.getConfiguration(), fragmentEntry.getFragmentEntryId(), fragmentEntry.getHtml(), fragmentEntry.getJs(), layout, fragmentEntry.getFragmentEntryKey(), fragmentEntry.getType(), parentItemId, infoFields.length, segmentsExperienceId);
        }
        jsonObject.put("layoutData", (Object)layoutStructureProvider.getLayoutStructure(layout.getPlid(), segmentsExperienceId));
        return jsonObject;
    }

    public static String addFormToPublishedLayout(boolean addCaptcha, String classNameId, String classTypeId, Layout layout, LayoutStructureProvider layoutStructureProvider, InfoField<?> ... infoField) throws Exception {
        Layout draftLayout = layout.fetchDraftLayout();
        JSONObject jsonObject = ContentLayoutTestUtil.addFormToLayout(addCaptcha, classNameId, classTypeId, draftLayout, layoutStructureProvider, SegmentsExperienceLocalServiceUtil.fetchDefaultSegmentsExperienceId((long)draftLayout.getPlid()), infoField);
        ContentLayoutTestUtil.publishLayout(draftLayout, layout);
        return jsonObject.getString("addedItemId");
    }

    public static FragmentEntryLink addFragmentEntryLinkToLayout(String editableValues, Layout layout, long segmentsExperienceId) throws Exception {
        return ContentLayoutTestUtil.addFragmentEntryLinkToLayout(editableValues, layout, null, 0, segmentsExperienceId);
    }

    public static FragmentEntryLink addFragmentEntryLinkToLayout(String editableValues, Layout layout, String parentItemId, int position, long segmentsExperienceId) throws Exception {
        FragmentEntry fragmentEntry = FragmentEntryLocalServiceUtil.addFragmentEntry((long)TestPropsValues.getUserId(), (long)layout.getGroupId(), (long)0L, (String)StringUtil.randomString(), (String)StringUtil.randomString(), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (boolean)false, (String)"{fieldSets: []}", null, (long)0L, (int)1, null, (int)0, (ServiceContext)ServiceContextTestUtil.getServiceContext((long)layout.getGroupId(), (long)TestPropsValues.getUserId()));
        return ContentLayoutTestUtil.addFragmentEntryLinkToLayout(editableValues, fragmentEntry.getCss(), fragmentEntry.getConfiguration(), fragmentEntry.getFragmentEntryId(), fragmentEntry.getHtml(), fragmentEntry.getJs(), layout, fragmentEntry.getFragmentEntryKey(), fragmentEntry.getType(), parentItemId, position, segmentsExperienceId);
    }

    public static FragmentEntryLink addFragmentEntryLinkToLayout(String editableValues, String css, String configuration, long fragmentEntryId, String html, String js, Layout layout, String rendererKey, int type, String parentItemId, int position, long segmentsExperienceId) throws Exception {
        FragmentEntryLink fragmentEntryLink = FragmentEntryLinkServiceUtil.addFragmentEntryLink((long)layout.getGroupId(), (long)0L, (long)fragmentEntryId, (long)segmentsExperienceId, (long)layout.getPlid(), (String)css, (String)html, (String)js, (String)configuration, (String)editableValues, (String)"", (int)0, (String)rendererKey, (int)type, (ServiceContext)ServiceContextTestUtil.getServiceContext((long)layout.getGroupId(), (long)TestPropsValues.getUserId()));
        LayoutPageTemplateStructure layoutPageTemplateStructure = LayoutPageTemplateStructureLocalServiceUtil.fetchLayoutPageTemplateStructure((long)layout.getGroupId(), (long)layout.getPlid());
        LayoutStructure layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructure.getData(segmentsExperienceId));
        if (Validator.isNull((String)parentItemId)) {
            layoutStructure.addFragmentStyledLayoutStructureItem(fragmentEntryLink.getFragmentEntryLinkId(), layoutStructure.getMainItemId(), position);
        } else {
            layoutStructure.addFragmentStyledLayoutStructureItem(fragmentEntryLink.getFragmentEntryLinkId(), parentItemId, position);
        }
        LayoutPageTemplateStructureLocalServiceUtil.updateLayoutPageTemplateStructureData((long)layout.getGroupId(), (long)layout.getPlid(), (long)segmentsExperienceId, (String)layoutStructure.toString());
        return fragmentEntryLink;
    }

    public static FragmentEntryLink addFragmentEntryLinkToLayout(String editableValues, String css, String configuration, long fragmentEntryId, String html, String js, Layout layout, String rendererKey, long segmentsExperienceId, int type) throws Exception {
        return ContentLayoutTestUtil.addFragmentEntryLinkToLayout(editableValues, css, configuration, fragmentEntryId, html, js, layout, rendererKey, type, null, 0, segmentsExperienceId);
    }

    public static JSONObject addItemToLayout(String itemConfig, String itemType, Layout layout, LayoutStructureProvider layoutStructureProvider, long segmentsExperienceId) throws Exception {
        LayoutStructure layoutStructure = layoutStructureProvider.getLayoutStructure(layout.getPlid(), segmentsExperienceId);
        return ContentLayoutTestUtil.addItemToLayout(itemConfig, itemType, layout, layoutStructure.getMainItemId(), 0, segmentsExperienceId);
    }

    public static JSONObject addItemToLayout(String itemConfig, String itemType, Layout layout, String parentItemId, int position, long segmentsExperienceId) throws Exception {
        MVCActionCommand mvcActionCommand = ContentLayoutTestUtil.getMVCActionCommand("/layout_content_page_editor/add_item");
        MockLiferayPortletActionRequest mockLiferayPortletActionRequest = ContentLayoutTestUtil.getMockLiferayPortletActionRequest(CompanyLocalServiceUtil.getCompany((long)layout.getCompanyId()), GroupLocalServiceUtil.getGroup((long)layout.getGroupId()), layout);
        mockLiferayPortletActionRequest.addParameter("itemType", itemType);
        mockLiferayPortletActionRequest.addParameter("parentItemId", parentItemId);
        mockLiferayPortletActionRequest.addParameter("position", String.valueOf(position));
        mockLiferayPortletActionRequest.addParameter("segmentsExperienceId", String.valueOf(segmentsExperienceId));
        JSONObject jsonObject = (JSONObject)ReflectionTestUtil.invoke((Object)mvcActionCommand, (String)"_addItemToLayoutData", (Class[])new Class[]{ActionRequest.class}, (Object[])new Object[]{mockLiferayPortletActionRequest});
        mvcActionCommand = ContentLayoutTestUtil.getMVCActionCommand("/layout_content_page_editor/update_item_config");
        mockLiferayPortletActionRequest = ContentLayoutTestUtil.getMockLiferayPortletActionRequest(CompanyLocalServiceUtil.getCompany((long)layout.getCompanyId()), GroupLocalServiceUtil.getGroup((long)layout.getGroupId()), layout);
        mockLiferayPortletActionRequest.addParameter("itemConfig", itemConfig);
        mockLiferayPortletActionRequest.addParameter("itemId", jsonObject.getString("addedItemId"));
        JSONObject responseJSONObject = (JSONObject)ReflectionTestUtil.invoke((Object)mvcActionCommand, (String)"_updateItemConfig", (Class[])new Class[]{ActionRequest.class, ActionResponse.class}, (Object[])new Object[]{mockLiferayPortletActionRequest, new MockLiferayPortletActionResponse()});
        jsonObject.put("layoutData", responseJSONObject.getJSONObject("layoutData")).put("pageContents", responseJSONObject.getJSONObject("pageContents"));
        return jsonObject;
    }

    public static JSONObject addPortletToLayout(Layout layout, String portletId) throws Exception {
        MVCActionCommand addPortletMVCActionCommand = ContentLayoutTestUtil.getMVCActionCommand("/layout_content_page_editor/add_portlet");
        MockLiferayPortletActionRequest mockLiferayPortletActionRequest = ContentLayoutTestUtil.getMockLiferayPortletActionRequest(CompanyLocalServiceUtil.getCompany((long)layout.getCompanyId()), GroupLocalServiceUtil.getGroup((long)layout.getGroupId()), layout);
        mockLiferayPortletActionRequest.addParameter("portletId", portletId);
        return (JSONObject)ReflectionTestUtil.invoke((Object)addPortletMVCActionCommand, (String)"_processAddPortlet", (Class[])new Class[]{ActionRequest.class, ActionResponse.class}, (Object[])new Object[]{mockLiferayPortletActionRequest, new MockLiferayPortletActionResponse()});
    }

    public static MockHttpServletRequest getMockHttpServletRequest(Company company, Group group, Layout layout) throws Exception {
        MockHttpServletRequest mockHttpServletRequest = new MockHttpServletRequest();
        mockHttpServletRequest.setAttribute("LAYOUT", (Object)layout);
        mockHttpServletRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)ContentLayoutTestUtil.getThemeDisplay(company, group, layout));
        return mockHttpServletRequest;
    }

    public static MockLiferayPortletActionRequest getMockLiferayPortletActionRequest(Company company, Group group, Layout layout) throws Exception {
        MockLiferayPortletActionRequest mockLiferayPortletActionRequest = new MockLiferayPortletActionRequest();
        mockLiferayPortletActionRequest.setAttribute("javax.portlet.response", (Object)new MockLiferayPortletActionResponse());
        MockHttpServletRequest mockHttpServletRequest = new MockHttpServletRequest();
        mockHttpServletRequest.setAttribute("LAYOUT", (Object)layout);
        ThemeDisplay themeDisplay = ContentLayoutTestUtil.getThemeDisplay(company, group, layout);
        themeDisplay.setRequest((HttpServletRequest)mockHttpServletRequest);
        mockHttpServletRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)themeDisplay);
        mockLiferayPortletActionRequest.setAttribute("com.liferay.portal.kernel.servlet.PortletServletRequest", (Object)mockHttpServletRequest);
        mockLiferayPortletActionRequest.setAttribute("LAYOUT", (Object)layout);
        mockLiferayPortletActionRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)themeDisplay);
        mockLiferayPortletActionRequest.addParameter("segmentsExperienceId", String.valueOf(SegmentsExperienceLocalServiceUtil.fetchDefaultSegmentsExperienceId((long)layout.getPlid())));
        return mockLiferayPortletActionRequest;
    }

    public static MVCActionCommand getMVCActionCommand(String mvcCommandName) {
        try {
            Bundle bundle = FrameworkUtil.getBundle(ContentLayoutTestUtil.class);
            BundleContext bundleContext = bundle.getBundleContext();
            Collection mvcActionCommandReferences = bundleContext.getServiceReferences(MVCActionCommand.class, "(mvc.command.name=" + mvcCommandName + ")");
            Iterator iterator = mvcActionCommandReferences.iterator();
            return (MVCActionCommand)bundleContext.getService((ServiceReference)iterator.next());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static ThemeDisplay getThemeDisplay(Company company, Group group, Layout layout) throws Exception {
        ThemeDisplay themeDisplay = new ThemeDisplay();
        themeDisplay.setCompany(company);
        themeDisplay.setLayout(layout);
        themeDisplay.setLayoutSet(layout.getLayoutSet());
        themeDisplay.setLayoutTypePortlet((LayoutTypePortlet)layout.getLayoutType());
        themeDisplay.setLocale(PortalUtil.getSiteDefaultLocale((Group)group));
        LayoutSet layoutSet = group.getPublicLayoutSet();
        themeDisplay.setLookAndFeel(layoutSet.getTheme(), null);
        themeDisplay.setPermissionChecker(PermissionThreadLocal.getPermissionChecker());
        themeDisplay.setPlid(layout.getPlid());
        themeDisplay.setRealUser(TestPropsValues.getUser());
        themeDisplay.setScopeGroupId(group.getGroupId());
        themeDisplay.setSiteGroupId(group.getGroupId());
        themeDisplay.setUser(TestPropsValues.getUser());
        return themeDisplay;
    }

    public static JSONObject markItemForDeletionFromLayout(String itemId, Layout layout, String portletId) throws Exception {
        MVCActionCommand markItemForDeletionMVCActionCommand = ContentLayoutTestUtil.getMVCActionCommand("/layout_content_page_editor/mark_item_for_deletion");
        MockLiferayPortletActionRequest mockLiferayPortletActionRequest = ContentLayoutTestUtil.getMockLiferayPortletActionRequest(CompanyLocalServiceUtil.getCompany((long)layout.getCompanyId()), GroupLocalServiceUtil.getGroup((long)layout.getGroupId()), layout);
        mockLiferayPortletActionRequest.addParameter("itemId", itemId);
        mockLiferayPortletActionRequest.addParameter("portletIds", new String[]{portletId});
        return (JSONObject)ReflectionTestUtil.invoke((Object)markItemForDeletionMVCActionCommand, (String)"doTransactionalCommand", (Class[])new Class[]{ActionRequest.class, ActionResponse.class}, (Object[])new Object[]{mockLiferayPortletActionRequest, new MockLiferayPortletActionResponse()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publishLayout(Layout draftLayout, Layout layout) throws Exception {
        MVCActionCommand publishLayoutMVCActionCommand = ContentLayoutTestUtil.getMVCActionCommand("/layout_content_page_editor/publish_layout");
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(layout.getGroupId());
        serviceContext.setUserId(TestPropsValues.getUserId());
        try {
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
            ReflectionTestUtil.invoke((Object)publishLayoutMVCActionCommand, (String)"_publishLayout", (Class[])new Class[]{ActionRequest.class, ActionResponse.class, Layout.class, Layout.class, ServiceContext.class, Long.TYPE}, (Object[])new Object[]{ContentLayoutTestUtil.getMockLiferayPortletActionRequest(CompanyLocalServiceUtil.getCompany((long)layout.getCompanyId()), GroupLocalServiceUtil.getGroup((long)layout.getGroupId()), layout), new MockLiferayPortletActionResponse(), draftLayout, layout, serviceContext, TestPropsValues.getUserId()});
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
    }
}

