/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.util;

import com.liferay.layout.util.structure.ColumnLayoutStructureItem;
import com.liferay.layout.util.structure.ContainerStyledLayoutStructureItem;
import com.liferay.layout.util.structure.DropZoneLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.layout.util.structure.RowStyledLayoutStructureItem;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;

public class LayoutDataConverter {
    public static final int LATEST_VERSION = 1;

    public static String convert(String data) {
        if (Validator.isNull((String)data)) {
            return "";
        }
        JSONObject inputDataJSONObject = null;
        try {
            inputDataJSONObject = JSONFactoryUtil.createJSONObject((String)data);
        }
        catch (JSONException jsonException) {
            throw new RuntimeException(jsonException);
        }
        if (LayoutDataConverter.isLatestVersion(inputDataJSONObject)) {
            return data;
        }
        JSONArray structureJSONArray = inputDataJSONObject.getJSONArray("structure");
        if (structureJSONArray == null) {
            return data;
        }
        LayoutStructure layoutStructure = new LayoutStructure();
        LayoutStructureItem rootLayoutStructureItem = layoutStructure.addRootLayoutStructureItem();
        for (int i = 0; i < structureJSONArray.length(); ++i) {
            JSONObject inputRowJSONObject = structureJSONArray.getJSONObject(i);
            JSONArray columnsJSONArray = inputRowJSONObject.getJSONArray("columns");
            if (inputRowJSONObject.getInt("type") == 1) {
                ContainerStyledLayoutStructureItem containerStyledLayoutStructureItem = (ContainerStyledLayoutStructureItem)layoutStructure.addContainerLayoutStructureItem(rootLayoutStructureItem.getItemId(), i);
                JSONObject inputRowConfigJSONObject = inputRowJSONObject.getJSONObject("config");
                if (inputRowConfigJSONObject != null) {
                    JSONObject stylesJSONObject = JSONUtil.put((String)"backgroundImage", (Object)LayoutDataConverter._getBackgroundImageJSONObject(inputRowConfigJSONObject)).put("paddingBottom", inputRowConfigJSONObject.getInt("paddingVertical", 0)).put("paddingLeft", inputRowConfigJSONObject.getInt("paddingHorizontal", 0)).put("paddingRight", inputRowConfigJSONObject.getInt("paddingHorizontal", 0)).put("paddingTop", inputRowConfigJSONObject.getInt("paddingVertical", 0));
                    if (inputRowConfigJSONObject.has("containerType")) {
                        containerStyledLayoutStructureItem.setWidthType(inputRowConfigJSONObject.getString("containerType", "fixed"));
                    } else {
                        containerStyledLayoutStructureItem.setWidthType(inputRowConfigJSONObject.getString("widthType", "fixed"));
                    }
                    containerStyledLayoutStructureItem.updateItemConfig(JSONUtil.put((String)"backgroundColorCssClass", (Object)inputRowConfigJSONObject.getString("backgroundColorCssClass")).put("styles", stylesJSONObject));
                }
                RowStyledLayoutStructureItem rowStyledLayoutStructureItem = (RowStyledLayoutStructureItem)layoutStructure.addRowLayoutStructureItem(containerStyledLayoutStructureItem.getItemId(), 0, columnsJSONArray.length());
                if (inputRowConfigJSONObject != null) {
                    boolean columnSpacing = inputRowConfigJSONObject.getBoolean("columnSpacing", true);
                    rowStyledLayoutStructureItem.setGutters(columnSpacing);
                }
                for (int j = 0; j < columnsJSONArray.length(); ++j) {
                    JSONObject inputColumnJSONObject = columnsJSONArray.getJSONObject(j);
                    ColumnLayoutStructureItem columnLayoutStructureItem = (ColumnLayoutStructureItem)layoutStructure.addColumnLayoutStructureItem(rowStyledLayoutStructureItem.getItemId(), j);
                    columnLayoutStructureItem.setSize(inputColumnJSONObject.getInt("size"));
                    JSONArray fragmentEntryLinksJSONArray = inputColumnJSONObject.getJSONArray("fragmentEntryLinkIds");
                    for (int k = 0; k < fragmentEntryLinksJSONArray.length(); ++k) {
                        LayoutDataConverter._addFragmentEntryLink(fragmentEntryLinksJSONArray.getString(k), inputDataJSONObject, layoutStructure, columnLayoutStructureItem.getItemId(), k);
                    }
                }
                continue;
            }
            JSONObject columnJSONObject = columnsJSONArray.getJSONObject(0);
            JSONArray fragmentEntryLinkIdsJSONArray = columnJSONObject.getJSONArray("fragmentEntryLinkIds");
            LayoutDataConverter._addFragmentEntryLink(fragmentEntryLinkIdsJSONArray.getString(0), inputDataJSONObject, layoutStructure, rootLayoutStructureItem.getItemId(), i);
        }
        JSONObject layoutStructureJSONObject = layoutStructure.toJSONObject();
        return layoutStructureJSONObject.toString();
    }

    public static boolean isLatestVersion(JSONObject dataJSONObject) {
        int version = dataJSONObject.getInt("version");
        return version == 1;
    }

    private static void _addFragmentEntryLink(String fragmentEntryLinkId, JSONObject inputDataJSONObject, LayoutStructure layoutStructure, String parentItemId, int position) {
        if (fragmentEntryLinkId.equals("drop-zone")) {
            DropZoneLayoutStructureItem dropZoneLayoutStructureItem = (DropZoneLayoutStructureItem)layoutStructure.addDropZoneLayoutStructureItem(parentItemId, position);
            dropZoneLayoutStructureItem.setAllowNewFragmentEntries(inputDataJSONObject.getBoolean("allowNewFragmentEntries", true));
            JSONArray fragmentEntryKeysJSONArray = inputDataJSONObject.getJSONArray("fragmentEntryKeys");
            dropZoneLayoutStructureItem.setFragmentEntryKeys(JSONUtil.toStringList((JSONArray)fragmentEntryKeysJSONArray));
            return;
        }
        layoutStructure.addFragmentLayoutStructureItem(GetterUtil.getLong((String)fragmentEntryLinkId), parentItemId, position);
    }

    private static JSONObject _getBackgroundImageJSONObject(JSONObject inputRowConfigJSONObject) {
        if (inputRowConfigJSONObject.isNull("backgroundImage")) {
            return JSONFactoryUtil.createJSONObject();
        }
        Object backgroundImage = inputRowConfigJSONObject.get("backgroundImage");
        if (backgroundImage instanceof JSONObject) {
            return (JSONObject)backgroundImage;
        }
        return JSONUtil.put((String)"url", (Object)backgroundImage);
    }
}

