/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.util;

import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.layout.internal.action.provider.LayoutActionProvider;
import com.liferay.layout.security.permission.resource.LayoutContentModelResourcePermission;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONSerializable;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutBranch;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutRevisionLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalService;
import com.liferay.portal.kernel.service.permission.GroupPermission;
import com.liferay.portal.kernel.service.permission.LayoutPermission;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.servlet.BrowserSniffer;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SessionClicks;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.layoutsadmin.util.LayoutsTree;
import com.liferay.site.navigation.service.SiteNavigationMenuLocalService;
import com.liferay.sites.kernel.util.Sites;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutsTree.class})
public class LayoutsTreeImpl
implements LayoutsTree {
    private static final Log _log = LogFactoryUtil.getLog(LayoutsTreeImpl.class);
    @Reference
    private BrowserSniffer _browserSniffer;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private GroupPermission _groupPermission;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private LayoutContentModelResourcePermission _layoutContentModelResourcePermission;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPermission _layoutPermission;
    @Reference
    private LayoutRevisionLocalService _layoutRevisionLocalService;
    @Reference
    private LayoutService _layoutService;
    @Reference
    private LayoutSetBranchLocalService _layoutSetBranchLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SiteNavigationMenuLocalService _siteNavigationMenuLocalService;
    @Reference
    private Sites _sites;
    @Reference
    private Staging _staging;

    public String getLayoutsJSON(HttpServletRequest httpServletRequest, long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, String treeId) throws Exception {
        return this.getLayoutsJSON(httpServletRequest, groupId, privateLayout, parentLayoutId, incomplete, treeId, null);
    }

    public String getLayoutsJSON(HttpServletRequest httpServletRequest, long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, String treeId, LayoutSetBranch layoutSetBranch) throws Exception {
        return this.getLayoutsJSON(httpServletRequest, groupId, privateLayout, parentLayoutId, null, incomplete, treeId, layoutSetBranch);
    }

    public String getLayoutsJSON(HttpServletRequest httpServletRequest, long groupId, boolean privateLayout, long layoutId, int max) throws Exception {
        return this.getLayoutsJSON(httpServletRequest, groupId, privateLayout, layoutId, max, null);
    }

    public String getLayoutsJSON(HttpServletRequest httpServletRequest, long groupId, boolean privateLayout, long layoutId, int max, LayoutSetBranch layoutSetBranch) throws Exception {
        Layout layout = this._layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        long parentLayoutId = layout.getParentLayoutId();
        long includedLayoutIndex = this._layoutService.getLayoutsCount(groupId, privateLayout, parentLayoutId, layout.getPriority());
        int total = this._layoutService.getLayoutsCount(groupId, privateLayout, parentLayoutId);
        int start = (int)includedLayoutIndex - 1;
        int end = (int)includedLayoutIndex + max;
        if (end > total) {
            start = total - max;
            end = total;
            if (start < 0) {
                start = 0;
            }
        }
        List layouts = this._layoutService.getLayouts(groupId, privateLayout, parentLayoutId, true, start, end);
        JSONSerializable jsonSerializable = this._toJSONSerializable(httpServletRequest, groupId, layouts, total, layoutSetBranch);
        List ancestorLayouts = this._layoutService.getAncestorLayouts(layout.getPlid());
        long[] ancestorLayoutIds = new long[ancestorLayouts.size()];
        String[] ancestorLayoutNames = new String[ancestorLayouts.size()];
        Locale locale = this._portal.getLocale(httpServletRequest);
        for (int i = 0; i < ancestorLayouts.size(); ++i) {
            Layout ancestorLayout = (Layout)ancestorLayouts.get(i);
            ancestorLayoutIds[i] = ancestorLayout.getLayoutId();
            ancestorLayoutNames[i] = ancestorLayout.getName(locale);
        }
        if (jsonSerializable instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)jsonSerializable;
            jsonObject.put("ancestorLayoutIds", (Object)ancestorLayoutIds).put("ancestorLayoutNames", (Object)ancestorLayoutNames).put("start", start);
        }
        return jsonSerializable.toString();
    }

    public String getLayoutsJSON(HttpServletRequest httpServletRequest, long groupId, boolean privateLayout, long parentLayoutId, long[] expandedLayoutIds, boolean incomplete, String treeId) throws Exception {
        return this.getLayoutsJSON(httpServletRequest, groupId, privateLayout, parentLayoutId, expandedLayoutIds, incomplete, treeId, null);
    }

    public String getLayoutsJSON(HttpServletRequest httpServletRequest, long groupId, boolean privateLayout, long parentLayoutId, long[] expandedLayoutIds, boolean incomplete, String treeId, LayoutSetBranch layoutSetBranch) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"getLayoutsJSON(groupId=", groupId, ", privateLayout=", privateLayout, ", parentLayoutId=", parentLayoutId, ", expandedLayoutIds=", expandedLayoutIds, ", incomplete=", incomplete, ", treeId=", treeId, ")"}));
        }
        LayoutTreeNodes layoutTreeNodes = this._getLayoutTreeNodes(httpServletRequest, groupId, privateLayout, parentLayoutId, incomplete, expandedLayoutIds, treeId, false);
        return this._toJSON(httpServletRequest, groupId, layoutTreeNodes, layoutSetBranch);
    }

    public String getLayoutsJSON(HttpServletRequest httpServletRequest, long groupId, String treeId) throws Exception {
        return this.getLayoutsJSON(httpServletRequest, groupId, treeId, null);
    }

    public String getLayoutsJSON(HttpServletRequest httpServletRequest, long groupId, String treeId, LayoutSetBranch layoutSetBranch) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"getLayoutsJSON(groupId=", groupId, ", treeId=", treeId, ")"}));
        }
        LayoutTreeNodes layoutTreeNodes = new LayoutTreeNodes();
        layoutTreeNodes.addAll(this._getLayoutTreeNodes(httpServletRequest, groupId, true, 0L, false, null, treeId, false));
        layoutTreeNodes.addAll(this._getLayoutTreeNodes(httpServletRequest, groupId, false, 0L, false, null, treeId, false));
        return this._toJSON(httpServletRequest, groupId, layoutTreeNodes, layoutSetBranch);
    }

    private Layout _fetchCurrentLayout(HttpServletRequest httpServletRequest) {
        long selPlid = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"selPlid");
        if (selPlid > 0L) {
            return this._layoutLocalService.fetchLayout(selPlid);
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        if (!layout.isTypeControlPanel()) {
            return layout;
        }
        return null;
    }

    private List<Layout> _getAncestorLayouts(HttpServletRequest httpServletRequest) throws Exception {
        Layout layout = this._fetchCurrentLayout(httpServletRequest);
        if (layout == null) {
            return Collections.emptyList();
        }
        List ancestorLayouts = this._layoutService.getAncestorLayouts(layout.getPlid());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Get ancestor layouts ", ancestorLayouts, " for layout ", layout}));
        }
        ancestorLayouts.add(layout);
        return ancestorLayouts;
    }

    private Layout _getDraftLayout(Layout layout) {
        if (!layout.isTypeContent()) {
            return null;
        }
        Layout draftLayout = layout.fetchDraftLayout();
        if (draftLayout == null) {
            return null;
        }
        if (draftLayout.isDraft() || !layout.isPublished()) {
            return draftLayout;
        }
        return null;
    }

    private LayoutTreeNodes _getLayoutTreeNodes(HttpServletRequest httpServletRequest, long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, long[] expandedLayoutIds, String treeId, boolean childLayout) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"_getLayoutTreeNodes(groupId=", groupId, ", privateLayout=", privateLayout, ", parentLayoutId=", parentLayoutId, ", expandedLayoutIds=", expandedLayoutIds, ", incomplete=", incomplete, ", treeId=", treeId, ")"}));
        }
        ArrayList<LayoutTreeNode> layoutTreeNodes = new ArrayList<LayoutTreeNode>();
        List<Layout> ancestorLayouts = this._getAncestorLayouts(httpServletRequest);
        int count = this._layoutService.getLayoutsCount(groupId, privateLayout, parentLayoutId);
        List<Layout> layouts = this._getPaginatedLayouts(httpServletRequest, groupId, privateLayout, parentLayoutId, incomplete, treeId, childLayout, count, this._layoutLocalService.getLayoutsCount(this._groupLocalService.getGroup(groupId), privateLayout, parentLayoutId));
        for (Layout layout : layouts) {
            LayoutTreeNode layoutTreeNode = new LayoutTreeNode(layout);
            LayoutTreeNodes childLayoutTreeNodes = null;
            if (this._isExpandableLayout(httpServletRequest, ancestorLayouts, expandedLayoutIds, layout)) {
                if (layout instanceof VirtualLayout) {
                    VirtualLayout virtualLayout = (VirtualLayout)layout;
                    childLayoutTreeNodes = this._getLayoutTreeNodes(httpServletRequest, virtualLayout.getSourceGroupId(), virtualLayout.isPrivateLayout(), virtualLayout.getLayoutId(), incomplete, expandedLayoutIds, treeId, true);
                } else {
                    childLayoutTreeNodes = this._getLayoutTreeNodes(httpServletRequest, groupId, layout.isPrivateLayout(), layout.getLayoutId(), incomplete, expandedLayoutIds, treeId, true);
                }
            } else {
                int childLayoutsCount = this._layoutService.getLayoutsCount(groupId, privateLayout, layout.getLayoutId());
                childLayoutTreeNodes = new LayoutTreeNodes(new ArrayList<LayoutTreeNode>(), childLayoutsCount);
            }
            layoutTreeNode.setChildLayoutTreeNodes(childLayoutTreeNodes);
            layoutTreeNodes.add(layoutTreeNode);
        }
        return new LayoutTreeNodes(layoutTreeNodes, count);
    }

    private int _getLoadedLayoutsCount(HttpSession httpSession, long groupId, boolean privateLayout, long layoutId, String treeId) throws Exception {
        String key = StringBundler.concat((Object[])new Object[]{treeId, ":", groupId, ":", privateLayout, ":Pagination"});
        String paginationJSON = SessionClicks.get((HttpSession)httpSession, (String)key, (String)this._jsonFactory.getNullJSON());
        JSONObject paginationJSONObject = this._jsonFactory.createJSONObject(paginationJSON);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"_getLoadedLayoutsCount(key=", key, ", layoutId=", layoutId, ", paginationJSON=", paginationJSON, ", paginationJSONObject", paginationJSONObject, ")"}));
        }
        return paginationJSONObject.getInt(String.valueOf(layoutId), 0);
    }

    private List<Layout> _getPaginatedLayouts(HttpServletRequest httpServletRequest, long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, String treeId, boolean childLayout, int count, int totalCount) throws Exception {
        if (!this._isPaginationEnabled(httpServletRequest)) {
            return this._layoutService.getLayouts(groupId, privateLayout, parentLayoutId, incomplete, -1, -1);
        }
        int loadedLayoutsCount = this._getLoadedLayoutsCount(httpServletRequest.getSession(), groupId, privateLayout, parentLayoutId, treeId);
        int start = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"start");
        int end = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"end", (int)((start = Math.max(0, Math.min(start, count))) + PropsValues.LAYOUT_MANAGE_PAGES_INITIAL_CHILDREN));
        if (loadedLayoutsCount > end) {
            end = loadedLayoutsCount;
        }
        end = Math.max(start, Math.min(end, count));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"_getPaginatedLayouts(loadedLayoutsCount=", loadedLayoutsCount, ", start=", start, ", end=", end, ")"}));
        }
        if (childLayout && count > PropsValues.LAYOUT_MANAGE_PAGES_INITIAL_CHILDREN && start == PropsValues.LAYOUT_MANAGE_PAGES_INITIAL_CHILDREN) {
            start = end;
        }
        if (count != totalCount) {
            List layouts = this._layoutService.getLayouts(groupId, privateLayout, parentLayoutId, incomplete, -1, -1);
            return layouts.subList(start, end);
        }
        return this._layoutService.getLayouts(groupId, privateLayout, parentLayoutId, incomplete, start, end);
    }

    private boolean _isDeleteable(Layout layout, ThemeDisplay themeDisplay, LayoutSetBranch layoutSetBranch) throws Exception {
        LayoutRevision layoutRevision;
        List layoutRevisions;
        int count;
        if (!LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"DELETE")) {
            return false;
        }
        Group group = layout.getGroup();
        if (group.isGuest() && !layout.isPrivateLayout() && layout.isRootLayout() && (count = this._layoutLocalService.getLayoutsCount(group, false, 0L)) == 1) {
            return false;
        }
        return layoutSetBranch == null || (layoutRevisions = this._layoutRevisionLocalService.getLayoutRevisions(layoutSetBranch.getLayoutSetBranchId(), layout.getPlid())).size() != 1 || !(layoutRevision = (LayoutRevision)layoutRevisions.get(0)).isIncomplete();
    }

    private boolean _isExpandableLayout(HttpServletRequest httpServletRequest, List<Layout> ancestorLayouts, long[] expandedLayoutIds, Layout layout) {
        boolean expandParentLayouts = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"expandParentLayouts");
        return expandParentLayouts || ancestorLayouts.contains(layout) || ArrayUtil.contains((long[])expandedLayoutIds, (long)layout.getLayoutId());
    }

    private boolean _isPaginationEnabled(HttpServletRequest httpServletRequest) {
        boolean paginate = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"paginate", (boolean)true);
        return paginate && PropsValues.LAYOUT_MANAGE_PAGES_INITIAL_CHILDREN > -1;
    }

    private String _toJSON(HttpServletRequest httpServletRequest, long groupId, LayoutTreeNodes layoutTreeNodes, LayoutSetBranch layoutSetBranch) throws Exception {
        JSONSerializable jsonSerializable = this._toJSONSerializable(httpServletRequest, groupId, layoutTreeNodes, layoutSetBranch);
        return jsonSerializable.toString();
    }

    private JSONArray _toJSONArray(HttpServletRequest httpServletRequest, long groupId, LayoutTreeNodes layoutTreeNodes, LayoutSetBranch layoutSetBranch) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Group ", groupId, " and layout tree nodes ", layoutTreeNodes}));
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        boolean hasManageLayoutsPermission = this._groupPermission.contains(themeDisplay.getPermissionChecker(), groupId, "MANAGE_LAYOUTS");
        boolean mobile = this._browserSniffer.isMobile(httpServletRequest);
        for (LayoutTreeNode layoutTreeNode : layoutTreeNodes) {
            LayoutTreeNodes childLayoutTreeNodes = layoutTreeNode.getChildLayoutTreeNodes();
            JSONSerializable childrenJSONSerializable = this._toJSONSerializable(httpServletRequest, groupId, childLayoutTreeNodes, layoutSetBranch);
            Layout layout = layoutTreeNode.getLayout();
            JSONObject jsonObject = this._jsonFactory.createJSONObject();
            if (GetterUtil.getBoolean((Object)httpServletRequest.getAttribute("RETURN_LAYOUTS_AS_ARRAY"))) {
                LayoutActionProvider layoutActionProvider = new LayoutActionProvider(httpServletRequest, this._language, this._siteNavigationMenuLocalService);
                jsonObject.put("actions", layoutActionProvider.getActionsJSONArray(layout));
            }
            if (childrenJSONSerializable instanceof JSONArray) {
                JSONArray childrenJSONArray = (JSONArray)childrenJSONSerializable;
                if (childrenJSONArray.length() > 0) {
                    jsonObject.put("children", (Object)childrenJSONSerializable);
                }
            } else {
                jsonObject.put("children", (Object)childrenJSONSerializable);
            }
            jsonObject.put("contentDisplayPage", layout.isContentDisplayPage()).put("deleteable", this._isDeleteable(layout, themeDisplay, layoutSetBranch));
            Layout draftLayout = this._getDraftLayout(layout);
            if (draftLayout != null && LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"UPDATE")) {
                jsonObject.put("draftStatus", "draft");
                String draftLayoutURL = this._portal.getLayoutFriendlyURL(draftLayout, themeDisplay);
                jsonObject.put("draftURL", draftLayoutURL);
            }
            jsonObject.put("friendlyURL", layout.getFriendlyURL());
            if (layout instanceof VirtualLayout) {
                VirtualLayout virtualLayout = (VirtualLayout)layout;
                jsonObject.put("groupId", virtualLayout.getSourceGroupId());
            } else {
                jsonObject.put("groupId", layout.getGroupId());
            }
            jsonObject.put("hasChildren", layout.hasChildren()).put("id", layout.getPlid()).put("layoutId", layout.getLayoutId());
            String layoutName = layout.getName(themeDisplay.getLocale());
            try {
                if (draftLayout != null && (this._layoutContentModelResourcePermission.contains(themeDisplay.getPermissionChecker(), layout.getPlid(), "UPDATE") || this._layoutPermission.containsLayoutUpdatePermission(themeDisplay.getPermissionChecker(), layout))) {
                    layoutName = layoutName + "*";
                }
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
            jsonObject.put("icon", layout.getIcon()).put("name", layoutName);
            List<LayoutTreeNode> layoutTreeNodesList = childLayoutTreeNodes.getLayoutTreeNodesList();
            if (GetterUtil.getBoolean((Object)httpServletRequest.getAttribute("RETURN_LAYOUTS_AS_ARRAY")) && childLayoutTreeNodes.getTotal() != layoutTreeNodesList.size()) {
                jsonObject.put("paginated", true);
            }
            jsonObject.put("parentable", LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"ADD_LAYOUT")).put("parentLayoutId", layout.getParentLayoutId()).put("plid", layout.getPlid()).put("priority", layout.getPriority()).put("privateLayout", layout.isPrivateLayout()).put("regularURL", layout.getRegularURL(httpServletRequest)).put("sortable", hasManageLayoutsPermission && !mobile && this._sites.isLayoutSortable(layout)).put("target", GetterUtil.getString((String)HtmlUtil.escape((String)layout.getTypeSettingsProperty("target")), (String)"_self")).put("type", layout.getType()).put("updateable", LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"UPDATE")).put("uuid", layout.getUuid());
            LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout);
            if (layoutRevision != null) {
                long layoutSetBranchId = layoutRevision.getLayoutSetBranchId();
                if (this._staging.isIncomplete(layout, layoutSetBranchId)) {
                    jsonObject.put("incomplete", true);
                }
                LayoutSetBranch boundLayoutSetBranch = this._layoutSetBranchLocalService.getLayoutSetBranch(layoutSetBranchId);
                LayoutBranch layoutBranch = layoutRevision.getLayoutBranch();
                if (!layoutBranch.isMaster()) {
                    jsonObject.put("layoutBranchId", layoutBranch.getLayoutBranchId()).put("layoutBranchName", layoutBranch.getName());
                }
                if (layoutRevision.isHead()) {
                    jsonObject.put("layoutRevisionHead", true);
                }
                jsonObject.put("layoutRevisionId", layoutRevision.getLayoutRevisionId()).put("layoutSetBranchId", layoutSetBranchId).put("layoutSetBranchName", boundLayoutSetBranch.getName());
            }
            if (Objects.equals(layout.getType(), "collection")) {
                jsonObject.put("collectionPK", layout.getTypeSettingsProperty("collectionPK")).put("collectionType", layout.getTypeSettingsProperty("collectionType"));
            }
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    private JSONSerializable _toJSONSerializable(HttpServletRequest httpServletRequest, long groupId, LayoutTreeNodes layoutTreeNodes, LayoutSetBranch layoutSetBranch) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Group ", groupId, " and layout tree nodes ", layoutTreeNodes}));
        }
        JSONArray jsonArray = this._toJSONArray(httpServletRequest, groupId, layoutTreeNodes, layoutSetBranch);
        if (GetterUtil.getBoolean((Object)httpServletRequest.getAttribute("RETURN_LAYOUTS_AS_ARRAY"))) {
            return jsonArray;
        }
        return JSONUtil.put((String)"layouts", (Object)jsonArray).put("total", layoutTreeNodes.getTotal());
    }

    private JSONSerializable _toJSONSerializable(HttpServletRequest httpServletRequest, long groupId, List<Layout> layouts, int total, LayoutSetBranch layoutSetBranch) throws Exception {
        ArrayList<LayoutTreeNode> layoutTreeNodesList = new ArrayList<LayoutTreeNode>();
        for (Layout layout : layouts) {
            LayoutTreeNode layoutTreeNode = new LayoutTreeNode(layout);
            layoutTreeNodesList.add(layoutTreeNode);
        }
        LayoutTreeNodes layoutTreeNodes = new LayoutTreeNodes(layoutTreeNodesList, total);
        return this._toJSONSerializable(httpServletRequest, groupId, layoutTreeNodes, layoutSetBranch);
    }

    private static class LayoutTreeNodes
    implements Iterable<LayoutTreeNode> {
        private final List<LayoutTreeNode> _layoutTreeNodesList;
        private int _total;

        public LayoutTreeNodes() {
            this._layoutTreeNodesList = new ArrayList<LayoutTreeNode>();
        }

        public LayoutTreeNodes(List<LayoutTreeNode> layoutTreeNodesList, int total) {
            this._layoutTreeNodesList = layoutTreeNodesList;
            this._total = total;
        }

        public void addAll(LayoutTreeNodes layoutTreeNodes) {
            this._layoutTreeNodesList.addAll(layoutTreeNodes.getLayoutTreeNodesList());
            this._total += layoutTreeNodes.getTotal();
        }

        public List<LayoutTreeNode> getLayoutTreeNodesList() {
            return this._layoutTreeNodesList;
        }

        public int getTotal() {
            return this._total;
        }

        @Override
        public Iterator<LayoutTreeNode> iterator() {
            return this._layoutTreeNodesList.iterator();
        }

        public String toString() {
            return StringBundler.concat((Object[])new Object[]{"{layoutTreeNodesList=", this._layoutTreeNodesList, ", total=", this._total, "}"});
        }
    }

    private static class LayoutTreeNode {
        private LayoutTreeNodes _childLayoutTreeNodes = new LayoutTreeNodes();
        private final Layout _layout;

        public LayoutTreeNode(Layout layout) {
            this._layout = layout;
        }

        public LayoutTreeNodes getChildLayoutTreeNodes() {
            return this._childLayoutTreeNodes;
        }

        public Layout getLayout() {
            return this._layout;
        }

        public void setChildLayoutTreeNodes(LayoutTreeNodes childLayoutTreeNodes) {
            this._childLayoutTreeNodes = childLayoutTreeNodes;
        }

        public String toString() {
            return StringBundler.concat((Object[])new Object[]{"{childLayoutTreeNodes=", this._childLayoutTreeNodes, ", layout=", this._layout, "}"});
        }
    }
}

