/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.util;

import com.liferay.layout.exception.LayoutConvertException;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.util.BulkLayoutConverter;
import com.liferay.layout.util.LayoutCopyHelper;
import com.liferay.layout.util.template.LayoutConversionResult;
import com.liferay.layout.util.template.LayoutConverter;
import com.liferay.layout.util.template.LayoutConverterRegistry;
import com.liferay.layout.util.template.LayoutData;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletDecorator;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletPreferenceValueLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.ReadOnlyException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BulkLayoutConverter.class})
public class BulkLayoutConverterImpl
implements BulkLayoutConverter {
    private static final Log _log = LogFactoryUtil.getLog(BulkLayoutConverterImpl.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private LayoutConverterRegistry _layoutConverterRegistry;
    @Reference
    private LayoutCopyHelper _layoutCopyHelper;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private PortletPreferenceValueLocalService _portletPreferenceValueLocalService;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void convertLayout(long plid) throws PortalException {
        this._convertLayout(plid);
    }

    public long[] convertLayouts(long groupId) throws PortalException {
        return this.convertLayouts(this.getConvertibleLayoutPlids(groupId));
    }

    public long[] convertLayouts(long[] plids) {
        ArrayList<Long> convertedLayoutPlids = new ArrayList<Long>();
        for (long plid : plids) {
            try {
                ConvertLayoutCallable callable = new ConvertLayoutCallable(plid);
                Layout layout = (Layout)TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)callable);
                convertedLayoutPlids.add(layout.getPlid());
            }
            catch (Throwable throwable) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)String.format("Layout with PLID %s cannot be converted", plid), throwable);
            }
        }
        return ArrayUtil.toLongArray(convertedLayoutPlids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayoutConversionResult generatePreviewLayout(long plid, Locale locale) throws Exception {
        Layout layout = this._layoutLocalService.getLayout(plid);
        if (!Objects.equals(layout.getType(), "portlet")) {
            throw new LayoutConvertException("Layout with PLID " + layout.getPlid() + " is not convertible");
        }
        LayoutConverter layoutConverter = this._getLayoutConversionResult(layout);
        if (!layoutConverter.isConvertible(layout)) {
            throw new LayoutConvertException("Layout with PLID " + layout.getPlid() + " is not convertible");
        }
        ServiceContext serviceContext = Optional.ofNullable(ServiceContextThreadLocal.getServiceContext()).orElse(new ServiceContext());
        serviceContext.setScopeGroupId(layout.getGroupId());
        User user = this._userLocalService.fetchUser(layout.getUserId());
        if (user != null) {
            serviceContext.setUserId(user.getUserId());
        }
        try {
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
            Layout draftLayout = this._getOrCreateDraftLayout(layout, serviceContext);
            LayoutConversionResult layoutConversionResult = layoutConverter.convert(draftLayout, locale);
            this._addOrUpdateLayoutPageTemplateStructure(draftLayout, layoutConversionResult.getLayoutData(), serviceContext);
            draftLayout = this._layoutLocalService.fetchLayout(draftLayout.getPlid());
            this._updatePortletDecorator(draftLayout);
            LayoutConversionResult layoutConversionResult2 = LayoutConversionResult.of(null, (String[])layoutConversionResult.getConversionWarningMessages(), (Layout)draftLayout);
            return layoutConversionResult2;
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
    }

    public long[] getConvertibleLayoutPlids(long groupId) throws PortalException {
        ArrayList convertibleLayoutPlids = new ArrayList();
        ActionableDynamicQuery actionableDynamicQuery = this._layoutLocalService.getActionableDynamicQuery();
        if (groupId > 0L) {
            actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
                dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"groupId", (Object)groupId));
                dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"type", (Object)"portlet"));
                Property property = PropertyFactoryUtil.forName((String)"system");
                dynamicQuery.add(property.eq((Object)false));
            });
            actionableDynamicQuery.setPerformActionMethod(layout -> {
                LayoutConverter layoutConverter;
                UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
                String layoutTemplateId = typeSettingsUnicodeProperties.getProperty("layout-template-id");
                if (layoutTemplateId != null && (layoutConverter = this._layoutConverterRegistry.getLayoutConverter(layoutTemplateId)) != null && layoutConverter.isConvertible(layout)) {
                    convertibleLayoutPlids.add(layout.getPlid());
                }
            });
        }
        actionableDynamicQuery.performActions();
        return ArrayUtil.toLongArray(convertibleLayoutPlids);
    }

    private void _addOrUpdateLayoutPageTemplateStructure(Layout layout, LayoutData layoutData, ServiceContext serviceContext) throws Exception {
        JSONObject layoutDataJSONObject = layoutData.getLayoutDataJSONObject();
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), layout.getPlid());
        long defaultSegmentsExperienceId = this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(layout.getPlid());
        if (layoutPageTemplateStructure == null) {
            this._layoutPageTemplateStructureLocalService.addLayoutPageTemplateStructure(serviceContext.getUserId(), layout.getGroupId(), layout.getPlid(), defaultSegmentsExperienceId, layoutDataJSONObject.toString(), serviceContext);
        }
        this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructureData(layout.getGroupId(), layout.getPlid(), defaultSegmentsExperienceId, layoutDataJSONObject.toString());
    }

    private Layout _convertLayout(long plid) throws PortalException {
        try {
            LayoutConversionResult layoutConversionResult = this.generatePreviewLayout(plid, LocaleUtil.getSiteDefault());
            Layout draftLayout = layoutConversionResult.getDraftLayout();
            Layout layout = this._layoutLocalService.getLayout(draftLayout.getClassPK());
            this._layoutCopyHelper.copyLayout(draftLayout, layout);
            draftLayout = this._layoutLocalService.getLayout(draftLayout.getPlid());
            draftLayout.setLayoutPrototypeLinkEnabled(false);
            UnicodeProperties typeSettingsUnicodeProperties = draftLayout.getTypeSettingsProperties();
            typeSettingsUnicodeProperties.put("published", Boolean.TRUE.toString());
            draftLayout.setStatus(0);
            this._layoutLocalService.updateLayout(draftLayout);
            layout = this._layoutLocalService.getLayout(layout.getPlid());
            layout.setType(draftLayout.getType());
            layout.setLayoutPrototypeUuid("");
            layout.setLayoutPrototypeLinkEnabled(false);
            layout.setStatus(0);
            return this._layoutLocalService.updateLayout(layout);
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
    }

    private String _getDefaultPortletDecoratorId(Layout layout) throws Exception {
        Theme theme = layout.getTheme();
        List portletDecorators = theme.getPortletDecorators();
        Stream portletDecoratorsStream = portletDecorators.stream();
        List filteredPortletDecorators = portletDecoratorsStream.filter(PortletDecorator::isDefaultPortletDecorator).collect(Collectors.toList());
        if (ListUtil.isEmpty(filteredPortletDecorators)) {
            return "";
        }
        PortletDecorator defaultPortletDecorator = (PortletDecorator)filteredPortletDecorators.get(0);
        return defaultPortletDecorator.getPortletDecoratorId();
    }

    private LayoutConverter _getLayoutConversionResult(Layout layout) throws Exception {
        UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
        String layoutTemplateId = typeSettingsUnicodeProperties.getProperty("layout-template-id");
        if (Validator.isNull((String)layoutTemplateId)) {
            throw new LayoutConvertException("Layout template ID cannot be null");
        }
        return this._layoutConverterRegistry.getLayoutConverter(layoutTemplateId);
    }

    private Layout _getOrCreateDraftLayout(Layout layout, ServiceContext serviceContext) throws Exception {
        if (layout.isDraftLayout()) {
            throw new PortalException(StringBundler.concat((Object[])new Object[]{"Layout with PLID ", layout.getPlid(), " is a draft. You cannot get the draft of a draft."}));
        }
        Layout draftLayout = layout.fetchDraftLayout();
        long userId = serviceContext.getUserId();
        User user = this._userLocalService.fetchUser(layout.getUserId());
        if (user != null) {
            userId = user.getUserId();
        }
        if (draftLayout == null) {
            draftLayout = this._layoutLocalService.addLayout(userId, layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), this._classNameLocalService.getClassNameId(Layout.class), layout.getPlid(), layout.getNameMap(), layout.getTitleMap(), layout.getDescriptionMap(), layout.getKeywordsMap(), layout.getRobotsMap(), "content", layout.getTypeSettings(), true, true, Collections.emptyMap(), layout.getMasterLayoutPlid(), serviceContext);
        }
        try {
            return this._layoutCopyHelper.copyLayout(layout, draftLayout);
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
    }

    private void _updatePortletDecorator(Layout layout) throws Exception {
        String defaultPortletDecoratorId = this._getDefaultPortletDecoratorId(layout);
        List portletPreferencesList = this._portletPreferencesLocalService.getPortletPreferences(0L, 3, layout.getPlid());
        for (PortletPreferences portletPreferences : portletPreferencesList) {
            javax.portlet.PortletPreferences jxPortletPreferences = this._portletPreferenceValueLocalService.getPreferences(portletPreferences);
            String portletSetupPortletDecoratorId = jxPortletPreferences.getValue("portletSetupPortletDecoratorId", "");
            if (Validator.isNotNull((String)portletSetupPortletDecoratorId)) continue;
            try {
                jxPortletPreferences.setValue("portletSetupPortletDecoratorId", defaultPortletDecoratorId);
            }
            catch (ReadOnlyException readOnlyException) {
                throw new PortalException((Throwable)readOnlyException);
            }
            this._portletPreferencesLocalService.updatePreferences(portletPreferences.getOwnerId(), portletPreferences.getOwnerType(), portletPreferences.getPlid(), portletPreferences.getPortletId(), jxPortletPreferences);
        }
    }

    private class ConvertLayoutCallable
    implements Callable<Layout> {
        private final long _layoutPlid;

        @Override
        public Layout call() throws PortalException {
            return BulkLayoutConverterImpl.this._convertLayout(this._layoutPlid);
        }

        private ConvertLayoutCallable(Long layoutPlid) {
            this._layoutPlid = layoutPlid;
        }
    }
}

