/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.search.spi.model.index.contributor;

import com.liferay.layout.model.LayoutLocalization;
import com.liferay.layout.service.LayoutLocalizationLocalService;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.portal.kernel.model.Layout"}, service={ModelDocumentContributor.class})
public class LayoutModelDocumentContributor
implements ModelDocumentContributor<Layout> {
    public static final String CLASS_NAME = Layout.class.getName();
    @Reference
    private Language _language;
    @Reference
    private LayoutLocalizationLocalService _layoutLocalizationLocalService;

    public void contribute(Document document, Layout layout) {
        if (layout.isSystem() || layout.getStatus() != 0) {
            return;
        }
        document.addText("defaultLanguageId", layout.getDefaultLanguageId());
        document.addLocalizedText("name", layout.getNameMap());
        document.addText("privateLayout", String.valueOf(layout.isPrivateLayout()));
        document.addKeyword("status", this._getStatus(layout));
        document.addText("type", layout.getType());
        for (String languageId : layout.getAvailableLanguageIds()) {
            Locale locale = LocaleUtil.fromLanguageId((String)languageId);
            document.addText(Field.getLocalizedName((Locale)locale, (String)"title"), layout.getName(locale));
        }
        List layoutLocalizations = this._layoutLocalizationLocalService.getLayoutLocalizations(layout.getPlid());
        for (LayoutLocalization layoutLocalization : layoutLocalizations) {
            document.addText(Field.getLocalizedName((String)layoutLocalization.getLanguageId(), (String)"content"), layoutLocalization.getContent());
        }
    }

    private int _getStatus(Layout layout) {
        if (layout.isPublished()) {
            return 0;
        }
        return 2;
    }
}

