/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.provider;

import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.provider.LayoutStructureProvider;
import com.liferay.layout.util.structure.DropZoneLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.Validator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutStructureProvider.class})
public class LayoutStructureProviderImpl
implements LayoutStructureProvider {
    private static final Log _log = LogFactoryUtil.getLog(LayoutStructureProviderImpl.class);
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;

    public LayoutStructure getLayoutStructure(long plid, long segmentsExperienceId) {
        try {
            Layout layout = this._getLayout(plid);
            LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), layout.getPlid(), true);
            String data = layoutPageTemplateStructure.getData(segmentsExperienceId);
            if (Validator.isNull((String)data)) {
                return null;
            }
            String masterLayoutData = this._getMasterLayoutData(layout.getMasterLayoutPlid());
            if (Validator.isNull((String)masterLayoutData)) {
                return LayoutStructure.of((String)data);
            }
            return this._mergeLayoutStructure(data, masterLayoutData);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get layout structure", (Throwable)exception);
            return null;
        }
    }

    private Layout _getLayout(long plid) {
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        if (layout instanceof VirtualLayout) {
            VirtualLayout virtualLayout = (VirtualLayout)layout;
            layout = virtualLayout.getSourceLayout();
        }
        return layout;
    }

    private String _getMasterLayoutData(long masterLayoutPlid) {
        LayoutPageTemplateEntry masterLayoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(masterLayoutPlid);
        if (masterLayoutPageTemplateEntry == null) {
            return null;
        }
        LayoutPageTemplateStructure masterLayoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(masterLayoutPageTemplateEntry.getGroupId(), masterLayoutPageTemplateEntry.getPlid());
        if (masterLayoutPageTemplateStructure == null) {
            return null;
        }
        return masterLayoutPageTemplateStructure.getDefaultSegmentsExperienceData();
    }

    private LayoutStructure _mergeLayoutStructure(String data, String masterLayoutData) {
        LayoutStructure masterLayoutStructure = LayoutStructure.of((String)masterLayoutData);
        LayoutStructure layoutStructure = LayoutStructure.of((String)data);
        for (LayoutStructureItem layoutStructureItem : layoutStructure.getLayoutStructureItems()) {
            masterLayoutStructure.addLayoutStructureItem(layoutStructureItem);
        }
        DropZoneLayoutStructureItem dropZoneLayoutStructureItem = (DropZoneLayoutStructureItem)masterLayoutStructure.getDropZoneLayoutStructureItem();
        dropZoneLayoutStructureItem.addChildrenItem(layoutStructure.getMainItemId());
        LayoutStructureItem rootStructureItem = masterLayoutStructure.getLayoutStructureItem(layoutStructure.getMainItemId());
        rootStructureItem.setParentItemId(dropZoneLayoutStructureItem.getItemId());
        return masterLayoutStructure;
    }
}

