/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.layout.admin.util;

import com.liferay.layout.admin.kernel.util.Sitemap;
import com.liferay.layout.admin.kernel.util.SitemapURLProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.LayoutTypeControllerTracker;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SitemapURLProvider.class})
public class LayoutSitemapURLProvider
implements SitemapURLProvider {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutService _layoutService;
    @Reference
    private Portal _portal;
    @Reference
    private Sitemap _sitemap;

    public String getClassName() {
        return Layout.class.getName();
    }

    public void visitLayout(Element element, String layoutUuid, LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        Layout layout = this._layoutLocalService.getLayoutByUuidAndGroupId(layoutUuid, layoutSet.getGroupId(), layoutSet.isPrivateLayout());
        this.visitLayout(element, layout, themeDisplay);
    }

    public void visitLayoutSet(Element element, LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        if (layoutSet.isPrivateLayout()) {
            return;
        }
        Map layoutTypeControllers = LayoutTypeControllerTracker.getLayoutTypeControllers();
        for (Map.Entry entry : layoutTypeControllers.entrySet()) {
            LayoutTypeController layoutTypeController = (LayoutTypeController)entry.getValue();
            if (!layoutTypeController.isSitemapable()) continue;
            int start = -1;
            int end = -1;
            int count = this._layoutService.getLayoutsCount(layoutSet.getGroupId(), layoutSet.isPrivateLayout(), (String)entry.getKey());
            if (count > 50000) {
                start = count - 50000;
                end = count;
            }
            List layouts = this._layoutService.getLayouts(layoutSet.getGroupId(), layoutSet.isPrivateLayout(), (String)entry.getKey(), start, end);
            for (Layout layout : layouts) {
                this.visitLayout(element, layout, themeDisplay);
            }
        }
    }

    protected void visitLayout(Element element, Layout layout, ThemeDisplay themeDisplay) throws PortalException {
        if (layout.isSystem()) {
            return;
        }
        UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
        if (!GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("sitemap-include"), (boolean)true) || !layout.isPublished()) {
            return;
        }
        String layoutFullURL = this._portal.getLayoutFullURL(layout, themeDisplay);
        layoutFullURL = this._portal.getCanonicalURL(layoutFullURL, themeDisplay, layout);
        Map alternateURLs = this._sitemap.getAlternateURLs(layoutFullURL, themeDisplay, layout);
        for (String alternateURL : alternateURLs.values()) {
            this._sitemap.addURLElement(element, alternateURL, typeSettingsUnicodeProperties, layout.getModifiedDate(), layoutFullURL, alternateURLs);
        }
    }
}

