/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.importer.structure.util;

import com.liferay.document.library.util.DLURLHelperUtil;
import com.liferay.fragment.contributor.FragmentCollectionContributorRegistry;
import com.liferay.fragment.entry.processor.util.EditableFragmentEntryProcessorUtil;
import com.liferay.fragment.model.FragmentCollection;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.DefaultFragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorContext;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererRegistry;
import com.liferay.fragment.service.FragmentCollectionService;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.fragment.validator.FragmentEntryValidator;
import com.liferay.headless.delivery.dto.v1_0.FragmentLink;
import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.layout.internal.importer.LayoutStructureItemImporterContext;
import com.liferay.layout.internal.importer.helper.PortletConfigurationImporterHelper;
import com.liferay.layout.internal.importer.helper.PortletPermissionsImporterHelper;
import com.liferay.layout.internal.importer.structure.util.BaseLayoutStructureItemImporter;
import com.liferay.layout.internal.importer.structure.util.LayoutStructureItemImporter;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutStructureItemImporter.class})
public class FragmentLayoutStructureItemImporter
extends BaseLayoutStructureItemImporter
implements LayoutStructureItemImporter {
    private static final Log _log = LogFactoryUtil.getLog(FragmentLayoutStructureItemImporter.class);
    private static final Pattern _pattern = Pattern.compile("\\[resources:(.+?)\\]");
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private FragmentCollectionContributorRegistry _fragmentCollectionContributorRegistry;
    @Reference
    private FragmentCollectionService _fragmentCollectionService;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private FragmentEntryProcessorRegistry _fragmentEntryProcessorRegistry;
    @Reference
    private FragmentEntryValidator _fragmentEntryValidator;
    @Reference
    private FragmentRendererRegistry _fragmentRendererRegistry;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private PortletConfigurationImporterHelper _portletConfigurationImporterHelper;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPermissionsImporterHelper _portletPermissionsImporterHelper;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;

    @Override
    public LayoutStructureItem addLayoutStructureItem(LayoutStructure layoutStructure, LayoutStructureItemImporterContext layoutStructureItemImporterContext, PageElement pageElement, Set<String> warningMessages) throws Exception {
        JSONObject jsonObject;
        FragmentEntryLink fragmentEntryLink = this._addFragmentEntryLink(layoutStructureItemImporterContext.getLayout(), layoutStructureItemImporterContext, pageElement, layoutStructureItemImporterContext.getPosition(), warningMessages);
        if (fragmentEntryLink == null) {
            return null;
        }
        FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem = (FragmentStyledLayoutStructureItem)layoutStructure.addFragmentStyledLayoutStructureItem(fragmentEntryLink.getFragmentEntryLinkId(), layoutStructureItemImporterContext.getParentItemId(), layoutStructureItemImporterContext.getPosition());
        Map<String, Object> definitionMap = this.getDefinitionMap(pageElement.getDefinition());
        if (definitionMap == null) {
            return fragmentStyledLayoutStructureItem;
        }
        if (definitionMap.containsKey("cssClasses")) {
            List cssClasses = (List)definitionMap.get("cssClasses");
            fragmentStyledLayoutStructureItem.setCssClasses(new HashSet(cssClasses));
        }
        if (definitionMap.containsKey("customCSS")) {
            fragmentStyledLayoutStructureItem.setCustomCSS(String.valueOf(definitionMap.get("customCSS")));
        }
        if (definitionMap.containsKey("customCSSViewports")) {
            List customCSSViewports = (List)definitionMap.get("customCSSViewports");
            for (Map customCSSViewport : customCSSViewports) {
                fragmentStyledLayoutStructureItem.setCustomCSSViewport((String)customCSSViewport.get("id"), (String)customCSSViewport.get("customCSS"));
            }
        }
        Map fragmentStyleMap = (Map)definitionMap.get("fragmentStyle");
        int oldVersionCompareValue = Double.compare(layoutStructureItemImporterContext.getPageDefinitionVersion(), 1.1);
        if (oldVersionCompareValue < 0) {
            Map fragmentConfigMap = (Map)definitionMap.get("fragmentConfig");
            if (MapUtil.isNotEmpty((Map)fragmentConfigMap) || MapUtil.isNotEmpty((Map)fragmentStyleMap)) {
                JSONObject commonStylesJSONObject = this.toStylesJSONObject(layoutStructureItemImporterContext, fragmentStyleMap);
                JSONObject configStylesJSONObject = this.toStylesJSONObject(layoutStructureItemImporterContext, fragmentConfigMap);
                for (String key : commonStylesJSONObject.keySet()) {
                    if (!Validator.isNull((String)configStylesJSONObject.getString(key))) continue;
                    configStylesJSONObject.put(key, commonStylesJSONObject.get(key));
                }
                jsonObject = JSONUtil.put((String)"styles", (Object)JSONUtil.merge((JSONObject)commonStylesJSONObject, (JSONObject)configStylesJSONObject));
                fragmentStyledLayoutStructureItem.updateItemConfig(jsonObject);
            }
        } else if (fragmentStyleMap != null) {
            JSONObject jsonObject2 = JSONUtil.put((String)"styles", (Object)this.toStylesJSONObject(layoutStructureItemImporterContext, fragmentStyleMap));
            fragmentStyledLayoutStructureItem.updateItemConfig(jsonObject2);
        }
        if (definitionMap.containsKey("fragmentViewports")) {
            List fragmentViewports = (List)definitionMap.get("fragmentViewports");
            for (Map fragmentViewport : fragmentViewports) {
                jsonObject = JSONUtil.put((String)((String)fragmentViewport.get("id")), (Object)this.toFragmentViewportStylesJSONObject(fragmentViewport));
                fragmentStyledLayoutStructureItem.updateItemConfig(jsonObject);
            }
        }
        if (definitionMap.containsKey("indexed")) {
            fragmentStyledLayoutStructureItem.setIndexed(GetterUtil.getBoolean((Object)definitionMap.get("indexed")));
        }
        if (definitionMap.containsKey("name")) {
            fragmentStyledLayoutStructureItem.setName(GetterUtil.getString((Object)definitionMap.get("name")));
        }
        return fragmentStyledLayoutStructureItem;
    }

    @Override
    public PageElement.Type getPageElementType() {
        return PageElement.Type.FRAGMENT;
    }

    private FragmentEntryLink _addFragmentEntryLink(Layout layout, LayoutStructureItemImporterContext layoutStructureItemImporterContext, PageElement pageElement, int position, Set<String> warningMessages) throws Exception {
        long segmentsExperienceId;
        SegmentsExperience segmentsExperience;
        Map<String, Object> definitionMap = this.getDefinitionMap(pageElement.getDefinition());
        if (definitionMap == null) {
            return null;
        }
        Map fragmentDefinitionMap = (Map)definitionMap.get("fragment");
        String fragmentKey = (String)fragmentDefinitionMap.get("key");
        if (Validator.isNull((String)fragmentKey)) {
            return null;
        }
        Group layoutGroup = layout.getGroup();
        long groupId = layoutGroup.getGroupId();
        String groupKey = GetterUtil.getString(fragmentDefinitionMap.get("siteKey"), null);
        boolean useGlobalAsFallback = true;
        if (groupKey != null) {
            useGlobalAsFallback = false;
            Group fragmentEntryGroup = this._groupLocalService.fetchGroup(layout.getCompanyId(), groupKey);
            Company company = this._companyLocalService.fetchCompany(layout.getCompanyId());
            if (fragmentEntryGroup != null && fragmentEntryGroup.getGroupId() == company.getGroupId()) {
                groupId = company.getGroupId();
            }
        }
        FragmentEntry fragmentEntry = this._getFragmentEntry(layout.getCompanyId(), groupId, fragmentKey, useGlobalAsFallback);
        FragmentRenderer fragmentRenderer = this._fragmentRendererRegistry.getFragmentRenderer(fragmentKey);
        if (fragmentEntry == null && fragmentRenderer == null) {
            warningMessages.add(this._getWarningMessage(groupId, fragmentKey));
            return null;
        }
        long fragmentEntryId = 0L;
        if (fragmentEntry != null) {
            fragmentEntryId = fragmentEntry.getFragmentEntryId();
        }
        if ((segmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(segmentsExperienceId = layoutStructureItemImporterContext.getSegmentsExperienceId())) == null) {
            segmentsExperienceId = this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(layout.getPlid());
        }
        String html = "";
        String js = "";
        String css = "";
        String configuration = "";
        int type = 1;
        JSONObject defaultEditableValuesJSONObject = this._jsonFactory.createJSONObject();
        if (fragmentEntry != null) {
            html = fragmentEntry.getHtml();
            js = fragmentEntry.getJs();
            css = fragmentEntry.getCss();
            configuration = fragmentEntry.getConfiguration();
            type = fragmentEntry.getType();
            FragmentCollection fragmentCollection = this._fragmentCollectionService.fetchFragmentCollection(fragmentEntry.getFragmentCollectionId());
            defaultEditableValuesJSONObject = this._fragmentEntryProcessorRegistry.getDefaultEditableValuesJSONObject(this._getProcessedHTML(fragmentEntry.getCompanyId(), configuration, fragmentCollection, html, fragmentKey, type), configuration);
        }
        Map editableTypes = EditableFragmentEntryProcessorUtil.getEditableTypes((String)html);
        JSONObject fragmentEntryProcessorValuesJSONObject = JSONUtil.put((String)"com.liferay.fragment.entry.processor.background.image.BackgroundImageFragmentEntryProcessor", () -> {
            JSONObject backgroundImageFragmentEntryProcessorJSONObject = this._toBackgroundImageFragmentEntryProcessorJSONObject(layoutStructureItemImporterContext, (List)definitionMap.get("fragmentFields"));
            if (backgroundImageFragmentEntryProcessorJSONObject.length() > 0) {
                return backgroundImageFragmentEntryProcessorJSONObject;
            }
            return null;
        }).put("com.liferay.fragment.entry.processor.editable.EditableFragmentEntryProcessor", () -> {
            JSONObject editableFragmentEntryProcessorJSONObject = this._toEditableFragmentEntryProcessorJSONObject(editableTypes, (List)definitionMap.get("fragmentFields"), layoutStructureItemImporterContext);
            if (editableFragmentEntryProcessorJSONObject.length() > 0) {
                return editableFragmentEntryProcessorJSONObject;
            }
            return null;
        });
        JSONObject freeMarkerFragmentEntryProcessorJSONObject = this._toFreeMarkerFragmentEntryProcessorJSONObject(this._getConfigurationTypes(configuration), (Map)definitionMap.get("fragmentConfig"));
        this._fragmentEntryValidator.validateConfigurationValues(configuration, fragmentEntryProcessorValuesJSONObject);
        if (freeMarkerFragmentEntryProcessorJSONObject.length() > 0) {
            fragmentEntryProcessorValuesJSONObject.put("com.liferay.fragment.entry.processor.freemarker.FreeMarkerFragmentEntryProcessor", freeMarkerFragmentEntryProcessorJSONObject);
        }
        JSONObject jsonObject = this._deepMerge(defaultEditableValuesJSONObject, fragmentEntryProcessorValuesJSONObject);
        FragmentEntryLink fragmentEntryLink = this._fragmentEntryLinkLocalService.addFragmentEntryLink(layout.getUserId(), layout.getGroupId(), 0L, fragmentEntryId, segmentsExperienceId, layout.getPlid(), css, html, js, configuration, jsonObject.toString(), StringUtil.randomId(), position, fragmentKey, type, ServiceContextThreadLocal.getServiceContext());
        List widgetInstances = (List)definitionMap.get("widgetInstances");
        if (widgetInstances != null) {
            this._processWidgetInstances(fragmentEntryLink, layout, warningMessages, widgetInstances);
        }
        return fragmentEntryLink;
    }

    private JSONObject _createBaseFragmentFieldJSONObject(LayoutStructureItemImporterContext layoutStructureItemImporterContext, Map<String, Object> map) {
        Map valueI18nMap;
        Map defaultFragmentInlineValueMap;
        String title;
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        if (map == null) {
            return jsonObject;
        }
        Map valueMap = (Map)map.get("value");
        if (valueMap != null && (title = String.valueOf(valueMap.get("title"))) != null) {
            jsonObject.put("defaultValue", title);
        }
        if ((defaultFragmentInlineValueMap = (Map)map.get("defaultFragmentInlineValue")) == null) {
            defaultFragmentInlineValueMap = (Map)map.get("defaultValue");
        }
        if (defaultFragmentInlineValueMap != null) {
            jsonObject.put("defaultValue", defaultFragmentInlineValueMap.get("value"));
        }
        if ((valueI18nMap = (Map)map.get("value_i18n")) != null) {
            for (Map.Entry entry : valueI18nMap.entrySet()) {
                jsonObject.put((String)entry.getKey(), entry.getValue());
            }
            return jsonObject;
        }
        this.processMapping(jsonObject, layoutStructureItemImporterContext, (Map)map.get("mapping"));
        return jsonObject;
    }

    private JSONObject _createFragmentConfigJSONObject(Map<String, Object> fragmentImageMap) {
        Map localizedDescriptionMap;
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        if (fragmentImageMap == null) {
            return jsonObject;
        }
        Map descriptionMap = (Map)fragmentImageMap.get("description");
        if (descriptionMap == null) {
            return jsonObject;
        }
        String value = (String)descriptionMap.get("value");
        if (value != null) {
            jsonObject.put("alt", value);
        }
        if ((localizedDescriptionMap = (Map)descriptionMap.get("value_i18n")) == null) {
            return jsonObject;
        }
        JSONObject localizedDescriptionJSONObject = this._jsonFactory.createJSONObject();
        for (Map.Entry entry : localizedDescriptionMap.entrySet()) {
            localizedDescriptionJSONObject.put((String)entry.getKey(), entry.getValue());
        }
        jsonObject.put("alt", localizedDescriptionJSONObject);
        return jsonObject;
    }

    private JSONObject _createFragmentLinkConfigJSONObject(Map<String, Object> fragmentLinkMap, LayoutStructureItemImporterContext layoutStructureItemImporterContext) {
        JSONObject jsonObject;
        block6: {
            jsonObject = this._jsonFactory.createJSONObject();
            if (fragmentLinkMap == null) {
                return jsonObject;
            }
            Map valueI18nMap = (Map)fragmentLinkMap.get("value_i18n");
            if (valueI18nMap != null) {
                for (Map.Entry entry : valueI18nMap.entrySet()) {
                    Map fragmentLinkValueMap = (Map)entry.getValue();
                    jsonObject.put((String)entry.getKey(), this._createFragmentLinkValueConfigJSONObject(fragmentLinkValueMap, layoutStructureItemImporterContext));
                }
            }
            Map valueMap = (Map)fragmentLinkMap.get("value");
            try {
                if (valueMap != null) {
                    jsonObject = JSONUtil.merge((JSONObject)jsonObject, (JSONObject)this._createFragmentLinkValueConfigJSONObject(valueMap, layoutStructureItemImporterContext));
                }
                jsonObject = JSONUtil.merge((JSONObject)jsonObject, (JSONObject)this._createFragmentLinkValueConfigJSONObject(fragmentLinkMap, layoutStructureItemImporterContext));
            }
            catch (JSONException jsonException) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Throwable)jsonException);
            }
        }
        jsonObject.put("mapperType", "link");
        return jsonObject;
    }

    private JSONObject _createFragmentLinkValueConfigJSONObject(Map<String, Object> fragmentLinkValueMap, LayoutStructureItemImporterContext layoutStructureItemImporterContext) {
        Map valueI18nMap;
        Object value;
        String target;
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        if (fragmentLinkValueMap == null) {
            return jsonObject;
        }
        Map hrefMap = (Map)fragmentLinkValueMap.get("href");
        if (hrefMap == null) {
            return jsonObject;
        }
        Map defaultFragmentInlineValueMap = (Map)hrefMap.get("defaultFragmentInlineValue");
        if (defaultFragmentInlineValueMap == null) {
            defaultFragmentInlineValueMap = (Map)hrefMap.get("defaultValue");
        }
        if ((target = (String)fragmentLinkValueMap.get("target")) != null) {
            if (Objects.equals(target, FragmentLink.Target.PARENT.getValue()) || Objects.equals(target, FragmentLink.Target.TOP.getValue())) {
                target = FragmentLink.Target.SELF.getValue();
            }
            jsonObject.put("target", "_" + StringUtil.lowerCaseFirstLetter((String)target));
        }
        if ((value = hrefMap.get("value")) != null) {
            jsonObject.put("href", value);
            return jsonObject;
        }
        if (defaultFragmentInlineValueMap != null) {
            value = defaultFragmentInlineValueMap.get("value");
        }
        if (value != null) {
            jsonObject.put("href", value);
        }
        if ((valueI18nMap = (Map)hrefMap.get("value_i18n")) != null) {
            jsonObject.put("href", (Object)valueI18nMap);
            return jsonObject;
        }
        this.processMapping(jsonObject, layoutStructureItemImporterContext, (Map)hrefMap.get("mapping"));
        return jsonObject;
    }

    private JSONObject _createImageJSONObject(Map<String, Object> classPKReferencesMap) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        if (classPKReferencesMap == null) {
            return jsonObject;
        }
        for (Map.Entry<String, Object> entry : classPKReferencesMap.entrySet()) {
            Map classPKReferenceMap = (Map)entry.getValue();
            if (!Objects.equals(classPKReferenceMap.get("className"), FileEntry.class.getName())) continue;
            long fileEntryId = GetterUtil.getLong(classPKReferenceMap.get("classPK"));
            try {
                FileEntry fileEntry = this._portletFileRepository.getPortletFileEntry(fileEntryId);
                jsonObject.put(entry.getKey(), JSONUtil.put((String)"fileEntryId", (Object)fileEntryId).put("url", DLURLHelperUtil.getDownloadURL((FileEntry)fileEntry, (FileVersion)fileEntry.getFileVersion(), null, (String)"", (boolean)false, (boolean)false)));
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)"Unable to get file entry", (Throwable)portalException);
            }
        }
        return jsonObject;
    }

    private JSONObject _deepMerge(JSONObject jsonObject1, JSONObject jsonObject2) throws Exception {
        if (jsonObject1 == null) {
            return this._jsonFactory.createJSONObject(jsonObject2.toString());
        }
        if (jsonObject2 == null) {
            return this._jsonFactory.createJSONObject(jsonObject1.toString());
        }
        JSONObject jsonObject3 = this._jsonFactory.createJSONObject(jsonObject1.toString());
        Iterator iterator = jsonObject2.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!jsonObject3.has(key)) {
                jsonObject3.put(key, jsonObject2.get(key));
                continue;
            }
            Object value1 = jsonObject1.get(key);
            Object value2 = jsonObject2.get(key);
            if (value1 instanceof JSONObject && value2 instanceof JSONObject) {
                jsonObject3.put(key, this._deepMerge((JSONObject)value1, jsonObject2.getJSONObject(key)));
                continue;
            }
            jsonObject3.put(key, value2);
        }
        return jsonObject3;
    }

    private Map<String, String> _getConfigurationTypes(String configuration) throws Exception {
        HashMap<String, String> configurationTypes = new HashMap<String, String>();
        JSONObject jsonObject = this._jsonFactory.createJSONObject(configuration);
        JSONArray fieldSetsJSONArray = jsonObject.getJSONArray("fieldSets");
        if (fieldSetsJSONArray == null) {
            return configurationTypes;
        }
        for (int i = 0; i < fieldSetsJSONArray.length(); ++i) {
            JSONObject fieldsJSONObject = fieldSetsJSONArray.getJSONObject(i);
            JSONArray fieldsJSONArray = fieldsJSONObject.getJSONArray("fields");
            for (int j = 0; j < fieldsJSONArray.length(); ++j) {
                JSONObject fieldJSONObject = fieldsJSONArray.getJSONObject(j);
                configurationTypes.put(fieldJSONObject.getString("name"), fieldJSONObject.getString("type"));
            }
        }
        return configurationTypes;
    }

    private FragmentEntry _getFragmentEntry(long companyId, long groupId, String fragmentKey, boolean useGlobalAsFallback) throws Exception {
        FragmentEntry fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(groupId, fragmentKey);
        if (fragmentEntry != null) {
            return fragmentEntry;
        }
        if (useGlobalAsFallback) {
            Company company = this._companyLocalService.getCompanyById(companyId);
            fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(company.getGroupId(), fragmentKey);
        }
        if (fragmentEntry != null) {
            return fragmentEntry;
        }
        return this._fragmentCollectionContributorRegistry.getFragmentEntry(fragmentKey);
    }

    private String _getProcessedHTML(long companyId, String configuration, FragmentCollection fragmentCollection, String html, String rendererKey, int type) throws Exception {
        String processedHTML = this._replaceResources(fragmentCollection, html);
        FragmentEntryLink fragmentEntryLink = this._fragmentEntryLinkLocalService.createFragmentEntryLink(0L);
        fragmentEntryLink.setCompanyId(companyId);
        fragmentEntryLink.setHtml(processedHTML);
        fragmentEntryLink.setConfiguration(configuration);
        fragmentEntryLink.setRendererKey(rendererKey);
        fragmentEntryLink.setType(type);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return processedHTML;
        }
        DefaultFragmentEntryProcessorContext fragmentEntryProcessorContext = new DefaultFragmentEntryProcessorContext(serviceContext.getRequest(), serviceContext.getResponse(), "EDIT", LocaleUtil.getMostRelevantLocale());
        return this._fragmentEntryProcessorRegistry.processFragmentEntryLinkHTML(fragmentEntryLink, (FragmentEntryProcessorContext)fragmentEntryProcessorContext);
    }

    private String _getWarningMessage(long groupId, String fragmentKey) throws Exception {
        Locale locale = null;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        locale = serviceContext != null ? serviceContext.getLocale() : this.portal.getSiteDefaultLocale(groupId);
        return this._language.format(locale, "fragment-with-key-x-was-ignored-because-it-does-not-exist", (Object[])new String[]{fragmentKey});
    }

    private void _processWidgetInstances(FragmentEntryLink fragmentEntryLink, Layout layout, Set<String> warningMessages, List<Object> widgetInstances) throws Exception {
        for (Object widgetInstance : widgetInstances) {
            Map widgetInstanceMap = (Map)widgetInstance;
            String widgetName = (String)widgetInstanceMap.get("widgetName");
            if (Validator.isNull((String)widgetName)) continue;
            String widgetInstanceId = (String)widgetInstanceMap.get("widgetInstanceId");
            if (widgetInstanceId != null) {
                widgetInstanceId = fragmentEntryLink.getNamespace() + widgetInstanceId;
            } else {
                Portlet portlet = this._portletLocalService.getPortletById(widgetName);
                if (portlet != null && portlet.isInstanceable()) {
                    widgetInstanceId = fragmentEntryLink.getNamespace();
                }
            }
            Map widgetConfigDefinitionMap = (Map)widgetInstanceMap.get("widgetConfig");
            this._portletConfigurationImporterHelper.importPortletConfiguration(layout.getPlid(), PortletIdCodec.encode((String)widgetName, (String)widgetInstanceId), widgetConfigDefinitionMap);
            List widgetPermissionsMaps = (List)widgetInstanceMap.get("widgetPermissions");
            this._portletPermissionsImporterHelper.importPortletPermissions(layout.getPlid(), PortletIdCodec.encode((String)widgetName, (String)widgetInstanceId), warningMessages, widgetPermissionsMaps);
        }
    }

    private String _replaceResources(FragmentCollection fragmentCollection, String html) throws Exception {
        if (fragmentCollection == null) {
            return html;
        }
        Matcher matcher = _pattern.matcher(html);
        while (matcher.find()) {
            FileEntry fileEntry = fragmentCollection.getResource(matcher.group(1));
            String fileEntryURL = "";
            if (fileEntry != null) {
                fileEntryURL = DLURLHelperUtil.getDownloadURL((FileEntry)fileEntry, (FileVersion)fileEntry.getFileVersion(), null, (String)"", (boolean)false, (boolean)false);
            }
            html = StringUtil.replace((String)html, (String)matcher.group(), (String)fileEntryURL);
        }
        return html;
    }

    private JSONObject _toBackgroundImageFragmentEntryProcessorJSONObject(LayoutStructureItemImporterContext layoutStructureItemImporterContext, List<Object> fragmentFields) {
        JSONObject backgroundImageFragmentEntryProcessorValuesJSONObject = this._jsonFactory.createJSONObject();
        for (Object fragmentField : fragmentFields) {
            Map fragmentFieldMap = (Map)fragmentField;
            Map fragmentFieldValueMap = (Map)fragmentFieldMap.get("value");
            Map backgroundFragmentImageMap = (Map)fragmentFieldValueMap.get("backgroundFragmentImage");
            if (MapUtil.isEmpty((Map)backgroundFragmentImageMap)) {
                backgroundFragmentImageMap = (Map)fragmentFieldValueMap.get("backgroundImage");
            }
            if (backgroundFragmentImageMap == null) continue;
            Map urlMap = (Map)backgroundFragmentImageMap.get("url");
            JSONObject fragmentFieldValueJSONObject = this._createBaseFragmentFieldJSONObject(layoutStructureItemImporterContext, urlMap);
            Map titleMap = (Map)backgroundFragmentImageMap.get("title");
            if (titleMap != null) {
                fragmentFieldValueJSONObject.put("config", JSONUtil.put((String)"imageTitle", titleMap.get("value")));
            }
            backgroundImageFragmentEntryProcessorValuesJSONObject.put((String)fragmentFieldMap.get("id"), fragmentFieldValueJSONObject);
        }
        return backgroundImageFragmentEntryProcessorValuesJSONObject;
    }

    private JSONObject _toEditableFragmentEntryProcessorJSONObject(Map<String, String> editableTypes, List<Object> fragmentFields, LayoutStructureItemImporterContext layoutStructureItemImporterContext) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        if (fragmentFields == null) {
            return jsonObject;
        }
        for (Object fragmentField : fragmentFields) {
            JSONObject baseFragmentFieldJSONObject;
            JSONObject editableFieldConfigJSONObject;
            String fragmentFieldId;
            JSONObject fragmentFieldJSONObject;
            block16: {
                Map valueMap;
                fragmentFieldJSONObject = this._jsonFactory.createJSONObject();
                Map fragmentFieldMap = (Map)fragmentField;
                fragmentFieldId = (String)fragmentFieldMap.get("id");
                if (Validator.isNull((String)fragmentFieldId) || (valueMap = (Map)fragmentFieldMap.get("value")) == null) continue;
                editableFieldConfigJSONObject = this._createFragmentLinkConfigJSONObject((Map)valueMap.get("fragmentLink"), layoutStructureItemImporterContext);
                baseFragmentFieldJSONObject = this._createBaseFragmentFieldJSONObject(layoutStructureItemImporterContext, (Map)valueMap.get("text"));
                if (Objects.equals(editableTypes.get(fragmentFieldId), "html")) {
                    baseFragmentFieldJSONObject = this._createBaseFragmentFieldJSONObject(layoutStructureItemImporterContext, (Map)valueMap.get("html"));
                }
                if (Objects.equals(editableTypes.get(fragmentFieldId), "image")) {
                    Map fragmentImageMap;
                    block15: {
                        fragmentImageMap = (Map)valueMap.get("fragmentImage");
                        baseFragmentFieldJSONObject = this._jsonFactory.createJSONObject();
                        if (fragmentImageMap != null) {
                            if (fragmentImageMap.containsKey("url")) {
                                baseFragmentFieldJSONObject = this._createBaseFragmentFieldJSONObject(layoutStructureItemImporterContext, (Map)fragmentImageMap.get("url"));
                            }
                            if (fragmentImageMap.containsKey("fragmentImageClassPKReference")) {
                                Map fragmentImageClassPKReferenceMap = (Map)fragmentImageMap.get("fragmentImageClassPKReference");
                                baseFragmentFieldJSONObject = this._createImageJSONObject((Map)fragmentImageClassPKReferenceMap.get("classPKReferences"));
                                Map fragmentImageConfigurationMap = (Map)fragmentImageClassPKReferenceMap.get("fragmentImageConfiguration");
                                JSONObject amImageConfigurationJSONObject = this._jsonFactory.createJSONObject();
                                for (Map.Entry entry : fragmentImageConfigurationMap.entrySet()) {
                                    amImageConfigurationJSONObject.put((String)entry.getKey(), (String)entry.getValue());
                                }
                                try {
                                    editableFieldConfigJSONObject = JSONUtil.merge((JSONObject)editableFieldConfigJSONObject, (JSONObject)JSONUtil.put((String)"imageConfiguration", (Object)amImageConfigurationJSONObject));
                                }
                                catch (JSONException jsonException) {
                                    if (!_log.isWarnEnabled()) break block15;
                                    _log.warn((Throwable)jsonException);
                                }
                            }
                        }
                    }
                    try {
                        editableFieldConfigJSONObject = JSONUtil.merge((JSONObject)editableFieldConfigJSONObject, (JSONObject)this._createFragmentConfigJSONObject(fragmentImageMap));
                    }
                    catch (JSONException jsonException) {
                        if (!_log.isWarnEnabled()) break block16;
                        _log.warn((Throwable)jsonException);
                    }
                }
            }
            if (editableFieldConfigJSONObject.length() > 0) {
                fragmentFieldJSONObject.put("config", editableFieldConfigJSONObject);
            }
            try {
                jsonObject.put(fragmentFieldId, JSONUtil.merge((JSONObject)fragmentFieldJSONObject, (JSONObject)baseFragmentFieldJSONObject));
            }
            catch (JSONException jsonException) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Throwable)jsonException);
            }
        }
        return jsonObject;
    }

    private JSONObject _toFreeMarkerFragmentEntryProcessorJSONObject(Map<String, String> configurationTypes, Map<String, Object> fragmentConfigMap) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        if (fragmentConfigMap == null) {
            return jsonObject;
        }
        for (Map.Entry<String, Object> entry : fragmentConfigMap.entrySet()) {
            if (entry.getValue() instanceof HashMap) {
                Map childFragmentConfigMap = (Map)entry.getValue();
                jsonObject.put(entry.getKey(), this._toFreeMarkerFragmentEntryProcessorJSONObject(configurationTypes, childFragmentConfigMap));
                continue;
            }
            String type = configurationTypes.get(entry.getKey());
            if (Objects.equals(type, "colorPalette")) {
                jsonObject.put(entry.getKey(), JSONUtil.put((String)"color", (Object)entry.getValue()));
                continue;
            }
            jsonObject.put(entry.getKey(), entry.getValue());
        }
        return jsonObject;
    }
}

