/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.importer.structure.util;

import com.liferay.fragment.contributor.FragmentCollectionContributor;
import com.liferay.fragment.contributor.FragmentCollectionContributorRegistry;
import com.liferay.fragment.model.FragmentCollection;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererRegistry;
import com.liferay.fragment.service.FragmentCollectionLocalService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.layout.internal.importer.LayoutStructureItemImporterContext;
import com.liferay.layout.internal.importer.exception.DropzoneLayoutStructureItemException;
import com.liferay.layout.internal.importer.structure.util.BaseLayoutStructureItemImporter;
import com.liferay.layout.internal.importer.structure.util.LayoutStructureItemImporter;
import com.liferay.layout.util.structure.DropZoneLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutStructureItemImporter.class})
public class DropZoneLayoutStructureItemImporter
extends BaseLayoutStructureItemImporter
implements LayoutStructureItemImporter {
    private static final String _KEY_ALLOWED_FRAGMENTS = "allowedFragments";
    private static final String _KEY_KEY = "key";
    private static final String _KEY_UNALLOWED_FRAGMENTS = "unallowedFragments";
    @Reference
    private FragmentCollectionContributorRegistry _fragmentCollectionContributorRegistry;
    @Reference
    private FragmentCollectionLocalService _fragmentCollectionLocalService;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private FragmentRendererRegistry _fragmentRendererRegistry;

    @Override
    public LayoutStructureItem addLayoutStructureItem(LayoutStructure layoutStructure, LayoutStructureItemImporterContext layoutStructureItemImporterContext, PageElement pageElement, Set<String> warningMessages) throws Exception {
        LayoutStructureItem existingLayoutStructureItem = layoutStructure.getDropZoneLayoutStructureItem();
        if (existingLayoutStructureItem != null) {
            throw new DropzoneLayoutStructureItemException();
        }
        DropZoneLayoutStructureItem dropZoneLayoutStructureItem = (DropZoneLayoutStructureItem)layoutStructure.addDropZoneLayoutStructureItem(layoutStructureItemImporterContext.getParentItemId(), layoutStructureItemImporterContext.getPosition());
        Map<String, Object> definitionMap = this.getDefinitionMap(pageElement.getDefinition());
        if (definitionMap == null) {
            return dropZoneLayoutStructureItem;
        }
        Object fragmentSettings = definitionMap.get("fragmentSettings");
        Map fragmentSettingsMap = (Map)fragmentSettings;
        if (fragmentSettingsMap == null) {
            return dropZoneLayoutStructureItem;
        }
        if (!fragmentSettingsMap.containsKey(_KEY_ALLOWED_FRAGMENTS) && !fragmentSettingsMap.containsKey(_KEY_UNALLOWED_FRAGMENTS) || fragmentSettingsMap.containsKey(_KEY_ALLOWED_FRAGMENTS) && fragmentSettingsMap.containsKey(_KEY_UNALLOWED_FRAGMENTS)) {
            return dropZoneLayoutStructureItem;
        }
        HashSet<Object> fragmentEntryKeys = new HashSet<Object>();
        HashSet<String> fragmentCollectionKeys = new HashSet<String>();
        ArrayList allowedFragments = new ArrayList();
        if (fragmentSettingsMap.containsKey(_KEY_ALLOWED_FRAGMENTS)) {
            dropZoneLayoutStructureItem.setAllowNewFragmentEntries(false);
            allowedFragments.addAll((List)fragmentSettingsMap.get(_KEY_ALLOWED_FRAGMENTS));
        }
        if (fragmentSettingsMap.containsKey(_KEY_UNALLOWED_FRAGMENTS)) {
            dropZoneLayoutStructureItem.setAllowNewFragmentEntries(true);
            allowedFragments.addAll((List)fragmentSettingsMap.get(_KEY_UNALLOWED_FRAGMENTS));
        }
        Layout layout = layoutStructureItemImporterContext.getLayout();
        for (Map allowedFragmentMap : allowedFragments) {
            fragmentEntryKeys.add(allowedFragmentMap.get(_KEY_KEY));
            String fragmentCollectionKey = this._getFragmentCollectionKey((String)allowedFragmentMap.get(_KEY_KEY), layout.getGroupId());
            if (!Validator.isNotNull((String)fragmentCollectionKey)) continue;
            fragmentCollectionKeys.add(fragmentCollectionKey);
        }
        for (String fragmentCollectionKey : fragmentCollectionKeys) {
            fragmentEntryKeys.add(fragmentCollectionKey);
        }
        dropZoneLayoutStructureItem.setFragmentEntryKeys(new ArrayList(fragmentEntryKeys));
        return dropZoneLayoutStructureItem;
    }

    @Override
    public PageElement.Type getPageElementType() {
        return PageElement.Type.DROP_ZONE;
    }

    private String _getFragmentCollectionKey(String fragmentKey, long groupId) throws Exception {
        FragmentEntry fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(groupId, fragmentKey);
        if (fragmentEntry != null) {
            FragmentCollection fragmentCollection = this._fragmentCollectionLocalService.getFragmentCollection(fragmentEntry.getFragmentCollectionId());
            return fragmentCollection.getFragmentCollectionKey();
        }
        List fragmentCollectionContributors = this._fragmentCollectionContributorRegistry.getFragmentCollectionContributors();
        for (FragmentCollectionContributor fragmentCollectionContributor : fragmentCollectionContributors) {
            String fragmentCollectionKey = fragmentCollectionContributor.getFragmentCollectionKey();
            if (!fragmentKey.startsWith(fragmentCollectionKey + "-")) continue;
            return fragmentCollectionKey;
        }
        FragmentRenderer fragmentRenderer = this._fragmentRendererRegistry.getFragmentRenderer(fragmentKey);
        if (fragmentRenderer != null) {
            return fragmentRenderer.getCollectionKey();
        }
        return null;
    }
}

