/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.importer.structure.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.headless.delivery.dto.v1_0.ContextReference;
import com.liferay.info.exception.NoSuchFormVariationException;
import com.liferay.info.field.InfoField;
import com.liferay.info.form.InfoForm;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemFormProvider;
import com.liferay.info.search.InfoSearchClassMapperRegistry;
import com.liferay.layout.internal.importer.LayoutStructureItemImporterContext;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseLayoutStructureItemImporter {
    @Reference
    protected GroupLocalService groupLocalService;
    @Reference
    protected InfoItemServiceRegistry infoItemServiceRegistry;
    @Reference
    protected InfoSearchClassMapperRegistry infoSearchClassMapperRegistry;
    @Reference
    protected LayoutLocalService layoutLocalService;
    @Reference
    protected LayoutPageTemplateEntryLocalService layoutPageTemplateEntryLocalService;
    @Reference
    protected Portal portal;
    private static final String[] _ALIGN_KEYS = new String[]{"buttonAlign", "contentAlign", "imageAlign", "textAlign"};
    private static final Log _log = LogFactoryUtil.getLog(BaseLayoutStructureItemImporter.class);
    private static final Map<String, String> _borderRadiuses = HashMapBuilder.put((Object)"lg", (Object)"0.375rem").put((Object)"none", (Object)"").put((Object)"sm", (Object)"0.1875rem").build();
    private static final Map<String, String> _colors = HashMapBuilder.put((Object)"danger", (Object)"#DA1414").put((Object)"dark", (Object)"#272833").put((Object)"gray-dark", (Object)"#393A4A").put((Object)"info", (Object)"#2E5AAC").put((Object)"light", (Object)"#F1F2F5").put((Object)"lighter", (Object)"#F7F8F9").put((Object)"primary", (Object)"#0B5FFF").put((Object)"secondary", (Object)"#6B6C7E").put((Object)"success", (Object)"#287D3C").put((Object)"warning", (Object)"#B95000").put((Object)"white", (Object)"#FFFFFF").build();
    private static final ObjectMapper _objectMapper = new ObjectMapper();
    private static final Map<String, String> _shadows = HashMapBuilder.put((Object)"lg", (Object)"0 1rem 3rem rgba(0, 0, 0, .175)").put((Object)"sm", (Object)"0 .125rem .25rem rgba(0, 0, 0, .075)").build();

    public JSONObject getLayoutFromItemReferenceJSONObject(Map<String, Object> itemReferenceMap, LayoutStructureItemImporterContext layoutStructureItemImporterContext) {
        String friendlyURL = null;
        Boolean privatePage = null;
        String siteKey = null;
        List fields = (List)itemReferenceMap.get("fields");
        for (Map field : fields) {
            String key = (String)field.get("fieldName");
            if (Objects.equals(key, "friendlyURL")) {
                friendlyURL = (String)field.get("fieldValue");
                continue;
            }
            if (Objects.equals(key, "privatePage")) {
                privatePage = Boolean.valueOf((String)field.get("fieldValue"));
                continue;
            }
            if (!Objects.equals(key, "siteKey")) continue;
            siteKey = (String)field.get("fieldValue");
        }
        if (friendlyURL == null || privatePage == null) {
            return null;
        }
        Layout currentLayout = layoutStructureItemImporterContext.getLayout();
        long groupId = currentLayout.getGroupId();
        if (Validator.isNotNull(siteKey)) {
            Group group = this.groupLocalService.fetchGroup(currentLayout.getCompanyId(), siteKey);
            if (group == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to process mapping because group ", siteKey, " does not exist"}));
                }
                return null;
            }
            groupId = group.getGroupId();
        }
        Layout layout = this.layoutLocalService.fetchLayoutByFriendlyURL(groupId, privatePage.booleanValue(), friendlyURL);
        return this._getLayoutJSONObject("friendlyURL", friendlyURL, layout);
    }

    protected Map<String, Object> getDefinitionMap(Object definition) throws Exception {
        Map definitionMap = null;
        definitionMap = definition instanceof Map ? (Map)definition : (Map)_objectMapper.readValue(definition.toString(), Map.class);
        return definitionMap;
    }

    protected Object getLocalizedValue(Map<String, Object> map) {
        Map localizedValuesMap = (Map)map.get("value_i18n");
        if (localizedValuesMap != null) {
            JSONObject localizedValueJSONObject = JSONFactoryUtil.createJSONObject();
            for (Map.Entry entry : localizedValuesMap.entrySet()) {
                localizedValueJSONObject.put((String)entry.getKey(), entry.getValue());
            }
            return localizedValueJSONObject;
        }
        return map.get("value");
    }

    protected void processMapping(JSONObject jsonObject, LayoutStructureItemImporterContext layoutStructureItemImporterContext, Map<String, Object> map) {
        String className;
        if (map == null) {
            return;
        }
        String fieldKey = (String)map.get("fieldKey");
        Map itemReferenceMap = (Map)map.get("itemReference");
        if (itemReferenceMap == null) {
            return;
        }
        String contextSource = (String)itemReferenceMap.get("contextSource");
        if (Objects.equals(ContextReference.ContextSource.COLLECTION_ITEM.getValue(), contextSource)) {
            jsonObject.put("collectionFieldId", fieldKey);
            return;
        }
        if (Objects.equals(ContextReference.ContextSource.DISPLAY_PAGE_ITEM.getValue(), contextSource)) {
            if (this._isValidInfoField(fieldKey, layoutStructureItemImporterContext)) {
                jsonObject.put("mappedField", fieldKey);
            }
            return;
        }
        if (Validator.isNotNull((String)fieldKey)) {
            jsonObject.put("fieldId", fieldKey);
        }
        if (Objects.equals(className = (String)itemReferenceMap.get("className"), Layout.class.getName()) && Objects.equals(itemReferenceMap.get("fieldName"), "plid")) {
            String fieldValue = (String)itemReferenceMap.get("fieldValue");
            Layout layout = this.layoutLocalService.fetchLayout(GetterUtil.getLong((String)fieldValue));
            jsonObject.put("layout", this._getLayoutJSONObject("PLID", fieldValue, layout));
            return;
        }
        if (Objects.equals(className, Layout.class.getName()) && itemReferenceMap.containsKey("fields")) {
            jsonObject.put("layout", this.getLayoutFromItemReferenceJSONObject(itemReferenceMap, layoutStructureItemImporterContext));
        }
        String classNameId = null;
        try {
            classNameId = String.valueOf(this.portal.getClassNameId(className));
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to process mapping because class name ID could not be obtained for class name " + className), (Throwable)exception);
            }
            return;
        }
        String classPK = String.valueOf(itemReferenceMap.get("classPK"));
        if (Validator.isNotNull((String)classNameId) && Validator.isNotNull((String)classPK)) {
            jsonObject.put("classNameId", classNameId).put("classPK", classPK);
        }
    }

    protected JSONObject toFragmentViewportStylesJSONObject(Map<String, Object> fragmentViewport) {
        if (MapUtil.isEmpty(fragmentViewport)) {
            return JSONFactoryUtil.createJSONObject();
        }
        Map fragmentViewportStyle = (Map)fragmentViewport.get("fragmentViewportStyle");
        if (MapUtil.isEmpty((Map)fragmentViewportStyle)) {
            return JSONFactoryUtil.createJSONObject();
        }
        return JSONUtil.put((String)"styles", (Object)JSONUtil.put((String)"backgroundColor", fragmentViewportStyle.get("backgroundColor")).put("borderColor", fragmentViewportStyle.get("borderColor")).put("borderRadius", fragmentViewportStyle.get("borderRadius")).put("borderWidth", fragmentViewportStyle.get("borderWidth")).put("display", () -> {
            Object hidden = fragmentViewportStyle.get("hidden");
            if (hidden != null) {
                if (GetterUtil.getBoolean(hidden)) {
                    return "none";
                }
                return "block";
            }
            return null;
        }).put("fontFamily", fragmentViewportStyle.get("fontFamily")).put("fontSize", fragmentViewportStyle.get("fontSize")).put("fontWeight", fragmentViewportStyle.get("fontWeight")).put("height", fragmentViewportStyle.get("height")).put("marginBottom", fragmentViewportStyle.get("marginBottom")).put("marginLeft", fragmentViewportStyle.get("marginLeft")).put("marginRight", fragmentViewportStyle.get("marginRight")).put("marginTop", fragmentViewportStyle.get("marginTop")).put("maxHeight", fragmentViewportStyle.get("maxHeight")).put("maxWidth", fragmentViewportStyle.get("maxWidth")).put("minHeight", fragmentViewportStyle.get("minHeight")).put("minWidth", fragmentViewportStyle.get("minWidth")).put("opacity", fragmentViewportStyle.get("opacity")).put("overflow", fragmentViewportStyle.get("overflow")).put("paddingBottom", fragmentViewportStyle.get("paddingBottom")).put("paddingLeft", fragmentViewportStyle.get("paddingLeft")).put("paddingRight", fragmentViewportStyle.get("paddingRight")).put("paddingTop", fragmentViewportStyle.get("paddingTop")).put("shadow", fragmentViewportStyle.get("shadow")).put("textAlign", fragmentViewportStyle.get("textAlign")).put("textColor", fragmentViewportStyle.get("textColor")).put("width", fragmentViewportStyle.get("width")));
    }

    protected JSONObject toStylesJSONObject(LayoutStructureItemImporterContext layoutStructureItemImporterContext, Map<String, Object> styles) {
        Object textColor;
        Object borderColor;
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (MapUtil.isEmpty(styles)) {
            return jsonObject;
        }
        jsonObject.put("backgroundColor", styles.get("backgroundColor"));
        if (styles.containsKey("backgroundFragmentImage") || styles.containsKey("backgroundImage")) {
            JSONObject backgroundImageJSONObject = JSONFactoryUtil.createJSONObject();
            Map childStyleMap = (Map)styles.get("backgroundFragmentImage");
            if (MapUtil.isEmpty((Map)childStyleMap)) {
                childStyleMap = (Map)styles.get("backgroundImage");
            }
            if (MapUtil.isNotEmpty((Map)childStyleMap)) {
                Map urlMap;
                Map titleMap = (Map)childStyleMap.get("title");
                if (titleMap != null) {
                    backgroundImageJSONObject.put("title", this.getLocalizedValue(titleMap));
                }
                if ((urlMap = (Map)childStyleMap.get("url")) != null) {
                    backgroundImageJSONObject.put("url", this.getLocalizedValue(urlMap));
                    this.processMapping(backgroundImageJSONObject, layoutStructureItemImporterContext, (Map)urlMap.get("mapping"));
                }
                jsonObject.put("backgroundImage", backgroundImageJSONObject);
            }
        }
        if ((borderColor = styles.get("borderColor")) instanceof String) {
            borderColor = _colors.getOrDefault(borderColor, (String)borderColor);
        }
        String borderRadius = GetterUtil.getString((Object)styles.get("borderRadius"));
        boolean hidden = GetterUtil.getBoolean((Object)styles.get("hidden"));
        if (hidden) {
            jsonObject.put("display", "none");
        }
        Object shadow = styles.getOrDefault("boxShadow", styles.get("shadow"));
        String textAlign = GetterUtil.getString((Object)styles.get("textAlign"));
        if (Validator.isNull((String)textAlign)) {
            for (String alignKey : _ALIGN_KEYS) {
                if (!styles.containsKey(alignKey)) continue;
                textAlign = GetterUtil.getString((Object)styles.get(alignKey));
                break;
            }
        }
        if ((textColor = styles.get("textColor")) instanceof String) {
            textColor = _colors.getOrDefault(textColor, (String)textColor);
        }
        return jsonObject.put("borderColor", borderColor).put("borderRadius", _borderRadiuses.getOrDefault(borderRadius, borderRadius)).put("borderWidth", styles.get("borderWidth")).put("fontFamily", styles.get("fontFamily")).put("fontSize", styles.get("fontSize")).put("fontWeight", styles.get("fontWeight")).put("height", styles.get("height")).put("marginBottom", styles.get("marginBottom")).put("marginLeft", styles.get("marginLeft")).put("marginRight", styles.get("marginRight")).put("marginTop", styles.get("marginTop")).put("maxHeight", styles.get("maxHeight")).put("maxWidth", styles.get("maxWidth")).put("minHeight", styles.get("minHeight")).put("minWidth", styles.get("minWidth")).put("opacity", styles.get("opacity")).put("overflow", styles.get("overflow")).put("paddingBottom", styles.get("paddingBottom")).put("paddingLeft", styles.get("paddingLeft")).put("paddingRight", styles.get("paddingRight")).put("paddingTop", styles.get("paddingTop")).put("shadow", _shadows.getOrDefault(shadow, GetterUtil.getString((Object)shadow))).put("textAlign", textAlign).put("textColor", textColor).put("width", styles.get("width"));
    }

    private JSONObject _getLayoutJSONObject(String fieldKey, String fieldValue, Layout layout) {
        if (layout == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to process mapping because layout could not ", "be obtained for ", fieldKey, " ", fieldValue}));
            }
            return JSONFactoryUtil.createJSONObject();
        }
        return JSONUtil.put((String)"groupId", (Object)String.valueOf(layout.getGroupId())).put("id", layout.getUuid()).put("layoutId", String.valueOf(layout.getLayoutId())).put("layoutUuid", layout.getUuid()).put("privateLayout", layout.isPrivateLayout()).put("title", layout.getName(LocaleUtil.getMostRelevantLocale())).put("value", layout.getFriendlyURL());
    }

    private boolean _isValidInfoField(String fieldKey, LayoutStructureItemImporterContext layoutStructureItemImporterContext) {
        block8: {
            Layout layout = layoutStructureItemImporterContext.getLayout();
            if (!layout.isTypeAssetDisplay()) {
                return false;
            }
            if (layout.isDraftLayout()) {
                layout = this.layoutLocalService.fetchLayout(layout.getClassPK());
            }
            if (layout == null) {
                return false;
            }
            LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(layout.getPlid());
            if (layoutPageTemplateEntry == null) {
                return false;
            }
            InfoItemFormProvider infoItemFormProvider = (InfoItemFormProvider)this.infoItemServiceRegistry.getFirstInfoItemService(InfoItemFormProvider.class, this.infoSearchClassMapperRegistry.getClassName(this.portal.getClassName(layoutPageTemplateEntry.getClassNameId())));
            if (infoItemFormProvider == null) {
                return false;
            }
            try {
                InfoForm infoForm = infoItemFormProvider.getInfoForm(String.valueOf(layoutPageTemplateEntry.getClassTypeId()), layout.getGroupId());
                InfoField infoField = infoForm.getInfoField(fieldKey);
                if (infoField != null) {
                    return true;
                }
            }
            catch (NoSuchFormVariationException noSuchFormVariationException) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Throwable)noSuchFormVariationException);
            }
        }
        return false;
    }
}

