/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.importer.helper;

import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.ResourceActionModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.permission.PortletPermission;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortletPermissionsImporterHelper.class})
public class PortletPermissionsImporterHelper {
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPermission _portletPermission;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourcePermissionService _resourcePermissionService;
    @Reference
    private RoleLocalService _roleLocalService;

    public void importPortletPermissions(long plid, String portletId, Set<String> warningMessages, List<Map<String, Object>> widgetPermissionsMaps) throws Exception {
        if (widgetPermissionsMaps == null) {
            return;
        }
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        if (layout == null) {
            return;
        }
        String portletName = PortletIdCodec.decodePortletName((String)portletId);
        Portlet portlet = this._portletLocalService.getPortletById(portletName);
        if (portlet == null) {
            return;
        }
        HashMap<Long, String[]> roleIdsToActionIds = new HashMap<Long, String[]>();
        for (Map<String, Object> widgetPermissionsMap : widgetPermissionsMaps) {
            String roleKey = (String)widgetPermissionsMap.get("roleKey");
            Role role = this._roleLocalService.fetchRole(layout.getCompanyId(), roleKey);
            if (role == null && (role = this._getTeamRole(layout, roleKey)) == null) {
                warningMessages.add(this._getWarningMessage(layout.getGroupId(), roleKey));
                continue;
            }
            Group group = this._groupLocalService.getGroup(layout.getGroupId());
            if (role.getType() == 3 && !group.isOrganization()) {
                warningMessages.add(this._getWarningMessage(layout.getGroupId(), roleKey));
                continue;
            }
            List resourceActions = this._resourceActionLocalService.getResourceActions(portletName);
            if (ListUtil.isEmpty((List)resourceActions)) continue;
            ArrayList<String> actionIds = new ArrayList<String>();
            Stream stream = resourceActions.stream();
            List resourceActionsIds = stream.map(ResourceActionModel::getActionId).collect(Collectors.toList());
            List actionKeys = (List)widgetPermissionsMap.get("actionKeys");
            for (String actionKey : actionKeys) {
                if (!resourceActionsIds.contains(actionKey)) continue;
                actionIds.add(actionKey);
            }
            if (!ListUtil.isNotEmpty(actionIds)) continue;
            roleIdsToActionIds.put(role.getRoleId(), actionIds.toArray(new String[0]));
        }
        if (MapUtil.isNotEmpty(roleIdsToActionIds)) {
            String resourcePrimKey = this._portletPermission.getPrimaryKey(plid, portletId);
            this._resourcePermissionService.setIndividualResourcePermissions(layout.getGroupId(), layout.getCompanyId(), portletName, resourcePrimKey, roleIdsToActionIds);
        }
    }

    private Role _getTeamRole(Layout layout, String roleKey) throws Exception {
        Map teamRoleMap = this._roleLocalService.getTeamRoleMap(layout.getGroupId());
        for (Map.Entry entry : teamRoleMap.entrySet()) {
            Team team = (Team)entry.getKey();
            if (!Objects.equals(team.getName(), roleKey)) continue;
            return (Role)entry.getValue();
        }
        return null;
    }

    private String _getWarningMessage(long groupId, String roleKey) throws Exception {
        Locale locale = null;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        locale = serviceContext != null ? serviceContext.getLocale() : this._portal.getSiteDefaultLocale(groupId);
        return this._language.format(locale, "role-with-key-x-was-ignored-because-it-does-not-exist", (Object[])new String[]{roleKey});
    }
}

