/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.importer;

import com.liferay.layout.importer.PortletPreferencesPortletConfigurationImporter;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import java.util.Map;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortletPreferencesPortletConfigurationImporter.class})
public class PortletPreferencesPortletConfigurationImporterImpl
implements PortletPreferencesPortletConfigurationImporter {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;

    public void importPortletConfiguration(long plid, String portletId, Map<String, Object> portletConfiguration) throws Exception {
        if (portletConfiguration == null) {
            return;
        }
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        if (layout == null) {
            return;
        }
        String portletName = PortletIdCodec.decodePortletName((String)portletId);
        Portlet portlet = this._portletLocalService.getPortletById(portletName);
        if (portlet == null) {
            return;
        }
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromXML((long)layout.getCompanyId(), (long)0L, (int)3, (long)layout.getPlid(), (String)portletId, (String)portlet.getDefaultPreferences());
        for (Map.Entry<String, Object> entrySet : portletConfiguration.entrySet()) {
            portletPreferences.setValue(entrySet.getKey(), (String)entrySet.getValue());
        }
        String portletPreferencesXML = PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
        com.liferay.portal.kernel.model.PortletPreferences persistedPortletPreferences = this._portletPreferencesLocalService.fetchPortletPreferences(0L, 3, layout.getPlid(), portletId);
        if (persistedPortletPreferences == null) {
            this._portletPreferencesLocalService.addPortletPreferences(layout.getCompanyId(), 0L, 3, layout.getPlid(), portletId, null, portletPreferencesXML);
        } else {
            this._portletPreferencesLocalService.updatePreferences(0L, 3, layout.getPlid(), portletId, portletPreferencesXML);
        }
    }
}

