/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.layout.model.LayoutLocalization;
import com.liferay.layout.service.LayoutLocalizationLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutLocalizationStagedModelDataHandler.class, StagedModelDataHandler.class})
public class LayoutLocalizationStagedModelDataHandler
extends BaseStagedModelDataHandler<LayoutLocalization> {
    public static final String[] CLASS_NAMES = new String[]{LayoutLocalization.class.getName()};
    @Reference
    private LayoutLocalizationLocalService _layoutLocalizationLocalService;
    @Reference(target="(model.class.name=com.liferay.layout.model.LayoutLocalization)", unbind="-")
    private StagedModelRepository<LayoutLocalization> _stagedModelRepository;

    public void deleteStagedModel(LayoutLocalization layoutLocalization) throws PortalException {
        this._stagedModelRepository.deleteStagedModel((StagedModel)layoutLocalization);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        this._stagedModelRepository.deleteStagedModel(uuid, groupId, className, extraData);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, LayoutLocalization layoutLocalization) throws Exception {
        Element element = portletDataContext.getExportDataElement((ClassedModel)layoutLocalization);
        portletDataContext.addClassedModel(element, ExportImportPathUtil.getModelPath((StagedModel)layoutLocalization), (ClassedModel)layoutLocalization);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long layoutLocalizationId) throws Exception {
        LayoutLocalization existingLayoutLocalization = (LayoutLocalization)this.fetchMissingReference(uuid, groupId);
        if (existingLayoutLocalization == null) {
            return;
        }
        Map layoutLocalizationIds = portletDataContext.getNewPrimaryKeysMap(LayoutLocalization.class);
        layoutLocalizationIds.put(layoutLocalizationId, existingLayoutLocalization.getLayoutLocalizationId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, LayoutLocalization layoutLocalization) throws Exception {
        LayoutLocalization importedLayoutLocalization = (LayoutLocalization)layoutLocalization.clone();
        importedLayoutLocalization.setGroupId(portletDataContext.getScopeGroupId());
        importedLayoutLocalization.setCompanyId(portletDataContext.getCompanyId());
        Map plids = portletDataContext.getNewPrimaryKeysMap(Layout.class);
        long plid = MapUtil.getLong((Map)plids, (long)layoutLocalization.getPlid(), (long)layoutLocalization.getPlid());
        importedLayoutLocalization.setPlid(plid);
        LayoutLocalization existingLayoutLocalization = this._layoutLocalizationLocalService.fetchLayoutLocalization(portletDataContext.getGroupId(), layoutLocalization.getLanguageId(), plid);
        if (existingLayoutLocalization == null) {
            existingLayoutLocalization = (LayoutLocalization)this._stagedModelRepository.fetchStagedModelByUuidAndGroupId(layoutLocalization.getUuid(), portletDataContext.getScopeGroupId());
        }
        if (existingLayoutLocalization == null || !portletDataContext.isDataStrategyMirror()) {
            importedLayoutLocalization = (LayoutLocalization)this._stagedModelRepository.addStagedModel(portletDataContext, (StagedModel)importedLayoutLocalization);
        } else {
            importedLayoutLocalization.setMvccVersion(existingLayoutLocalization.getMvccVersion());
            importedLayoutLocalization.setLayoutLocalizationId(existingLayoutLocalization.getLayoutLocalizationId());
            importedLayoutLocalization = (LayoutLocalization)this._stagedModelRepository.updateStagedModel(portletDataContext, (StagedModel)importedLayoutLocalization);
        }
        portletDataContext.importClassedModel((ClassedModel)layoutLocalization, (ClassedModel)importedLayoutLocalization);
    }

    protected StagedModelRepository<LayoutLocalization> getStagedModelRepository() {
        return this._stagedModelRepository;
    }
}

