/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.action.provider;

import com.liferay.application.list.GroupProvider;
import com.liferay.asset.list.model.AssetListEntry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SessionClicks;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.site.navigation.model.SiteNavigationMenu;
import com.liferay.site.navigation.service.SiteNavigationMenuLocalService;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class LayoutActionProvider {
    private String _backURL;
    private Long _groupId;
    private final GroupProvider _groupProvider;
    private final HttpServletRequest _httpServletRequest;
    private final Language _language;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final String _namespace;
    private String _pageTypeSelectedOption;
    private String _redirect;
    private final SiteNavigationMenuLocalService _siteNavigationMenuLocalService;
    private final ThemeDisplay _themeDisplay;

    public LayoutActionProvider(HttpServletRequest httpServletRequest, Language language, SiteNavigationMenuLocalService siteNavigationMenuLocalService) {
        this._httpServletRequest = httpServletRequest;
        this._language = language;
        this._siteNavigationMenuLocalService = siteNavigationMenuLocalService;
        this._groupProvider = (GroupProvider)httpServletRequest.getAttribute("GROUP_PROVIDER");
        this._liferayPortletRequest = PortalUtil.getLiferayPortletRequest((PortletRequest)((PortletRequest)httpServletRequest.getAttribute("javax.portlet.request")));
        this._namespace = PortalUtil.getPortletNamespace((String)"com_liferay_product_navigation_product_menu_web_portlet_ProductMenuPortlet");
        this._themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public JSONArray getActionsJSONArray(Layout layout) throws Exception {
        JSONArray itemsJSONArray = JSONFactoryUtil.createJSONArray();
        if (this._isShowPreviewDraftAction(layout)) {
            itemsJSONArray.put(JSONUtil.put((String)"href", (Object)PortalUtil.getLayoutFriendlyURL((Layout)layout.fetchDraftLayout(), (ThemeDisplay)this._themeDisplay)).put("id", "preview-draft").put("label", this._language.get(this._themeDisplay.getLocale(), "preview-draft")).put("symbolRight", "shortcut").put("target", "_blank").put("type", "item"));
        }
        HashMap valuesMap = HashMapBuilder.put((Object)"collectionPK", (Object)layout.getTypeSettingsProperty("collectionPK")).put((Object)"collectionType", (Object)layout.getTypeSettingsProperty("collectionType")).put((Object)"plid", (Object)String.valueOf(layout.getPlid())).build();
        if (!layout.isTypeCollection() && Validator.isNotNull((String)this._getAddChildURLTemplate())) {
            itemsJSONArray.put(JSONUtil.put((String)"href", (Object)StringUtil.replace((String)this._getAddChildURLTemplate(), (String)"{", (String)"}", (Map)valuesMap)).put("id", "add-child-page").put("label", this._language.get(this._themeDisplay.getLocale(), "add-child-page")).put("type", "item"));
        }
        if (!layout.isTypeCollection() && Validator.isNotNull((String)this._getAddChildCollectionURLTemplate())) {
            itemsJSONArray.put(JSONUtil.put((String)"href", (Object)StringUtil.replace((String)this._getAddChildCollectionURLTemplate(), (String)"{", (String)"}", (Map)valuesMap)).put("id", "add-child-collection-page").put("label", this._language.get(this._themeDisplay.getLocale(), "add-child-collection-page")).put("type", "item"));
        }
        itemsJSONArray.put(JSONUtil.put((String)"href", (Object)StringUtil.replace((String)this._getConfigureLayoutURLTemplate(), (String)"{", (String)"}", (Map)valuesMap)).put("id", "configure").put("label", this._language.get(this._themeDisplay.getLocale(), "configure")).put("symbolLeft", "cog").put("type", "item"));
        if (layout.isTypeCollection() && Validator.isNotNull((String)this._getViewCollectionItemsURL())) {
            itemsJSONArray.put(JSONUtil.put((String)"data", (Object)JSONUtil.put((String)"id", (Object)"view-collection-items").put("modalTitle", this._language.get(this._themeDisplay.getLocale(), "view-items")).put("url", StringUtil.replace((String)this._getViewCollectionItemsURL(), (String)"{", (String)"}", (Map)valuesMap))).put("href", "#").put("id", "view-collection-items").put("label", this._language.get(this._themeDisplay.getLocale(), "view-collection-items")).put("target", "_blank").put("type", "item"));
        }
        return JSONUtil.putAll((Object[])new Object[]{JSONUtil.put((String)"items", (Object)itemsJSONArray).put("type", "group")});
    }

    private String _getAddChildCollectionURLTemplate() throws Exception {
        PortletURL addChildCollectionURL = this._getAddCollectionLayoutURL();
        if (addChildCollectionURL == null) {
            return "";
        }
        return StringBundler.concat((Object[])new Object[]{addChildCollectionURL, "&", "p_r_p_", "selPlid={plid}"});
    }

    private String _getAddChildURLTemplate() throws Exception {
        PortletURL addLayoutURL = this._getAddLayoutURL();
        if (addLayoutURL == null) {
            return "";
        }
        return StringBundler.concat((Object[])new Object[]{addLayoutURL, "&", "p_r_p_", "selPlid={plid}"});
    }

    private PortletURL _getAddCollectionLayoutURL() throws Exception {
        Group scopeGroup = this._themeDisplay.getScopeGroup();
        if (scopeGroup.isStaged() && !scopeGroup.isStagingGroup()) {
            return null;
        }
        return PortletURLBuilder.create((PortletURL)PortalUtil.getControlPanelPortletURL((PortletRequest)this._liferayPortletRequest, (String)"com_liferay_layout_admin_web_portlet_GroupPagesPortlet", (String)"RENDER_PHASE")).setMVCPath("/select_layout_collections.jsp").setRedirect(this._getRedirect()).setBackURL(this._getBackURL()).setParameter("groupId", (Object)this._themeDisplay.getSiteGroupId()).setParameter("privateLayout", (Object)this._isPrivateLayout()).buildPortletURL();
    }

    private PortletURL _getAddLayoutURL() throws Exception {
        Group scopeGroup = this._themeDisplay.getScopeGroup();
        if (scopeGroup.isStaged() && !scopeGroup.isStagingGroup()) {
            return null;
        }
        return PortletURLBuilder.create((PortletURL)PortalUtil.getControlPanelPortletURL((PortletRequest)this._liferayPortletRequest, (String)"com_liferay_layout_admin_web_portlet_GroupPagesPortlet", (String)"RENDER_PHASE")).setMVCPath("/select_layout_page_template_entry.jsp").setRedirect(this._getRedirect()).setBackURL(this._getBackURL()).setParameter("groupId", (Object)this._themeDisplay.getSiteGroupId()).setParameter("privateLayout", (Object)this._isPrivateLayout()).buildPortletURL();
    }

    private String _getBackURL() {
        if (this._backURL != null) {
            return this._backURL;
        }
        String backURL = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"backURL");
        if (Validator.isNull((String)backURL)) {
            backURL = ParamUtil.getString((HttpServletRequest)PortalUtil.getOriginalServletRequest((HttpServletRequest)this._httpServletRequest), (String)"backURL", (String)this._themeDisplay.getURLCurrent());
        }
        this._backURL = backURL;
        return backURL;
    }

    private String _getConfigureLayoutURL() throws Exception {
        PortletURL configureLayoutURL = PortletURLBuilder.create((PortletURL)PortalUtil.getControlPanelPortletURL((PortletRequest)this._liferayPortletRequest, (String)"com_liferay_layout_admin_web_portlet_GroupPagesPortlet", (String)"RENDER_PHASE")).setMVCRenderCommandName("/layout_admin/edit_layout").buildPortletURL();
        Layout layout = this._themeDisplay.getLayout();
        if (layout.isTypeAssetDisplay() || layout.isTypeControlPanel()) {
            String redirect = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"redirect", (String)this._themeDisplay.getURLCurrent());
            configureLayoutURL.setParameter("redirect", redirect);
            configureLayoutURL.setParameter("backURL", redirect);
        } else {
            configureLayoutURL.setParameter("redirect", PortalUtil.getLayoutFullURL((Layout)layout, (ThemeDisplay)this._themeDisplay));
            configureLayoutURL.setParameter("backURL", PortalUtil.getLayoutFullURL((Layout)layout, (ThemeDisplay)this._themeDisplay));
        }
        configureLayoutURL.setParameter("groupId", String.valueOf(this._themeDisplay.getScopeGroupId()));
        configureLayoutURL.setParameter("privateLayout", String.valueOf(this._isPrivateLayout()));
        return configureLayoutURL.toString();
    }

    private String _getConfigureLayoutURLTemplate() throws Exception {
        return StringBundler.concat((String[])new String[]{this._getConfigureLayoutURL(), "&", "p_r_p_", "selPlid={plid}"});
    }

    private long _getGroupId() {
        if (this._groupId != null) {
            return this._groupId;
        }
        Group group = this._groupProvider.getGroup(this._httpServletRequest);
        this._groupId = group != null ? Long.valueOf(group.getGroupId()) : Long.valueOf(this._themeDisplay.getSiteGroupId());
        return this._groupId;
    }

    private String _getPageTypeSelectedOption() {
        if (this._pageTypeSelectedOption != null) {
            return this._pageTypeSelectedOption;
        }
        String pageTypeSelectedOption = "PUBLIC_LAYOUT";
        String pageTypeSelectedOptionSessionValue = SessionClicks.get((HttpServletRequest)this._httpServletRequest, (String)(this._namespace + "PAGE_TYPE_SELECTED_OPTION"), (String)"PUBLIC_LAYOUT");
        if (this._isValidPageTypeSelectedOption(pageTypeSelectedOptionSessionValue)) {
            pageTypeSelectedOption = pageTypeSelectedOptionSessionValue;
        }
        this._pageTypeSelectedOption = pageTypeSelectedOption;
        return this._pageTypeSelectedOption;
    }

    private String _getRedirect() {
        if (this._redirect != null) {
            return this._redirect;
        }
        String redirect = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"redirect");
        if (Validator.isNull((String)redirect)) {
            redirect = PortalUtil.escapeRedirect((String)this._getBackURL());
        }
        this._redirect = redirect;
        return this._redirect;
    }

    private String _getViewCollectionItemsURL() throws Exception {
        PortletURL portletURL = PortletProviderUtil.getPortletURL((PortletRequest)this._liferayPortletRequest, (String)AssetListEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.BROWSE);
        if (portletURL == null) {
            return "";
        }
        Layout layout = this._themeDisplay.getLayout();
        String redirect = PortalUtil.getLayoutRelativeURL((Layout)this._themeDisplay.getLayout(), (ThemeDisplay)this._themeDisplay);
        if (layout.isTypeAssetDisplay() || layout.isTypeControlPanel()) {
            redirect = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"redirect", (String)redirect);
        }
        portletURL.setParameter("redirect", redirect);
        portletURL.setParameter("showActions", String.valueOf(Boolean.TRUE));
        portletURL.setWindowState(LiferayWindowState.POP_UP);
        return StringBundler.concat((Object[])new Object[]{portletURL, "&", PortalUtil.getPortletNamespace((String)"com_liferay_asset_list_web_portlet_AssetListPortlet"), "collectionPK={collectionPK}&", PortalUtil.getPortletNamespace((String)"com_liferay_asset_list_web_portlet_AssetListPortlet"), "collectionType={collectionType}"});
    }

    private boolean _isPageHierarchyOption(String pageTypeOption) {
        return Objects.equals(pageTypeOption, "PUBLIC_LAYOUT") || Objects.equals(pageTypeOption, "PRIVATE_LAYOUT");
    }

    private boolean _isPrivateLayout() {
        return Objects.equals("PRIVATE_LAYOUT", this._getPageTypeSelectedOption());
    }

    private boolean _isShowPreviewDraftAction(Layout layout) throws Exception {
        if (!layout.isTypeContent() || !LayoutPermissionUtil.contains((PermissionChecker)this._themeDisplay.getPermissionChecker(), (Layout)layout, (String)"UPDATE")) {
            return false;
        }
        Layout draftLayout = layout.fetchDraftLayout();
        if (draftLayout == null) {
            return false;
        }
        return draftLayout.isDraft() || !layout.isPublished();
    }

    private boolean _isValidPageTypeSelectedOption(String pageTypeSelectedOption) {
        if (this._isPageHierarchyOption(pageTypeSelectedOption)) {
            return true;
        }
        long siteNavigationMenuId = GetterUtil.getLong((String)pageTypeSelectedOption);
        SiteNavigationMenu siteNavigationMenu = this._siteNavigationMenuLocalService.fetchSiteNavigationMenu(siteNavigationMenuId);
        return siteNavigationMenu != null && siteNavigationMenu.getGroupId() == this._getGroupId();
    }
}

