/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.util;

import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.model.FragmentEntryLinkModel;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.layout.model.LayoutClassedModelUsage;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.layout.util.LayoutCopyHelper;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.PortletPreferencesModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import com.liferay.sites.kernel.util.Sites;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={LayoutCopyHelper.class})
public class LayoutCopyHelperImpl
implements LayoutCopyHelper {
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private CommentManager _commentManager;
    @Reference
    private CounterLocalService _counterLocalService;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private LayoutSEOEntryLocalService _layoutSEOEntryLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private PortletRegistry _portletRegistry;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    @Reference
    private Sites _sites;

    public Layout copyLayout(Layout sourceLayout, Layout targetLayout) throws Exception {
        CopyLayoutCallable callable = new CopyLayoutCallable(sourceLayout, targetLayout);
        ServiceContext currentServiceContext = ServiceContextThreadLocal.getServiceContext();
        try {
            Layout layout = (Layout)TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)callable);
            return layout;
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
        finally {
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)currentServiceContext);
        }
    }

    private void _copyAssetCategoryIdsAndAssetTagNames(Layout sourceLayout, Layout targetLayout) throws Exception {
        if (this._isDraft(sourceLayout)) {
            return;
        }
        long[] assetCategoryIds = this._assetCategoryLocalService.getCategoryIds(Layout.class.getName(), sourceLayout.getPlid());
        String[] assetTagNames = this._assetTagLocalService.getTagNames(Layout.class.getName(), sourceLayout.getPlid());
        Layout layout = targetLayout;
        if (this._isDraft(targetLayout)) {
            layout = this._layoutLocalService.getLayout(targetLayout.getClassPK());
        }
        this._layoutLocalService.updateAsset(layout.getUserId(), layout, assetCategoryIds, assetTagNames);
    }

    private void _copyLayoutPageTemplateStructure(Layout sourceLayout, Layout targetLayout) throws Exception {
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(sourceLayout.getGroupId(), sourceLayout.getPlid());
        if (layoutPageTemplateStructure == null) {
            LayoutPageTemplateStructure targetLayoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(targetLayout.getGroupId(), targetLayout.getPlid());
            if (targetLayoutPageTemplateStructure != null) {
                this._layoutPageTemplateStructureLocalService.deleteLayoutPageTemplateStructure(targetLayoutPageTemplateStructure);
            }
            this._fragmentEntryLinkLocalService.deleteLayoutPageTemplateEntryFragmentEntryLinks(targetLayout.getGroupId(), targetLayout.getPlid());
            layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.rebuildLayoutPageTemplateStructure(sourceLayout.getGroupId(), sourceLayout.getPlid());
        }
        ServiceContext serviceContext = Optional.ofNullable(ServiceContextThreadLocal.getServiceContext()).orElse(new ServiceContext());
        List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinksByPlid(sourceLayout.getGroupId(), sourceLayout.getPlid());
        Stream stream = fragmentEntryLinks.stream();
        Map<Long, FragmentEntryLink> fragmentEntryLinkMap = stream.collect(Collectors.toMap(FragmentEntryLinkModel::getFragmentEntryLinkId, fragmentEntryLink -> fragmentEntryLink));
        this._fragmentEntryLinkLocalService.deleteLayoutPageTemplateEntryFragmentEntryLinks(targetLayout.getGroupId(), targetLayout.getPlid());
        LayoutPageTemplateStructure targetLayoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(targetLayout.getGroupId(), targetLayout.getPlid());
        if (targetLayoutPageTemplateStructure == null) {
            this._layoutPageTemplateStructureLocalService.addLayoutPageTemplateStructure(targetLayout.getUserId(), targetLayout.getGroupId(), targetLayout.getPlid(), null, serviceContext);
        }
        Map<Long, Long> segmentsExperienceIds = this._getSegmentsExperienceIds(sourceLayout, targetLayout, serviceContext);
        for (Map.Entry<Long, Long> entry : segmentsExperienceIds.entrySet()) {
            this._copyLayoutPageTemplateStructureExperience(layoutPageTemplateStructure, entry.getKey(), targetLayout, fragmentEntryLinkMap, entry.getValue(), serviceContext);
        }
        List sourceLayoutLayoutClassedModelUsages = this._layoutClassedModelUsageLocalService.getLayoutClassedModelUsagesByPlid(sourceLayout.getPlid());
        this._deleteLayoutClassedModelUsages(sourceLayoutLayoutClassedModelUsages, targetLayout);
        List targetLayoutLayoutClassedModelUsages = this._layoutClassedModelUsageLocalService.getLayoutClassedModelUsagesByPlid(targetLayout.getPlid());
        for (LayoutClassedModelUsage sourceLayoutLayoutClassedModelUsage : sourceLayoutLayoutClassedModelUsages) {
            if (this._hasLayoutClassedModelUsage(targetLayoutLayoutClassedModelUsages, sourceLayoutLayoutClassedModelUsage)) continue;
            this._layoutClassedModelUsageLocalService.addLayoutClassedModelUsage(sourceLayoutLayoutClassedModelUsage.getGroupId(), sourceLayoutLayoutClassedModelUsage.getClassNameId(), sourceLayoutLayoutClassedModelUsage.getClassPK(), sourceLayoutLayoutClassedModelUsage.getContainerKey(), sourceLayoutLayoutClassedModelUsage.getContainerType(), targetLayout.getPlid(), serviceContext);
        }
    }

    private void _copyLayoutPageTemplateStructureExperience(LayoutPageTemplateStructure layoutPageTemplateStructure, long segmentsExperienceId, Layout targetLayout, Map<Long, FragmentEntryLink> fragmentEntryLinkMap, long targetSegmentsExperienceId, ServiceContext serviceContext) throws Exception {
        String data = layoutPageTemplateStructure.getData(segmentsExperienceId);
        if (Validator.isNull((String)data)) {
            return;
        }
        JSONObject dataJSONObject = this._processDataJSONObject(data, targetLayout, fragmentEntryLinkMap, targetSegmentsExperienceId, serviceContext);
        this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructureData(targetLayout.getGroupId(), targetLayout.getPlid(), targetSegmentsExperienceId, dataJSONObject.toString());
    }

    private void _copyPortletPermissions(Layout sourceLayout, Layout targetLayout) throws Exception {
        if (Objects.equals(sourceLayout.getType(), "portlet")) {
            this._sites.copyPortletPermissions(targetLayout, sourceLayout);
            return;
        }
        if (!sourceLayout.isTypeAssetDisplay() && !sourceLayout.isTypeContent()) {
            return;
        }
        this._deletePortletPermissions(targetLayout);
        List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinksByPlid(sourceLayout.getGroupId(), sourceLayout.getPlid());
        for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
            List portletIds = this._portletRegistry.getFragmentEntryLinkPortletIds(fragmentEntryLink);
            for (String portletId : portletIds) {
                Group targetGroup = targetLayout.getGroup();
                String resourceName = PortletIdCodec.decodePortletName((String)portletId);
                String sourceResourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)sourceLayout.getPlid(), (String)portletId);
                String targetResourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)targetLayout.getPlid(), (String)portletId);
                List actionIds = ResourceActionsUtil.getPortletResourceActions((String)resourceName);
                List roles = this._roleLocalService.getGroupRelatedRoles(targetLayout.getGroupId());
                for (Role role : roles) {
                    String roleName = role.getName();
                    if (roleName.equals("Administrator") || !targetGroup.isLayoutSetPrototype() && targetLayout.isPrivateLayout() && roleName.equals("Guest")) continue;
                    List actions = this._resourcePermissionLocalService.getAvailableResourcePermissionActionIds(targetLayout.getCompanyId(), resourceName, 4, sourceResourcePrimKey, role.getRoleId(), (Collection)actionIds);
                    this._resourcePermissionLocalService.setResourcePermissions(targetLayout.getCompanyId(), resourceName, 4, targetResourcePrimKey, role.getRoleId(), actions.toArray(new String[0]));
                }
            }
        }
    }

    private void _copyPortletPreferences(Layout sourceLayout, Layout targetLayout) throws Exception {
        List portletPreferencesList = this._portletPreferencesLocalService.getPortletPreferences(0L, 3, sourceLayout.getPlid());
        List targetPortletPreferencesList = this._portletPreferencesLocalService.getPortletPreferences(0L, 3, targetLayout.getPlid());
        Stream targetPortletPreferencesStream = targetPortletPreferencesList.stream();
        List targetPortletIds = targetPortletPreferencesStream.map(PortletPreferencesModel::getPortletId).collect(Collectors.toList());
        for (PortletPreferences portletPreferences : portletPreferencesList) {
            Portlet portlet = this._portletLocalService.getPortletById(portletPreferences.getPortletId());
            if (portlet == null || portlet.isUndeployedPortlet()) continue;
            targetPortletIds.remove(portletPreferences.getPortletId());
            PortletPreferences targetPortletPreferences = this._portletPreferencesLocalService.fetchPortletPreferences(0L, 3, targetLayout.getPlid(), portletPreferences.getPortletId());
            if (targetPortletPreferences != null) {
                targetPortletPreferences.setPreferences(portletPreferences.getPreferences());
                this._portletPreferencesLocalService.updatePortletPreferences(targetPortletPreferences);
                continue;
            }
            this._portletPreferencesLocalService.addPortletPreferences(targetLayout.getCompanyId(), 0L, 3, targetLayout.getPlid(), portletPreferences.getPortletId(), this._portletLocalService.getPortletById(portletPreferences.getPortletId()), portletPreferences.getPreferences());
        }
        for (String portletId : targetPortletIds) {
            this._portletPreferencesLocalService.deletePortletPreferences(0L, 3, targetLayout.getPlid(), portletId);
        }
    }

    private void _deleteLayoutClassedModelUsages(List<LayoutClassedModelUsage> sourceLayoutLayoutClassedModelUsages, Layout targetLayout) {
        List targetLayoutClassedModelUsages = this._layoutClassedModelUsageLocalService.getLayoutClassedModelUsagesByPlid(targetLayout.getPlid());
        for (LayoutClassedModelUsage targetLayoutClassedModelUsage : targetLayoutClassedModelUsages) {
            if (this._hasLayoutClassedModelUsage(sourceLayoutLayoutClassedModelUsages, targetLayoutClassedModelUsage)) continue;
            this._layoutClassedModelUsageLocalService.deleteLayoutClassedModelUsage(targetLayoutClassedModelUsage);
        }
    }

    private void _deletePortletPermissions(Layout layout) throws Exception {
        List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinksByPlid(layout.getGroupId(), layout.getPlid());
        for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
            List portletIds = this._portletRegistry.getFragmentEntryLinkPortletIds(fragmentEntryLink);
            for (String portletId : portletIds) {
                String resourceName = PortletIdCodec.decodePortletName((String)portletId);
                String resourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
                this._resourcePermissionLocalService.deleteResourcePermissions(layout.getCompanyId(), resourceName, 4, resourcePrimKey);
            }
        }
    }

    private Map<Long, Long> _getSegmentsExperienceIds(Layout sourceLayout, Layout targetLayout, ServiceContext serviceContext) {
        HashMap<Long, Long> segmentsExperienceIds = new HashMap<Long, Long>();
        List segmentsExperiences = this._segmentsExperienceLocalService.getSegmentsExperiences(sourceLayout.getGroupId(), this._portal.getClassNameId(Layout.class), sourceLayout.getPlid());
        for (SegmentsExperience segmentsExperience : segmentsExperiences) {
            SegmentsExperience existingSegmentsExperience;
            if (this._isDraft(sourceLayout) && sourceLayout.getClassPK() == targetLayout.getPlid()) {
                segmentsExperienceIds.put(segmentsExperience.getSegmentsExperienceId(), segmentsExperience.getSegmentsExperienceId());
                continue;
            }
            long plid = targetLayout.getPlid();
            if (this._isDraft(targetLayout)) {
                plid = targetLayout.getClassPK();
            }
            if ((existingSegmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(segmentsExperience.getGroupId(), this._portal.getClassNameId(Layout.class), plid, segmentsExperience.getPriority())) != null) {
                segmentsExperienceIds.put(segmentsExperience.getSegmentsExperienceId(), existingSegmentsExperience.getSegmentsExperienceId());
                continue;
            }
            SegmentsExperience newSegmentsExperience = (SegmentsExperience)segmentsExperience.clone();
            newSegmentsExperience.setUuid(serviceContext.getUuid());
            newSegmentsExperience.setSegmentsExperienceId(this._counterLocalService.increment());
            newSegmentsExperience.setUserId(targetLayout.getUserId());
            newSegmentsExperience.setUserName(targetLayout.getUserName());
            newSegmentsExperience.setCreateDate(serviceContext.getCreateDate(new Date()));
            newSegmentsExperience.setModifiedDate(serviceContext.getModifiedDate(new Date()));
            newSegmentsExperience.setSegmentsExperienceKey(String.valueOf(this._counterLocalService.increment()));
            newSegmentsExperience.setClassNameId(this._portal.getClassNameId(Layout.class));
            newSegmentsExperience.setClassPK(plid);
            this._segmentsExperienceLocalService.addSegmentsExperience(newSegmentsExperience);
            segmentsExperienceIds.put(segmentsExperience.getSegmentsExperienceId(), newSegmentsExperience.getSegmentsExperienceId());
        }
        segmentsExperienceIds.put(0L, 0L);
        return segmentsExperienceIds;
    }

    private boolean _hasLayoutClassedModelUsage(List<LayoutClassedModelUsage> layoutClassedModelUsages, LayoutClassedModelUsage targetLayoutClassedModelUsage) {
        for (LayoutClassedModelUsage layoutClassedModelUsage : layoutClassedModelUsages) {
            if (layoutClassedModelUsage.getClassNameId() != targetLayoutClassedModelUsage.getClassNameId() || layoutClassedModelUsage.getClassPK() != targetLayoutClassedModelUsage.getClassPK() || !Objects.equals(layoutClassedModelUsage.getContainerKey(), targetLayoutClassedModelUsage.getContainerKey()) || layoutClassedModelUsage.getContainerType() != targetLayoutClassedModelUsage.getContainerType()) continue;
            return true;
        }
        return false;
    }

    private boolean _isDraft(Layout layout) {
        if (layout.getClassPK() <= 0L) {
            return false;
        }
        return layout.getClassNameId() == this._portal.getClassNameId(Layout.class.getName());
    }

    private JSONObject _processDataJSONObject(String data, Layout targetLayout, Map<Long, FragmentEntryLink> fragmentEntryLinkMap, long targetSegmentsExperienceId, ServiceContext serviceContext) throws Exception {
        LayoutStructure layoutStructure = LayoutStructure.of((String)data);
        for (LayoutStructureItem layoutStructureItem : layoutStructure.getLayoutStructureItems()) {
            FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem;
            FragmentEntryLink fragmentEntryLink;
            if (!(layoutStructureItem instanceof FragmentStyledLayoutStructureItem) || (fragmentEntryLink = fragmentEntryLinkMap.get((fragmentStyledLayoutStructureItem = (FragmentStyledLayoutStructureItem)layoutStructureItem).getFragmentEntryLinkId())) == null) continue;
            FragmentEntryLink newFragmentEntryLink = (FragmentEntryLink)fragmentEntryLink.clone();
            newFragmentEntryLink.setUuid(serviceContext.getUuid());
            newFragmentEntryLink.setFragmentEntryLinkId(this._counterLocalService.increment());
            newFragmentEntryLink.setUserId(targetLayout.getUserId());
            newFragmentEntryLink.setUserName(targetLayout.getUserName());
            newFragmentEntryLink.setCreateDate(serviceContext.getCreateDate(new Date()));
            newFragmentEntryLink.setModifiedDate(serviceContext.getModifiedDate(new Date()));
            newFragmentEntryLink.setSegmentsExperienceId(targetSegmentsExperienceId);
            newFragmentEntryLink.setClassNameId(this._portal.getClassNameId(Layout.class));
            newFragmentEntryLink.setClassPK(targetLayout.getPlid());
            newFragmentEntryLink.setPlid(targetLayout.getPlid());
            newFragmentEntryLink.setLastPropagationDate(serviceContext.getCreateDate(new Date()));
            newFragmentEntryLink = this._fragmentEntryLinkLocalService.addFragmentEntryLink(newFragmentEntryLink);
            fragmentStyledLayoutStructureItem.setFragmentEntryLinkId(newFragmentEntryLink.getFragmentEntryLinkId());
            this._commentManager.copyDiscussion(targetLayout.getUserId(), targetLayout.getGroupId(), FragmentEntryLink.class.getName(), fragmentEntryLink.getFragmentEntryLinkId(), newFragmentEntryLink.getFragmentEntryLinkId(), className -> serviceContext);
        }
        return layoutStructure.toJSONObject();
    }

    private class CopyLayoutCallable
    implements Callable<Layout> {
        private final Layout _sourceLayout;
        private final Layout _targetLayout;

        @Override
        public Layout call() throws Exception {
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            if (serviceContext == null) {
                serviceContext = new ServiceContext();
                ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
            }
            LayoutCopyHelperImpl.this._sites.copyExpandoBridgeAttributes(this._sourceLayout, this._targetLayout);
            LayoutCopyHelperImpl.this._sites.copyLookAndFeel(this._targetLayout, this._sourceLayout);
            LayoutCopyHelperImpl.this._sites.copyPortletSetups(this._sourceLayout, this._targetLayout);
            LayoutCopyHelperImpl.this._copyAssetCategoryIdsAndAssetTagNames(this._sourceLayout, this._targetLayout);
            LayoutCopyHelperImpl.this._copyLayoutPageTemplateStructure(this._sourceLayout, this._targetLayout);
            LayoutCopyHelperImpl.this._copyPortletPermissions(this._sourceLayout, this._targetLayout);
            LayoutCopyHelperImpl.this._copyPortletPreferences(this._sourceLayout, this._targetLayout);
            LayoutCopyHelperImpl.this._layoutLocalService.updateMasterLayoutPlid(this._targetLayout.getGroupId(), this._targetLayout.isPrivateLayout(), this._targetLayout.getLayoutId(), this._sourceLayout.getMasterLayoutPlid());
            LayoutCopyHelperImpl.this._layoutLocalService.updateStyleBookEntryId(this._targetLayout.getGroupId(), this._targetLayout.isPrivateLayout(), this._targetLayout.getLayoutId(), this._sourceLayout.getStyleBookEntryId());
            UnicodeProperties unicodeProperties = new UnicodeProperties();
            unicodeProperties.load(this._sourceLayout.getTypeSettings());
            if (this._sourceLayout.getClassNameId() == LayoutCopyHelperImpl.this._portal.getClassNameId(Layout.class) && this._targetLayout.getPlid() == this._sourceLayout.getClassPK()) {
                unicodeProperties.put("published", Boolean.TRUE.toString());
                LayoutCopyHelperImpl.this._layoutLocalService.updateLayout(this._sourceLayout.getGroupId(), this._sourceLayout.isPrivateLayout(), this._sourceLayout.getLayoutId(), unicodeProperties.toString());
            }
            LayoutCopyHelperImpl.this._layoutLocalService.updateLayout(this._targetLayout.getGroupId(), this._targetLayout.isPrivateLayout(), this._targetLayout.getLayoutId(), unicodeProperties.toString());
            this._targetLayout.setType(this._sourceLayout.getType());
            Image image = LayoutCopyHelperImpl.this._imageLocalService.getImage(this._sourceLayout.getIconImageId());
            byte[] imageBytes = null;
            if (image != null) {
                imageBytes = image.getTextObj();
            }
            serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
            LayoutSEOEntry layoutSEOEntry = LayoutCopyHelperImpl.this._layoutSEOEntryLocalService.fetchLayoutSEOEntry(this._sourceLayout.getGroupId(), this._sourceLayout.isPrivateLayout(), this._sourceLayout.getLayoutId());
            if (layoutSEOEntry == null) {
                LayoutSEOEntry targetLayoutSEOEntry = LayoutCopyHelperImpl.this._layoutSEOEntryLocalService.fetchLayoutSEOEntry(this._targetLayout.getGroupId(), this._targetLayout.isPrivateLayout(), this._targetLayout.getLayoutId());
                if (targetLayoutSEOEntry != null) {
                    LayoutCopyHelperImpl.this._layoutSEOEntryLocalService.deleteLayoutSEOEntry(this._targetLayout.getGroupId(), this._targetLayout.isPrivateLayout(), this._targetLayout.getLayoutId());
                }
            } else {
                LayoutCopyHelperImpl.this._layoutSEOEntryLocalService.updateLayoutSEOEntry(this._targetLayout.getUserId(), this._targetLayout.getGroupId(), this._targetLayout.isPrivateLayout(), this._targetLayout.getLayoutId(), layoutSEOEntry.isCanonicalURLEnabled(), layoutSEOEntry.getCanonicalURLMap(), layoutSEOEntry.isOpenGraphDescriptionEnabled(), layoutSEOEntry.getOpenGraphDescriptionMap(), layoutSEOEntry.getOpenGraphImageAltMap(), layoutSEOEntry.getOpenGraphImageFileEntryId(), layoutSEOEntry.isOpenGraphTitleEnabled(), layoutSEOEntry.getOpenGraphTitleMap(), serviceContext);
            }
            return LayoutCopyHelperImpl.this._layoutLocalService.updateIconImage(this._targetLayout.getPlid(), imageBytes);
        }

        private CopyLayoutCallable(Layout sourceLayout, Layout targetLayout) {
            this._sourceLayout = sourceLayout;
            this._targetLayout = targetLayout;
        }
    }
}

