/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.security.permission.resource;

import com.liferay.layout.model.LayoutClassedModelUsage;
import com.liferay.layout.security.permission.resource.LayoutContentModelResourcePermission;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={LayoutContentModelResourcePermission.class})
public class LayoutContentModelResourcePermissionImpl
implements LayoutContentModelResourcePermission {
    private static final Log _log = LogFactoryUtil.getLog(LayoutContentModelResourcePermissionImpl.class);
    private static ServiceTrackerMap<String, ModelResourcePermission<?>> _modelResourcePermissionServiceTrackerMap;
    @Reference
    private LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;

    public boolean contains(PermissionChecker permissionChecker, long plid, String actionId) {
        List layoutClassedModelUsages = this._layoutClassedModelUsageLocalService.getLayoutClassedModelUsagesByPlid(plid);
        for (LayoutClassedModelUsage layoutClassedModelUsage : layoutClassedModelUsages) {
            if (!this.contains(permissionChecker, layoutClassedModelUsage.getClassName(), layoutClassedModelUsage.getClassPK(), actionId)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(PermissionChecker permissionChecker, String className, long classPK, String actionId) {
        ModelResourcePermission modelResourcePermission = (ModelResourcePermission)_modelResourcePermissionServiceTrackerMap.getService((Object)className);
        if (modelResourcePermission == null) {
            return false;
        }
        try {
            if (modelResourcePermission.contains(permissionChecker, classPK, actionId)) {
                return true;
            }
        }
        catch (PortalException portalException) {
            _log.error((Object)"An error occurred while checking permissions", (Throwable)portalException);
        }
        return false;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        _modelResourcePermissionServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ModelResourcePermission.class, (String)"model.class.name");
    }
}

