/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.util;

import com.liferay.asset.model.AssetEntryUsage;
import com.liferay.asset.service.AssetEntryUsageLocalService;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.model.FragmentEntryLinkModel;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.util.LayoutCopyHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.model.SegmentsExperienceModel;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import com.liferay.sites.kernel.util.Sites;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={LayoutCopyHelper.class})
public class LayoutCopyHelperImpl
implements LayoutCopyHelper {
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    @Reference
    private AssetEntryUsageLocalService _assetEntryUsageLocalService;
    @Reference
    private CounterLocalService _counterLocalService;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    @Reference
    private Sites _sites;

    public Layout copyLayout(Layout sourceLayout, Layout targetLayout) throws Exception {
        CopyLayoutCallable callable = new CopyLayoutCallable(sourceLayout, targetLayout);
        try {
            return (Layout)TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)callable);
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
    }

    private void _copyLayoutPageTemplateStructure(Layout sourceLayout, Layout targetLayout) throws Exception {
        long classNameId = this._portal.getClassNameId(Layout.class);
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(sourceLayout.getGroupId(), classNameId, sourceLayout.getPlid());
        if (layoutPageTemplateStructure == null) {
            LayoutPageTemplateStructure targetLayoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(targetLayout.getGroupId(), classNameId, targetLayout.getPlid());
            if (targetLayoutPageTemplateStructure != null) {
                this._layoutPageTemplateStructureLocalService.deleteLayoutPageTemplateStructure(targetLayoutPageTemplateStructure);
            }
            this._fragmentEntryLinkLocalService.deleteLayoutPageTemplateEntryFragmentEntryLinks(targetLayout.getGroupId(), classNameId, targetLayout.getPlid());
            layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.rebuildLayoutPageTemplateStructure(sourceLayout.getGroupId(), classNameId, sourceLayout.getPlid());
        }
        ServiceContext serviceContext = Optional.ofNullable(ServiceContextThreadLocal.getServiceContext()).orElse(new ServiceContext());
        List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinks(sourceLayout.getGroupId(), classNameId, sourceLayout.getPlid());
        Stream stream = fragmentEntryLinks.stream();
        Map<Long, FragmentEntryLink> fragmentEntryLinkMap = stream.collect(Collectors.toMap(FragmentEntryLinkModel::getFragmentEntryLinkId, fragmentEntryLink -> fragmentEntryLink));
        this._fragmentEntryLinkLocalService.deleteLayoutPageTemplateEntryFragmentEntryLinks(targetLayout.getGroupId(), classNameId, targetLayout.getPlid());
        LayoutPageTemplateStructure targetLayoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(targetLayout.getGroupId(), classNameId, targetLayout.getPlid());
        if (targetLayoutPageTemplateStructure == null) {
            this._layoutPageTemplateStructureLocalService.addLayoutPageTemplateStructure(targetLayout.getUserId(), targetLayout.getGroupId(), classNameId, targetLayout.getPlid(), null, serviceContext);
        }
        long[] lArray = this._getSegmentsExperienceIds(sourceLayout.getGroupId(), classNameId, sourceLayout.getPlid());
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long segmentsExperienceId = lArray[i];
            this._copyLayoutPageTemplateStructureExperience(layoutPageTemplateStructure, segmentsExperienceId, classNameId, targetLayout, fragmentEntryLinkMap, serviceContext);
        }
        this._assetEntryUsageLocalService.deleteAssetEntryUsagesByPlid(targetLayout.getPlid());
        List assetEntryUsages = this._assetEntryUsageLocalService.getAssetEntryUsagesByPlid(sourceLayout.getPlid());
        for (AssetEntryUsage assetEntryUsage : assetEntryUsages) {
            this._assetEntryUsageLocalService.addAssetEntryUsage(assetEntryUsage.getGroupId(), assetEntryUsage.getAssetEntryId(), assetEntryUsage.getContainerType(), assetEntryUsage.getContainerKey(), targetLayout.getPlid(), serviceContext);
        }
    }

    private void _copyLayoutPageTemplateStructureExperience(LayoutPageTemplateStructure layoutPageTemplateStructure, long segmentsExperienceId, long classNameId, Layout targetLayout, Map<Long, FragmentEntryLink> fragmentEntryLinkMap, ServiceContext serviceContext) throws Exception {
        String data = layoutPageTemplateStructure.getData(segmentsExperienceId);
        if (Validator.isNull((String)data)) {
            return;
        }
        JSONObject dataJSONObject = JSONFactoryUtil.createJSONObject((String)data);
        JSONArray structureJSONArray = dataJSONObject.getJSONArray("structure");
        if (structureJSONArray == null) {
            return;
        }
        for (int i = 0; i < structureJSONArray.length(); ++i) {
            JSONObject rowJSONObject = structureJSONArray.getJSONObject(i);
            JSONArray columnsJSONArray = rowJSONObject.getJSONArray("columns");
            for (int j = 0; j < columnsJSONArray.length(); ++j) {
                JSONObject columnJSONObject = columnsJSONArray.getJSONObject(j);
                JSONArray fragmentEntryLinkIdsJSONArray = columnJSONObject.getJSONArray("fragmentEntryLinkIds");
                JSONArray newFragmentEntryLinkIdsJSONArray = JSONFactoryUtil.createJSONArray();
                for (int k = 0; k < fragmentEntryLinkIdsJSONArray.length(); ++k) {
                    FragmentEntryLink fragmentEntryLink = fragmentEntryLinkMap.get(fragmentEntryLinkIdsJSONArray.getLong(k));
                    if (fragmentEntryLink == null) continue;
                    FragmentEntryLink newFragmentEntryLink = (FragmentEntryLink)fragmentEntryLink.clone();
                    newFragmentEntryLink.setUuid(serviceContext.getUuid());
                    newFragmentEntryLink.setFragmentEntryLinkId(this._counterLocalService.increment());
                    newFragmentEntryLink.setUserId(targetLayout.getUserId());
                    newFragmentEntryLink.setUserName(targetLayout.getUserName());
                    newFragmentEntryLink.setCreateDate(serviceContext.getCreateDate(new Date()));
                    newFragmentEntryLink.setModifiedDate(serviceContext.getModifiedDate(new Date()));
                    newFragmentEntryLink.setOriginalFragmentEntryLinkId(0L);
                    newFragmentEntryLink.setClassNameId(classNameId);
                    newFragmentEntryLink.setClassPK(targetLayout.getPlid());
                    newFragmentEntryLink.setLastPropagationDate(serviceContext.getCreateDate(new Date()));
                    newFragmentEntryLink = this._fragmentEntryLinkLocalService.addFragmentEntryLink(newFragmentEntryLink);
                    newFragmentEntryLinkIdsJSONArray.put(newFragmentEntryLink.getFragmentEntryLinkId());
                }
                columnJSONObject.put("fragmentEntryLinkIds", newFragmentEntryLinkIdsJSONArray);
            }
        }
        this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructure(targetLayout.getGroupId(), classNameId, targetLayout.getPlid(), segmentsExperienceId, dataJSONObject.toString());
    }

    private void _copyPortletPreferences(Layout sourceLayout, Layout targetLayout) {
        List portletPreferencesList = this._portletPreferencesLocalService.getPortletPreferences(0L, 3, sourceLayout.getPlid());
        this._portletPreferencesLocalService.deletePortletPreferences(0L, 3, targetLayout.getPlid());
        for (PortletPreferences portletPreferences : portletPreferencesList) {
            Portlet portlet = this._portletLocalService.getPortletById(portletPreferences.getPortletId());
            if (portlet == null || portlet.isUndeployedPortlet()) continue;
            PortletPreferences targetPortletPreferences = this._portletPreferencesLocalService.fetchPortletPreferences(0L, 3, targetLayout.getPlid(), portletPreferences.getPortletId());
            if (targetPortletPreferences != null) {
                targetPortletPreferences.setPreferences(portletPreferences.getPreferences());
                this._portletPreferencesLocalService.updatePortletPreferences(targetPortletPreferences);
                continue;
            }
            this._portletPreferencesLocalService.addPortletPreferences(targetLayout.getCompanyId(), 0L, 3, targetLayout.getPlid(), portletPreferences.getPortletId(), this._portletLocalService.getPortletById(portletPreferences.getPortletId()), portletPreferences.getPreferences());
        }
    }

    private long[] _getSegmentsExperienceIds(long groupId, long classNameId, long classPK) throws PortalException {
        List segmentsExperiences = this._segmentsExperienceLocalService.getSegmentsExperiences(groupId, classNameId, classPK, true);
        Stream stream = segmentsExperiences.stream();
        return ArrayUtil.append((long[][])new long[][]{stream.mapToLong(SegmentsExperienceModel::getSegmentsExperienceId).toArray(), {0L}});
    }

    private class CopyLayoutCallable
    implements Callable<Layout> {
        private final Layout _sourceLayout;
        private final Layout _targetLayout;

        @Override
        public Layout call() throws Exception {
            ServiceContext serviceContext;
            LayoutCopyHelperImpl.this._sites.copyLookAndFeel(this._targetLayout, this._sourceLayout);
            LayoutCopyHelperImpl.this._sites.copyPortletSetups(this._sourceLayout, this._targetLayout);
            LayoutCopyHelperImpl.this._sites.copyPortletPermissions(this._targetLayout, this._sourceLayout);
            LayoutCopyHelperImpl.this._copyLayoutPageTemplateStructure(this._sourceLayout, this._targetLayout);
            LayoutCopyHelperImpl.this._copyPortletPreferences(this._sourceLayout, this._targetLayout);
            Image image = LayoutCopyHelperImpl.this._imageLocalService.getImage(this._sourceLayout.getIconImageId());
            byte[] imageBytes = null;
            if (image != null) {
                imageBytes = image.getTextObj();
            }
            if ((serviceContext = ServiceContextThreadLocal.getServiceContext()) == null) {
                serviceContext = new ServiceContext();
            }
            serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
            LayoutCopyHelperImpl.this._layoutLocalService.updateLayout(this._targetLayout.getGroupId(), this._targetLayout.isPrivateLayout(), this._targetLayout.getLayoutId(), this._sourceLayout.getTypeSettings());
            return LayoutCopyHelperImpl.this._layoutLocalService.updateIconImage(this._targetLayout.getPlid(), imageBytes);
        }

        private CopyLayoutCallable(Layout sourceLayout, Layout targetLayout) {
            this._sourceLayout = sourceLayout;
            this._targetLayout = targetLayout;
        }
    }
}

