/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.security.permission.PermissionUpdateHandler;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.kernel.model.Layout"}, service={PermissionUpdateHandler.class})
public class LayoutPermissionUpdateHandler
implements PermissionUpdateHandler {
    private static final Log _log = LogFactoryUtil.getLog(LayoutPermissionUpdateHandler.class);
    private LayoutLocalService _layoutLocalService;

    public void updatedPermission(String primKey) {
        Layout layout = this._layoutLocalService.fetchLayout(GetterUtil.getLong((String)primKey));
        if (layout == null) {
            return;
        }
        layout.setModifiedDate(new Date());
        try {
            this._layoutLocalService.updateLayout(layout);
        }
        catch (PortalException pe) {
            _log.error((Object)pe.getMessage(), (Throwable)pe);
        }
    }

    @Reference(unbind="-")
    protected void setLayoutSetLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }
}

