/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.search.spi.model.index.contributor;

import com.liferay.fragment.renderer.FragmentRendererController;
import com.liferay.layout.internal.search.util.LayoutPageTemplateStructureRenderUtil;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.kernel.model.Layout"}, service={ModelDocumentContributor.class})
public class LayoutModelDocumentContributor
implements ModelDocumentContributor<Layout> {
    public static final String CLASS_NAME = Layout.class.getName();
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private FragmentRendererController _fragmentRendererController;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;

    public void contribute(Document document, Layout layout) {
        if (layout.isSystem()) {
            return;
        }
        document.addUID(CLASS_NAME, layout.getPlid());
        document.addText("defaultLanguageId", layout.getDefaultLanguageId());
        document.addLocalizedText("name", layout.getNameMap());
        document.addText("privateLayout", String.valueOf(layout.isPrivateLayout()));
        document.addText("type", layout.getType());
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), this._portal.getClassNameId(Layout.class), layout.getPlid());
        for (String languageId : layout.getAvailableLanguageIds()) {
            Locale locale = LocaleUtil.fromLanguageId((String)languageId);
            document.addText(Field.getLocalizedName((Locale)locale, (String)"title"), layout.getName(locale));
        }
        if (layoutPageTemplateStructure == null) {
            return;
        }
        HttpServletRequest httpServletRequest = null;
        HttpServletResponse httpServletResponse = null;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext != null) {
            httpServletRequest = DynamicServletRequest.addQueryString((HttpServletRequest)serviceContext.getRequest(), (String)("p_l_id=" + layout.getPlid()), (boolean)false);
            httpServletResponse = serviceContext.getResponse();
        }
        long[] segmentsExperienceIds = new long[]{0L};
        Set locales = LanguageUtil.getAvailableLocales((long)layout.getGroupId());
        for (Locale locale : locales) {
            try {
                if (httpServletRequest == null || httpServletResponse == null) break;
                String content = LayoutPageTemplateStructureRenderUtil.renderLayoutContent(this._fragmentRendererController, httpServletRequest, httpServletResponse, layoutPageTemplateStructure, "VIEW", new HashMap<String, Object>(), locale, segmentsExperienceIds);
                document.addText(Field.getLocalizedName((Locale)locale, (String)"content"), content);
            }
            catch (PortalException pe) {
                throw new SystemException((Throwable)pe);
            }
        }
    }
}

