/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.exportimport.staged.model.repository;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.layout.set.model.adapter.StagedLayoutSet;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.adapter.ModelAdapterUtil;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.layout.set.model.adapter.StagedLayoutSet"}, service={StagedLayoutSetStagedModelRepository.class, StagedModelRepository.class})
public class StagedLayoutSetStagedModelRepository
implements StagedModelRepository<StagedLayoutSet> {
    private static final Log _log = LogFactoryUtil.getLog(StagedLayoutSetStagedModelRepository.class);
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;

    public StagedLayoutSet addStagedModel(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) throws PortalException {
        return null;
    }

    public void deleteStagedModel(StagedLayoutSet stagedLayoutSet) throws PortalException {
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
    }

    public List<StagedModel> fetchChildrenStagedModels(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) {
        List layouts = this._layoutLocalService.getLayouts(stagedLayoutSet.getGroupId(), stagedLayoutSet.isPrivateLayout());
        Stream layoutsStream = layouts.stream();
        return layoutsStream.map(layout -> layout).collect(Collectors.toList());
    }

    public Optional<StagedLayoutSet> fetchExistingLayoutSet(long groupId, boolean privateLayout) {
        StagedLayoutSet stagedLayoutSet;
        block2: {
            stagedLayoutSet = null;
            try {
                LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(groupId, privateLayout);
                stagedLayoutSet = (StagedLayoutSet)ModelAdapterUtil.adapt((Object)layoutSet, LayoutSet.class, StagedLayoutSet.class);
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
        return Optional.ofNullable(stagedLayoutSet);
    }

    public StagedLayoutSet fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        boolean privateLayout = GetterUtil.getBoolean((String)uuid);
        try {
            LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(groupId, privateLayout);
            return (StagedLayoutSet)ModelAdapterUtil.adapt((Object)layoutSet, LayoutSet.class, StagedLayoutSet.class);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return null;
        }
    }

    public List<StagedLayoutSet> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        boolean privateLayout = GetterUtil.getBoolean((String)uuid);
        DynamicQuery dynamicQuery = this._layoutSetLocalService.dynamicQuery();
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)companyId));
        Property privateLayoutProperty = PropertyFactoryUtil.forName((String)"privateLayout");
        dynamicQuery.add(privateLayoutProperty.eq((Object)privateLayout));
        List layoutSets = dynamicQuery.list();
        Stream layoutSetsStream = layoutSets.stream();
        Stream<StagedLayoutSet> stagedLayoutSetsStream = layoutSetsStream.map(layoutSet -> (StagedLayoutSet)ModelAdapterUtil.adapt((Object)layoutSet, LayoutSet.class, StagedLayoutSet.class));
        return stagedLayoutSetsStream.collect(Collectors.toList());
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext) {
        return null;
    }

    public StagedLayoutSet getStagedModel(long layoutSetId) throws PortalException {
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(layoutSetId);
        return (StagedLayoutSet)ModelAdapterUtil.adapt((Object)layoutSet, LayoutSet.class, StagedLayoutSet.class);
    }

    public StagedLayoutSet saveStagedModel(StagedLayoutSet stagedLayoutSet) throws PortalException {
        LayoutSet layoutSet = this._layoutSetLocalService.updateLayoutSet((LayoutSet)stagedLayoutSet);
        return (StagedLayoutSet)ModelAdapterUtil.adapt((Object)layoutSet, LayoutSet.class, StagedLayoutSet.class);
    }

    public StagedLayoutSet updateStagedModel(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) throws PortalException {
        boolean layoutSetSettings;
        LayoutSet existingLayoutSet = this._layoutSetLocalService.fetchLayoutSet(stagedLayoutSet.getLayoutSetId());
        boolean layoutSetPrototypeSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LAYOUT_SET_PROTOTYPE_SETTINGS");
        if (layoutSetPrototypeSettings && Validator.isNotNull((String)stagedLayoutSet.getLayoutSetPrototypeUuid())) {
            existingLayoutSet.setLayoutSetPrototypeUuid(stagedLayoutSet.getLayoutSetPrototypeUuid());
            boolean layoutSetPrototypeLinkEnabled = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LAYOUT_SET_PROTOTYPE_LINK_ENABLED");
            existingLayoutSet.setLayoutSetPrototypeLinkEnabled(layoutSetPrototypeLinkEnabled);
            existingLayoutSet = this._layoutSetLocalService.updateLayoutSet(existingLayoutSet);
        }
        if (layoutSetSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LAYOUT_SET_SETTINGS")) {
            existingLayoutSet = this._layoutSetLocalService.updateSettings(existingLayoutSet.getGroupId(), existingLayoutSet.isPrivateLayout(), stagedLayoutSet.getSettings());
        }
        return (StagedLayoutSet)ModelAdapterUtil.adapt((Object)existingLayoutSet, LayoutSet.class, StagedLayoutSet.class);
    }
}

