/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.workflow.definition.link.update.handler;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.LayoutRevisionLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.definition.link.update.handler.WorkflowDefinitionLinkUpdateHandler;
import java.util.List;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.portal.kernel.model.LayoutRevision"}, service={WorkflowDefinitionLinkUpdateHandler.class})
public class LayoutRevisionWorkflowDefinitionLinkUpdateHandler
implements WorkflowDefinitionLinkUpdateHandler {
    private static final Log _log = LogFactoryUtil.getLog(LayoutRevisionWorkflowDefinitionLinkUpdateHandler.class);
    @Reference
    private LayoutRevisionLocalService _layoutRevisionLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    public void updatedWorkflowDefinitionLink(String workflowDefinition) {
        if (Validator.isNotNull((String)workflowDefinition)) {
            return;
        }
        List pendingLayoutRevisions = this._layoutRevisionLocalService.getLayoutRevisionsByStatus(1);
        Stream stream = pendingLayoutRevisions.stream();
        stream.forEach(layoutRevision -> {
            block2: {
                layoutRevision.setStatus(2);
                this._layoutRevisionLocalService.updateLayoutRevision(layoutRevision);
                try {
                    this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(layoutRevision.getCompanyId(), layoutRevision.getGroupId(), layoutRevision.getModelClassName(), layoutRevision.getLayoutRevisionId());
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to delete workflow instance links for layout revision " + layoutRevision.getLayoutRevisionId()), (Throwable)pe);
                }
            }
        });
    }
}

