/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.util;

import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutBranch;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutRevisionLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalService;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SessionClicks;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.layoutsadmin.util.LayoutsTree;
import com.liferay.sites.kernel.util.SitesUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={LayoutsTree.class})
public class LayoutsTreeImpl
implements LayoutsTree {
    private static final Log _log = LogFactoryUtil.getLog(LayoutsTreeImpl.class);
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutRevisionLocalService _layoutRevisionLocalService;
    @Reference
    private LayoutService _layoutService;
    @Reference
    private LayoutSetBranchLocalService _layoutSetBranchLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private Staging _staging;

    public String getLayoutsJSON(HttpServletRequest request, long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, String treeId) throws Exception {
        return this.getLayoutsJSON(request, groupId, privateLayout, parentLayoutId, incomplete, treeId, null);
    }

    public String getLayoutsJSON(HttpServletRequest request, long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, String treeId, LayoutSetBranch layoutSetBranch) throws Exception {
        return this.getLayoutsJSON(request, groupId, privateLayout, parentLayoutId, null, incomplete, treeId, layoutSetBranch);
    }

    public String getLayoutsJSON(HttpServletRequest request, long groupId, boolean privateLayout, long layoutId, int max) throws Exception {
        return this.getLayoutsJSON(request, groupId, privateLayout, layoutId, max, null);
    }

    public String getLayoutsJSON(HttpServletRequest request, long groupId, boolean privateLayout, long layoutId, int max, LayoutSetBranch layoutSetBranch) throws Exception {
        Layout layout = this._layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        long parentLayoutId = layout.getParentLayoutId();
        long includedLayoutIndex = this._layoutService.getLayoutsCount(groupId, privateLayout, parentLayoutId, layout.getPriority());
        int total = this._layoutService.getLayoutsCount(groupId, privateLayout, parentLayoutId);
        int start = (int)includedLayoutIndex - 1;
        int end = (int)includedLayoutIndex + max;
        if (end > total) {
            start = total - max;
            end = total;
            if (start < 0) {
                start = 0;
            }
        }
        List layouts = this._layoutService.getLayouts(groupId, privateLayout, parentLayoutId, true, start, end);
        JSONObject jsonObject = this._toJSONObject(request, groupId, layouts, total, layoutSetBranch);
        List ancestorLayouts = this._layoutService.getAncestorLayouts(layout.getPlid());
        long[] ancestorLayoutIds = new long[ancestorLayouts.size()];
        String[] ancestorLayoutNames = new String[ancestorLayouts.size()];
        Locale locale = this._portal.getLocale(request);
        for (int i = 0; i < ancestorLayouts.size(); ++i) {
            Layout ancestorLayout = (Layout)ancestorLayouts.get(i);
            ancestorLayoutIds[i] = ancestorLayout.getLayoutId();
            ancestorLayoutNames[i] = ancestorLayout.getName(locale);
        }
        jsonObject.put("ancestorLayoutIds", (Object)ancestorLayoutIds);
        jsonObject.put("ancestorLayoutNames", (Object)ancestorLayoutNames);
        jsonObject.put("start", start);
        return jsonObject.toString();
    }

    public String getLayoutsJSON(HttpServletRequest request, long groupId, boolean privateLayout, long parentLayoutId, long[] expandedLayoutIds, boolean incomplete, String treeId) throws Exception {
        return this.getLayoutsJSON(request, groupId, privateLayout, parentLayoutId, expandedLayoutIds, incomplete, treeId, null);
    }

    public String getLayoutsJSON(HttpServletRequest request, long groupId, boolean privateLayout, long parentLayoutId, long[] expandedLayoutIds, boolean incomplete, String treeId, LayoutSetBranch layoutSetBranch) throws Exception {
        if (_log.isDebugEnabled()) {
            StringBundler sb = new StringBundler(13);
            sb.append("getLayoutsJSON(groupId=");
            sb.append(groupId);
            sb.append(", privateLayout=");
            sb.append(privateLayout);
            sb.append(", parentLayoutId=");
            sb.append(parentLayoutId);
            sb.append(", expandedLayoutIds=");
            sb.append((Object)expandedLayoutIds);
            sb.append(", incomplete=");
            sb.append(incomplete);
            sb.append(", treeId=");
            sb.append(treeId);
            sb.append(")");
            _log.debug((Object)sb.toString());
        }
        LayoutTreeNodes layoutTreeNodes = this._getLayoutTreeNodes(request, groupId, privateLayout, parentLayoutId, incomplete, expandedLayoutIds, treeId);
        return this._toJSON(request, groupId, layoutTreeNodes, layoutSetBranch);
    }

    public String getLayoutsJSON(HttpServletRequest request, long groupId, String treeId) throws Exception {
        return this.getLayoutsJSON(request, groupId, treeId, null);
    }

    public String getLayoutsJSON(HttpServletRequest request, long groupId, String treeId, LayoutSetBranch layoutSetBranch) throws Exception {
        if (_log.isDebugEnabled()) {
            StringBundler sb = new StringBundler(5);
            sb.append("getLayoutsJSON(groupId=");
            sb.append(groupId);
            sb.append(", treeId=");
            sb.append(treeId);
            sb.append(")");
            _log.debug((Object)sb.toString());
        }
        LayoutTreeNodes layoutTreeNodes = new LayoutTreeNodes();
        layoutTreeNodes.addAll(this._getLayoutTreeNodes(request, groupId, true, 0L, false, null, treeId));
        layoutTreeNodes.addAll(this._getLayoutTreeNodes(request, groupId, false, 0L, false, null, treeId));
        return this._toJSON(request, groupId, layoutTreeNodes, layoutSetBranch);
    }

    private Layout _fetchCurrentLayout(HttpServletRequest request) {
        long selPlid = ParamUtil.getLong((HttpServletRequest)request, (String)"selPlid");
        if (selPlid > 0L) {
            return this._layoutLocalService.fetchLayout(selPlid);
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        if (!layout.isTypeControlPanel()) {
            return layout;
        }
        return null;
    }

    private List<Layout> _getAncestorLayouts(HttpServletRequest request) throws Exception {
        Layout layout = this._fetchCurrentLayout(request);
        if (layout == null) {
            return Collections.emptyList();
        }
        List ancestorLayouts = this._layoutService.getAncestorLayouts(layout.getPlid());
        if (_log.isDebugEnabled()) {
            StringBundler sb = new StringBundler(7);
            sb.append("_getAncestorLayouts(plid=");
            sb.append(layout.getPlid());
            sb.append(", ancestorLayouts=");
            sb.append((Object)ancestorLayouts);
            sb.append(", layout=");
            sb.append((Object)layout);
            sb.append(")");
            _log.debug((Object)sb.toString());
        }
        ancestorLayouts.add(layout);
        return ancestorLayouts;
    }

    private LayoutTreeNodes _getLayoutTreeNodes(HttpServletRequest request, long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, long[] expandedLayoutIds, String treeId) throws Exception {
        if (_log.isDebugEnabled()) {
            StringBundler sb = new StringBundler(13);
            sb.append("_getLayoutTreeNodes(groupId=");
            sb.append(groupId);
            sb.append(", privateLayout=");
            sb.append(privateLayout);
            sb.append(", parentLayoutId=");
            sb.append(parentLayoutId);
            sb.append(", expandedLayoutIds=");
            sb.append((Object)expandedLayoutIds);
            sb.append(", incomplete=");
            sb.append(incomplete);
            sb.append(", treeId=");
            sb.append(treeId);
            sb.append(")");
            _log.debug((Object)sb.toString());
        }
        ArrayList<LayoutTreeNode> layoutTreeNodes = new ArrayList<LayoutTreeNode>();
        List<Layout> ancestorLayouts = this._getAncestorLayouts(request);
        List layouts = this._layoutService.getLayouts(groupId, privateLayout, parentLayoutId, incomplete, -1, -1);
        for (Layout layout : this._paginateLayouts(request, groupId, privateLayout, parentLayoutId, layouts, treeId)) {
            LayoutTreeNode layoutTreeNode = new LayoutTreeNode(layout);
            LayoutTreeNodes childLayoutTreeNodes = null;
            if (this._isExpandableLayout(request, ancestorLayouts, expandedLayoutIds, layout)) {
                if (layout instanceof VirtualLayout) {
                    VirtualLayout virtualLayout = (VirtualLayout)layout;
                    childLayoutTreeNodes = this._getLayoutTreeNodes(request, virtualLayout.getSourceGroupId(), virtualLayout.isPrivateLayout(), virtualLayout.getLayoutId(), incomplete, expandedLayoutIds, treeId);
                } else {
                    childLayoutTreeNodes = this._getLayoutTreeNodes(request, groupId, layout.isPrivateLayout(), layout.getLayoutId(), incomplete, expandedLayoutIds, treeId);
                }
            } else {
                int childLayoutsCount = this._layoutService.getLayoutsCount(groupId, privateLayout, layout.getLayoutId());
                childLayoutTreeNodes = new LayoutTreeNodes(new ArrayList<LayoutTreeNode>(), childLayoutsCount);
            }
            layoutTreeNode.setChildLayoutTreeNodes(childLayoutTreeNodes);
            layoutTreeNodes.add(layoutTreeNode);
        }
        return new LayoutTreeNodes(layoutTreeNodes, layouts.size());
    }

    private int _getLoadedLayoutsCount(HttpSession session, long groupId, boolean privateLayout, long layoutId, String treeId) throws Exception {
        StringBundler sb = new StringBundler(7);
        sb.append(treeId);
        sb.append(":");
        sb.append(groupId);
        sb.append(":");
        sb.append(privateLayout);
        sb.append(":");
        sb.append("Pagination");
        String key = sb.toString();
        String paginationJSON = SessionClicks.get((HttpSession)session, (String)key, (String)JSONFactoryUtil.getNullJSON());
        JSONObject paginationJSONObject = JSONFactoryUtil.createJSONObject((String)paginationJSON);
        if (_log.isDebugEnabled()) {
            sb = new StringBundler(9);
            sb.append("_getLoadedLayoutsCount(key=");
            sb.append(key);
            sb.append(", layoutId=");
            sb.append(layoutId);
            sb.append(", paginationJSON=");
            sb.append(paginationJSON);
            sb.append(", paginationJSONObject");
            sb.append((Object)paginationJSONObject);
            sb.append(")");
            _log.debug((Object)sb.toString());
        }
        return paginationJSONObject.getInt(String.valueOf(layoutId), 0);
    }

    private boolean _isDeleteable(Layout layout, ThemeDisplay themeDisplay, LayoutSetBranch layoutSetBranch) throws PortalException {
        LayoutRevision layoutRevision;
        List layoutRevisions;
        if (!LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"DELETE")) {
            return false;
        }
        Group group = layout.getGroup();
        if (group.isGuest() && !layout.isPrivateLayout() && layout.isRootLayout() && this._layoutLocalService.getLayoutsCount(group, false, 0L) == 1) {
            return false;
        }
        return layoutSetBranch == null || (layoutRevisions = this._layoutRevisionLocalService.getLayoutRevisions(layoutSetBranch.getLayoutSetBranchId(), layout.getPlid())).size() != 1 || !(layoutRevision = (LayoutRevision)layoutRevisions.get(0)).isIncomplete();
    }

    private boolean _isExpandableLayout(HttpServletRequest request, List<Layout> ancestorLayouts, long[] expandedLayoutIds, Layout layout) {
        boolean expandParentLayouts = ParamUtil.getBoolean((HttpServletRequest)request, (String)"expandParentLayouts");
        return expandParentLayouts || ancestorLayouts.contains(layout) || ArrayUtil.contains((long[])expandedLayoutIds, (long)layout.getLayoutId());
    }

    private boolean _isPaginationEnabled(HttpServletRequest request) {
        boolean paginate = ParamUtil.getBoolean((HttpServletRequest)request, (String)"paginate", (boolean)true);
        return paginate && PropsValues.LAYOUT_MANAGE_PAGES_INITIAL_CHILDREN > -1;
    }

    private List<Layout> _paginateLayouts(HttpServletRequest request, long groupId, boolean privateLayout, long parentLayoutId, List<Layout> layouts, String treeId) throws Exception {
        if (!this._isPaginationEnabled(request)) {
            return layouts;
        }
        HttpSession session = request.getSession();
        int loadedLayoutsCount = this._getLoadedLayoutsCount(session, groupId, privateLayout, parentLayoutId, treeId);
        int start = ParamUtil.getInteger((HttpServletRequest)request, (String)"start");
        int end = ParamUtil.getInteger((HttpServletRequest)request, (String)"end", (int)((start = Math.max(0, Math.min(start, layouts.size()))) + PropsValues.LAYOUT_MANAGE_PAGES_INITIAL_CHILDREN));
        if (loadedLayoutsCount > end) {
            end = loadedLayoutsCount;
        }
        end = Math.max(start, Math.min(end, layouts.size()));
        if (_log.isDebugEnabled()) {
            StringBundler sb = new StringBundler(7);
            sb.append("_paginateLayouts(loadedLayoutsCount=");
            sb.append(loadedLayoutsCount);
            sb.append(", start=");
            sb.append(start);
            sb.append(", end=");
            sb.append(end);
            sb.append(")");
            _log.debug((Object)sb.toString());
        }
        return layouts.subList(start, end);
    }

    private String _toJSON(HttpServletRequest request, long groupId, LayoutTreeNodes layoutTreeNodes, LayoutSetBranch layoutSetBranch) throws Exception {
        JSONObject jsonObject = this._toJSONObject(request, groupId, layoutTreeNodes, layoutSetBranch);
        return jsonObject.toString();
    }

    private JSONObject _toJSONObject(HttpServletRequest request, long groupId, LayoutTreeNodes layoutTreeNodes, LayoutSetBranch layoutSetBranch) throws Exception {
        if (_log.isDebugEnabled()) {
            StringBundler sb = new StringBundler(5);
            sb.append("_toJSON(groupId=");
            sb.append(groupId);
            sb.append(", layoutTreeNodes=");
            sb.append((Object)layoutTreeNodes);
            sb.append(")");
            _log.debug((Object)sb.toString());
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        boolean hasManageLayoutsPermission = GroupPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (long)groupId, (String)"MANAGE_LAYOUTS");
        boolean mobile = BrowserSnifferUtil.isMobile((HttpServletRequest)request);
        for (LayoutTreeNode layoutTreeNode : layoutTreeNodes) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            JSONObject childrenJSONObject = this._toJSONObject(request, groupId, layoutTreeNode.getChildLayoutTreeNodes(), layoutSetBranch);
            jsonObject.put("children", childrenJSONObject);
            Layout layout = layoutTreeNode.getLayout();
            jsonObject.put("contentDisplayPage", layout.isContentDisplayPage());
            jsonObject.put("deleteable", this._isDeleteable(layout, themeDisplay, layoutSetBranch));
            jsonObject.put("friendlyURL", layout.getFriendlyURL());
            if (layout instanceof VirtualLayout) {
                VirtualLayout virtualLayout = (VirtualLayout)layout;
                jsonObject.put("groupId", virtualLayout.getSourceGroupId());
            } else {
                jsonObject.put("groupId", layout.getGroupId());
            }
            jsonObject.put("hasChildren", layout.hasChildren());
            jsonObject.put("layoutId", layout.getLayoutId());
            jsonObject.put("name", layout.getName(themeDisplay.getLocale()));
            jsonObject.put("parentable", LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"ADD_LAYOUT"));
            jsonObject.put("parentLayoutId", layout.getParentLayoutId());
            jsonObject.put("plid", layout.getPlid());
            jsonObject.put("priority", layout.getPriority());
            jsonObject.put("privateLayout", layout.isPrivateLayout());
            jsonObject.put("regularURL", layout.getRegularURL(request));
            jsonObject.put("sortable", hasManageLayoutsPermission && !mobile && SitesUtil.isLayoutSortable((Layout)layout));
            jsonObject.put("type", layout.getType());
            jsonObject.put("updateable", LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"UPDATE"));
            jsonObject.put("uuid", layout.getUuid());
            LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout);
            if (layoutRevision != null) {
                long layoutSetBranchId = layoutRevision.getLayoutSetBranchId();
                if (this._staging.isIncomplete(layout, layoutSetBranchId)) {
                    jsonObject.put("incomplete", true);
                }
                LayoutSetBranch boundLayoutSetBranch = this._layoutSetBranchLocalService.getLayoutSetBranch(layoutSetBranchId);
                LayoutBranch layoutBranch = layoutRevision.getLayoutBranch();
                if (!layoutBranch.isMaster()) {
                    jsonObject.put("layoutBranchId", layoutBranch.getLayoutBranchId());
                    jsonObject.put("layoutBranchName", layoutBranch.getName());
                }
                if (layoutRevision.isHead()) {
                    jsonObject.put("layoutRevisionHead", true);
                }
                jsonObject.put("layoutRevisionId", layoutRevision.getLayoutRevisionId());
                jsonObject.put("layoutSetBranchId", layoutSetBranchId);
                jsonObject.put("layoutSetBranchName", boundLayoutSetBranch.getName());
            }
            jsonArray.put(jsonObject);
        }
        JSONObject responseJSONObject = JSONFactoryUtil.createJSONObject();
        responseJSONObject.put("layouts", jsonArray);
        responseJSONObject.put("total", layoutTreeNodes.getTotal());
        return responseJSONObject;
    }

    private JSONObject _toJSONObject(HttpServletRequest request, long groupId, List<Layout> layouts, int total, LayoutSetBranch layoutSetBranch) throws Exception {
        ArrayList<LayoutTreeNode> layoutTreeNodesList = new ArrayList<LayoutTreeNode>();
        for (Layout layout : layouts) {
            LayoutTreeNode layoutTreeNode = new LayoutTreeNode(layout);
            layoutTreeNodesList.add(layoutTreeNode);
        }
        LayoutTreeNodes layoutTreeNodes = new LayoutTreeNodes(layoutTreeNodesList, total);
        return this._toJSONObject(request, groupId, layoutTreeNodes, layoutSetBranch);
    }

    private static class LayoutTreeNodes
    implements Iterable<LayoutTreeNode> {
        private final List<LayoutTreeNode> _layoutTreeNodesList;
        private int _total;

        public LayoutTreeNodes() {
            this._layoutTreeNodesList = new ArrayList<LayoutTreeNode>();
        }

        public LayoutTreeNodes(List<LayoutTreeNode> layoutTreeNodesList, int total) {
            this._layoutTreeNodesList = layoutTreeNodesList;
            this._total = total;
        }

        public void addAll(LayoutTreeNodes layoutTreeNodes) {
            this._layoutTreeNodesList.addAll(layoutTreeNodes.getLayoutTreeNodesList());
            this._total += layoutTreeNodes.getTotal();
        }

        public List<LayoutTreeNode> getLayoutTreeNodesList() {
            return this._layoutTreeNodesList;
        }

        public int getTotal() {
            return this._total;
        }

        @Override
        public Iterator<LayoutTreeNode> iterator() {
            return this._layoutTreeNodesList.iterator();
        }

        public String toString() {
            StringBundler sb = new StringBundler(5);
            sb.append("{layoutTreeNodesList=");
            sb.append(this._layoutTreeNodesList);
            sb.append(", total=");
            sb.append(this._total);
            sb.append("}");
            return sb.toString();
        }
    }

    private static class LayoutTreeNode {
        private LayoutTreeNodes _childLayoutTreeNodes = new LayoutTreeNodes();
        private final Layout _layout;

        public LayoutTreeNode(Layout layout) {
            this._layout = layout;
        }

        public LayoutTreeNodes getChildLayoutTreeNodes() {
            return this._childLayoutTreeNodes;
        }

        public Layout getLayout() {
            return this._layout;
        }

        public void setChildLayoutTreeNodes(LayoutTreeNodes childLayoutTreeNodes) {
            this._childLayoutTreeNodes = childLayoutTreeNodes;
        }

        public String toString() {
            StringBundler sb = new StringBundler(5);
            sb.append("{childLayoutTreeNodes=");
            sb.append((Object)this._childLayoutTreeNodes);
            sb.append(", layout=");
            sb.append((Object)this._layout);
            sb.append("}");
            return sb.toString();
        }
    }
}

