/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportProcessCallbackRegistry;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.exportimport.lar.ThemeExporter;
import com.liferay.exportimport.lar.ThemeImporter;
import com.liferay.layout.internal.exportimport.staged.model.repository.StagedLayoutSetStagedModelRepository;
import com.liferay.layout.set.model.adapter.StagedLayoutSet;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.adapter.ModelAdapterUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ColorSchemeFactoryUtil;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ThemeFactoryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.sites.kernel.util.SitesUtil;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class StagedLayoutSetStagedModelDataHandler
extends BaseStagedModelDataHandler<StagedLayoutSet> {
    public static final String[] CLASS_NAMES = new String[]{StagedLayoutSet.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(StagedLayoutSetStagedModelDataHandler.class);
    @Reference
    private ExportImportProcessCallbackRegistry _exportImportProcessCallbackRegistry;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutSetBranchLocalService _layoutSetBranchLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private LayoutSetPrototypeLocalService _layoutSetPrototypeLocalService;
    @Reference
    private StagedLayoutSetStagedModelRepository _stagedLayoutSetStagedModelRepository;
    @Reference
    private ThemeExporter _themeExporter;
    @Reference
    private ThemeImporter _themeImporter;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void checkLayoutSetPrototypeLayouts(PortletDataContext portletDataContext, Set<Layout> modifiedLayouts) throws PortalException {
        boolean layoutSetPrototypeLinkEnabled = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LAYOUT_SET_PROTOTYPE_LINK_ENABLED");
        if (!layoutSetPrototypeLinkEnabled || Validator.isNull((String)portletDataContext.getLayoutSetPrototypeUuid())) {
            return;
        }
        LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.getLayoutSetPrototypeByUuidAndCompanyId(portletDataContext.getLayoutSetPrototypeUuid(), portletDataContext.getCompanyId());
        List layoutSetLayouts = this._layoutLocalService.getLayouts(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
        for (Layout layout : layoutSetLayouts) {
            String sourcePrototypeLayoutUuid = layout.getSourcePrototypeLayoutUuid();
            if (Validator.isNull((String)sourcePrototypeLayoutUuid)) continue;
            if (SitesUtil.isLayoutModifiedSinceLastMerge((Layout)layout)) {
                modifiedLayouts.add(layout);
                continue;
            }
            Layout sourcePrototypeLayout = this._layoutLocalService.fetchLayout(layout.getSourcePrototypeLayoutUuid(), layoutSetPrototype.getGroupId(), true);
            if (sourcePrototypeLayout != null) continue;
            this._layoutLocalService.deleteLayout(layout, false, ServiceContextThreadLocal.getServiceContext());
        }
    }

    protected void deleteMissingLayouts(PortletDataContext portletDataContext, List<Element> layoutElements) {
        boolean deleteMissingLayouts = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"DELETE_MISSING_LAYOUTS", (boolean)Boolean.TRUE);
        if (!deleteMissingLayouts) {
            return;
        }
        List previousLayouts = this._layoutLocalService.getLayouts(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
        Stream layoutElementsStream = layoutElements.stream();
        List sourceLayoutUuids = layoutElementsStream.map(layoutElement -> layoutElement.attributeValue("uuid")).collect(Collectors.toList());
        if (_log.isDebugEnabled() && !sourceLayoutUuids.isEmpty()) {
            _log.debug((Object)"Delete missing layouts");
        }
        Map layoutPlids = portletDataContext.getNewPrimaryKeysMap(Layout.class);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        for (Layout layout : previousLayouts) {
            if (sourceLayoutUuids.contains(layout.getUuid()) || layoutPlids.containsValue(layout.getPlid())) continue;
            try {
                this._layoutLocalService.deleteLayout(layout, false, serviceContext);
            }
            catch (Exception exception) {}
        }
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) throws Exception {
        boolean layoutSetSettings;
        this.exportLayouts(portletDataContext, stagedLayoutSet);
        this.exportLogo(portletDataContext, stagedLayoutSet);
        this.exportTheme(portletDataContext, stagedLayoutSet);
        boolean layoutSetPrototypeSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LAYOUT_SET_PROTOTYPE_SETTINGS");
        if (!layoutSetPrototypeSettings) {
            stagedLayoutSet.setLayoutSetPrototypeUuid("");
            stagedLayoutSet.setLayoutSetPrototypeLinkEnabled(false);
        }
        if (!(layoutSetSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LAYOUT_SET_SETTINGS"))) {
            stagedLayoutSet.setSettings("");
        }
        Element stagedLayoutSetElement = portletDataContext.getExportDataElement((ClassedModel)stagedLayoutSet);
        UnicodeProperties settingsProperties = stagedLayoutSet.getSettingsProperties();
        settingsProperties.remove((Object)"last-publish-date");
        stagedLayoutSet = this.unwrapLayoutSetStagingHandler(stagedLayoutSet);
        portletDataContext.addClassedModel(stagedLayoutSetElement, ExportImportPathUtil.getModelPath((StagedModel)stagedLayoutSet), (ClassedModel)stagedLayoutSet);
        boolean updateLastPublishDate = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"UPDATE_LAST_PUBLISH_DATE");
        if (ExportImportThreadLocal.isStagingInProcess() && updateLastPublishDate) {
            this._exportImportProcessCallbackRegistry.registerCallback(portletDataContext.getExportImportProcessId(), (Callable)new UpdateLayoutSetLastPublishDateCallable(portletDataContext.getDateRange(), portletDataContext.getGroupId(), portletDataContext.isPrivateLayout()));
        }
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) throws Exception {
        Optional<StagedLayoutSet> existingLayoutSetOptional = this._stagedLayoutSetStagedModelRepository.fetchExistingLayoutSet(portletDataContext.getScopeGroupId(), stagedLayoutSet.isPrivateLayout());
        stagedLayoutSet.setPrivateLayout(portletDataContext.isPrivateLayout());
        StagedLayoutSet importedStagedLayoutSet = (StagedLayoutSet)stagedLayoutSet.clone();
        importedStagedLayoutSet.setGroupId(portletDataContext.getScopeGroupId());
        String layoutsImportMode = MapUtil.getString((Map)portletDataContext.getParameterMap(), (String)"LAYOUTS_IMPORT_MODE", (String)"MERGE_BY_LAYOUT_UUID");
        if (existingLayoutSetOptional.isPresent() && !layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            StagedLayoutSet existingLayoutSet = existingLayoutSetOptional.get();
            importedStagedLayoutSet.setLayoutSetId(existingLayoutSet.getLayoutSetId());
            importedStagedLayoutSet = this._stagedLayoutSetStagedModelRepository.updateStagedModel(portletDataContext, importedStagedLayoutSet);
        }
        this.importLogo(portletDataContext);
        this.importTheme(portletDataContext, stagedLayoutSet);
        portletDataContext.importClassedModel((ClassedModel)stagedLayoutSet, (ClassedModel)importedStagedLayoutSet);
        Element layoutsElement = portletDataContext.getImportDataGroupElement(Layout.class);
        List layoutElements = layoutsElement.elements();
        this.deleteMissingLayouts(portletDataContext, layoutElements);
        HashSet<Layout> modifiedLayouts = new HashSet<Layout>();
        this.checkLayoutSetPrototypeLayouts(portletDataContext, modifiedLayouts);
        this.updateShowSiteName(portletDataContext, importedStagedLayoutSet);
        this.updateShowSearchHeader(portletDataContext, importedStagedLayoutSet);
        this.updateLastMergeTime(portletDataContext, modifiedLayouts);
        this.updateLayoutPriorities(portletDataContext, layoutElements, portletDataContext.isPrivateLayout());
        this._layoutSetLocalService.updatePageCount(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
    }

    protected void exportLayouts(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) throws PortletDataException {
        portletDataContext.addDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(Layout.class)});
        portletDataContext.getExportDataGroupElement(Layout.class);
        long[] layoutIds = portletDataContext.getLayoutIds();
        List<StagedModel> stagedModels = this._stagedLayoutSetStagedModelRepository.fetchChildrenStagedModels(portletDataContext, stagedLayoutSet);
        for (StagedModel stagedModel : stagedModels) {
            Layout layout = (Layout)stagedModel;
            if (!ArrayUtil.contains((long[])layoutIds, (long)layout.getLayoutId())) {
                Element layoutElement = portletDataContext.getExportDataElement((ClassedModel)layout);
                layoutElement.addAttribute("action", "skip");
                continue;
            }
            try {
                if (!LayoutStagingUtil.prepareLayoutStagingHandler((PortletDataContext)portletDataContext, (Layout)layout)) continue;
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedLayoutSet, (StagedModel)layout, (String)"child");
            }
            catch (Exception e) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to export layout " + layout.getName()), (Throwable)e);
                }
                throw e;
            }
        }
    }

    protected void exportLogo(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) {
        Image image;
        block8: {
            boolean logo = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LOGO");
            if (!logo) {
                stagedLayoutSet.setLogoId(0L);
                return;
            }
            long layoutSetBranchId = MapUtil.getLong((Map)portletDataContext.getParameterMap(), (String)"layoutSetBranchId");
            LayoutSetBranch layoutSetBranch = this._layoutSetBranchLocalService.fetchLayoutSetBranch(layoutSetBranchId);
            image = null;
            if (layoutSetBranch != null) {
                try {
                    image = this._imageLocalService.getImage(layoutSetBranch.getLogoId());
                }
                catch (PortalException pe) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to get logo for layout set branch " + layoutSetBranch.getLayoutSetBranchId()), (Throwable)pe);
                    }
                    break block8;
                }
            }
            try {
                image = this._imageLocalService.getImage(stagedLayoutSet.getLogoId());
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)("Unable to get logo for layout set " + stagedLayoutSet.getLayoutSetId()), (Throwable)pe);
            }
        }
        if (image != null && image.getTextObj() != null) {
            String logoPath = ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext);
            logoPath = logoPath + "/logo";
            Element rootElement = portletDataContext.getExportDataRootElement();
            Element headerElement = rootElement.element("header");
            headerElement.addAttribute("logo-path", logoPath);
            portletDataContext.addZipEntry(logoPath, image.getTextObj());
        }
    }

    protected void exportTheme(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) {
        block7: {
            boolean exportThemeSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"THEME_REFERENCE");
            if (!exportThemeSettings) {
                stagedLayoutSet.setColorSchemeId(ColorSchemeFactoryUtil.getDefaultRegularColorSchemeId());
                stagedLayoutSet.setCss("");
                stagedLayoutSet.setThemeId(ThemeFactoryUtil.getDefaultRegularThemeId((long)stagedLayoutSet.getCompanyId()));
                return;
            }
            long layoutSetBranchId = MapUtil.getLong((Map)portletDataContext.getParameterMap(), (String)"layoutSetBranchId");
            LayoutSetBranch layoutSetBranch = this._layoutSetBranchLocalService.fetchLayoutSetBranch(layoutSetBranchId);
            if (layoutSetBranch != null) {
                try {
                    this._themeExporter.exportTheme(portletDataContext, layoutSetBranch);
                }
                catch (Exception e) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to export theme reference for layout set branch " + layoutSetBranch.getLayoutSetBranchId()), (Throwable)e);
                    }
                    break block7;
                }
            }
            try {
                this._themeExporter.exportTheme(portletDataContext, (LayoutSet)stagedLayoutSet);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block7;
                _log.warn((Object)("Unable to export theme reference for layout set " + stagedLayoutSet.getLayoutSetId()), (Throwable)e);
            }
        }
    }

    protected void importLogo(PortletDataContext portletDataContext) {
        block5: {
            boolean logo = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LOGO");
            if (!logo) {
                return;
            }
            Element rootElement = portletDataContext.getImportDataRootElement();
            Element headerElement = rootElement.element("header");
            String logoPath = headerElement.attributeValue("logo-path");
            byte[] iconBytes = portletDataContext.getZipEntryAsByteArray(logoPath);
            try {
                if (ArrayUtil.isNotEmpty((byte[])iconBytes)) {
                    this._layoutSetLocalService.updateLogo(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout(), true, iconBytes);
                } else {
                    this._layoutSetLocalService.updateLogo(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout(), false, (File)null);
                }
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)"Unable to import logo", (Throwable)pe);
            }
        }
    }

    protected void importTheme(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) {
        block2: {
            try {
                this._themeImporter.importTheme(portletDataContext, (LayoutSet)stagedLayoutSet);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to import theme reference " + stagedLayoutSet.getThemeId()), (Throwable)e);
            }
        }
    }

    protected StagedLayoutSet unwrapLayoutSetStagingHandler(StagedLayoutSet stagedLayoutSet) {
        LayoutSet layoutSet = (LayoutSet)ModelAdapterUtil.adapt((Object)stagedLayoutSet, StagedLayoutSet.class, LayoutSet.class);
        layoutSet = LayoutStagingUtil.mergeLayoutSetRevisionIntoLayoutSet((LayoutSet)layoutSet);
        return (StagedLayoutSet)ModelAdapterUtil.adapt((Object)layoutSet, LayoutSet.class, StagedLayoutSet.class);
    }

    protected void updateLastMergeTime(PortletDataContext portletDataContext, Set<Layout> modifiedLayouts) throws PortalException {
        String layoutsImportMode = MapUtil.getString((Map)portletDataContext.getParameterMap(), (String)"LAYOUTS_IMPORT_MODE", (String)"MERGE_BY_LAYOUT_UUID");
        if (!layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            return;
        }
        Map layouts = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        long lastMergeTime = System.currentTimeMillis();
        for (Layout layout : layouts.values()) {
            if (modifiedLayouts.contains(layout = this._layoutLocalService.getLayout(layout.getPlid()))) continue;
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            typeSettingsProperties.setProperty("last-merge-time", String.valueOf(lastMergeTime));
            this._layoutLocalService.updateLayout(layout);
        }
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
        UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
        String mergeFailFriendlyURLLayouts = settingsProperties.getProperty("merge-fail-friendly-url-layouts");
        if (Validator.isNull((String)mergeFailFriendlyURLLayouts)) {
            settingsProperties.setProperty("last-merge-time", String.valueOf(lastMergeTime));
            this._layoutSetLocalService.updateLayoutSet(layoutSet);
        }
    }

    protected void updateLayoutPriorities(PortletDataContext portletDataContext, List<Element> layoutElements, boolean privateLayout) {
        Map layouts = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        HashMap<Long, Integer> layoutPriorities = new HashMap<Long, Integer>();
        int maxPriority = Integer.MIN_VALUE;
        for (Element layoutElement : layoutElements) {
            long layoutId;
            Layout layout;
            String action = layoutElement.attributeValue("action");
            if (action.equals("skip")) {
                return;
            }
            if (!action.equals("add") || (layout = (Layout)layouts.get(layoutId = GetterUtil.getLong((String)layoutElement.attributeValue("layout-id")))) == null) continue;
            int layoutPriority = GetterUtil.getInteger((String)layoutElement.attributeValue("layout-priority"));
            layoutPriorities.put(layout.getPlid(), layoutPriority);
            if (maxPriority >= layoutPriority) continue;
            maxPriority = layoutPriority;
        }
        List layoutSetLayouts = this._layoutLocalService.getLayouts(portletDataContext.getGroupId(), privateLayout);
        for (Layout layout : layoutSetLayouts) {
            if (layoutPriorities.containsKey(layout.getPlid())) {
                layout.setPriority(((Integer)layoutPriorities.get(layout.getPlid())).intValue());
            } else {
                layout.setPriority(++maxPriority);
            }
            this._layoutLocalService.updateLayout(layout);
        }
    }

    protected void updateShowSearchHeader(PortletDataContext portletDataContext, StagedLayoutSet importedLayoutSet) throws PortalException {
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
        UnicodeProperties importedSettingsProperties = importedLayoutSet.getSettingsProperties();
        UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
        String mergeFailFriendlyURLLayouts = settingsProperties.getProperty("merge-fail-friendly-url-layouts");
        if (Validator.isNull((String)mergeFailFriendlyURLLayouts)) {
            boolean showSearchHeader = GetterUtil.getBoolean((String)importedSettingsProperties.getProperty("lfr-theme:regular:show-header-search"), (boolean)true);
            if (!showSearchHeader) {
                settingsProperties.setProperty("lfr-theme:regular:show-header-search", String.valueOf(showSearchHeader));
            }
            this._layoutSetLocalService.updateLayoutSet(layoutSet);
        }
    }

    protected void updateShowSiteName(PortletDataContext portletDataContext, StagedLayoutSet importedLayoutSet) throws PortalException {
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
        UnicodeProperties importedSettingsProperties = importedLayoutSet.getSettingsProperties();
        UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
        String mergeFailFriendlyURLLayouts = settingsProperties.getProperty("merge-fail-friendly-url-layouts");
        if (Validator.isNull((String)mergeFailFriendlyURLLayouts)) {
            boolean showSiteName = GetterUtil.getBoolean((String)importedSettingsProperties.getProperty("showSiteName", Boolean.TRUE.toString()));
            if (!showSiteName) {
                settingsProperties.setProperty("showSiteName", String.valueOf(showSiteName));
            }
            this._layoutSetLocalService.updateLayoutSet(layoutSet);
        }
    }

    private class UpdateLayoutSetLastPublishDateCallable
    implements Callable<Void> {
        private final DateRange _dateRange;
        private final long _groupId;
        private final boolean _privateLayout;

        public UpdateLayoutSetLastPublishDateCallable(DateRange dateRange, long groupId, boolean privateLayout) {
            this._dateRange = dateRange;
            this._groupId = groupId;
            this._privateLayout = privateLayout;
        }

        @Override
        public Void call() throws PortalException {
            Group group = StagedLayoutSetStagedModelDataHandler.this._groupLocalService.getGroup(this._groupId);
            Date endDate = null;
            if (this._dateRange != null) {
                endDate = this._dateRange.getEndDate();
            }
            if (group.hasStagingGroup()) {
                Group stagingGroup = group.getStagingGroup();
                ExportImportDateUtil.updateLastPublishDate((long)stagingGroup.getGroupId(), (boolean)this._privateLayout, (DateRange)this._dateRange, (Date)endDate);
            } else {
                ExportImportDateUtil.updateLastPublishDate((long)this._groupId, (boolean)this._privateLayout, (DateRange)this._dateRange, (Date)endDate);
            }
            return null;
        }
    }
}

