Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/plugins/page-structure/selectors/selectPanels", ['module', 'exports', 'require', '../../../app/config/constants/editableTypes', '../../../app/config/constants/fragmentConfigurationRoles', '../../../app/config/constants/itemTypes', '../../../app/config/constants/layoutDataItemTypes', '../../../app/config/constants/viewportSizes', '../../../app/selectors/selectCanUpdateEditables', '../../../app/selectors/selectCanUpdateItemConfiguration', '../../../app/selectors/selectEditableValue', '../../../app/utils/isMapped', '../components/item-configuration-panels/CollectionGeneralPanel', '../components/item-configuration-panels/ContainerLinkPanel', '../components/item-configuration-panels/ContainerStylesPanel', '../components/item-configuration-panels/EditableLinkPanel', '../components/item-configuration-panels/FragmentGeneralPanel', '../components/item-configuration-panels/FragmentStylesPanel', '../components/item-configuration-panels/ImagePropertiesPanel', '../components/item-configuration-panels/MappingPanel', '../components/item-configuration-panels/RowGeneralPanel', '../components/item-configuration-panels/RowStylesPanel'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.selectPanels = exports.PANELS = exports.PANEL_IDS = void 0;

    var _editableTypes = require("../../../app/config/constants/editableTypes");

    var _fragmentConfigurationRoles = require("../../../app/config/constants/fragmentConfigurationRoles");

    var _itemTypes = require("../../../app/config/constants/itemTypes");

    var _layoutDataItemTypes = require("../../../app/config/constants/layoutDataItemTypes");

    var _viewportSizes = require("../../../app/config/constants/viewportSizes");

    var _selectCanUpdateEditables = _interopRequireDefault(require("../../../app/selectors/selectCanUpdateEditables"));

    var _selectCanUpdateItemConfiguration = _interopRequireDefault(require("../../../app/selectors/selectCanUpdateItemConfiguration"));

    var _selectEditableValue = _interopRequireDefault(require("../../../app/selectors/selectEditableValue"));

    var _isMapped = _interopRequireDefault(require("../../../app/utils/isMapped"));

    var _CollectionGeneralPanel = require("../components/item-configuration-panels/CollectionGeneralPanel");

    var _ContainerLinkPanel = _interopRequireDefault(require("../components/item-configuration-panels/ContainerLinkPanel"));

    var _ContainerStylesPanel = require("../components/item-configuration-panels/ContainerStylesPanel");

    var _EditableLinkPanel = _interopRequireDefault(require("../components/item-configuration-panels/EditableLinkPanel"));

    var _FragmentGeneralPanel = require("../components/item-configuration-panels/FragmentGeneralPanel");

    var _FragmentStylesPanel = require("../components/item-configuration-panels/FragmentStylesPanel");

    var _ImagePropertiesPanel = require("../components/item-configuration-panels/ImagePropertiesPanel");

    var _MappingPanel = require("../components/item-configuration-panels/MappingPanel");

    var _RowGeneralPanel = require("../components/item-configuration-panels/RowGeneralPanel");

    var _RowStylesPanel = require("../components/item-configuration-panels/RowStylesPanel");

    var _PANELS;

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var PANEL_IDS = {
      collectionGeneral: 'collectionGeneral',
      containerLink: 'containerLink',
      containerStyles: 'containerStyles',
      editableLink: 'editableLink',
      editableMapping: 'editableMapping',
      fragmentGeneral: 'fragmentGeneral',
      fragmentStyles: 'fragmentStyles',
      imageProperties: 'imageProperties',
      rowGeneral: 'rowGeneral',
      rowStyles: 'rowStyles'
    };
    exports.PANEL_IDS = PANEL_IDS;
    var PANELS = (_PANELS = {}, _defineProperty(_PANELS, PANEL_IDS.collectionGeneral, {
      component: _CollectionGeneralPanel.CollectionGeneralPanel,
      label: Liferay.Language.get('general'),
      priority: 0
    }), _defineProperty(_PANELS, PANEL_IDS.containerLink, {
      component: _ContainerLinkPanel["default"],
      label: Liferay.Language.get('link'),
      priority: 0
    }), _defineProperty(_PANELS, PANEL_IDS.containerStyles, {
      component: _ContainerStylesPanel.ContainerStylesPanel,
      label: Liferay.Language.get('styles'),
      priority: 0
    }), _defineProperty(_PANELS, PANEL_IDS.editableLink, {
      component: _EditableLinkPanel["default"],
      label: Liferay.Language.get('link'),
      priority: 2
    }), _defineProperty(_PANELS, PANEL_IDS.editableMapping, {
      component: _MappingPanel.MappingPanel,
      label: Liferay.Language.get('mapping'),
      priority: 1
    }), _defineProperty(_PANELS, PANEL_IDS.fragmentGeneral, {
      component: _FragmentGeneralPanel.FragmentGeneralPanel,
      label: Liferay.Language.get('general'),
      priority: 1
    }), _defineProperty(_PANELS, PANEL_IDS.fragmentStyles, {
      component: _FragmentStylesPanel.FragmentStylesPanel,
      label: Liferay.Language.get('styles'),
      priority: 0
    }), _defineProperty(_PANELS, PANEL_IDS.imageProperties, {
      component: _ImagePropertiesPanel.ImagePropertiesPanel,
      label: Liferay.Language.get('image'),
      priority: 3
    }), _defineProperty(_PANELS, PANEL_IDS.rowGeneral, {
      component: _RowGeneralPanel.RowGeneralPanel,
      label: Liferay.Language.get('general'),
      priority: 1
    }), _defineProperty(_PANELS, PANEL_IDS.rowStyles, {
      component: _RowStylesPanel.RowStylesPanel,
      label: Liferay.Language.get('styles'),
      priority: 0
    }), _PANELS);
    exports.PANELS = PANELS;

    var selectPanels = function selectPanels(activeItemId, activeItemType, state) {
      var activeItem = null;
      var panelsIds = {};

      if (activeItemType === _itemTypes.ITEM_TYPES.layoutDataItem) {
        activeItem = state.layoutData.items[activeItemId];
      } else if (activeItemType === _itemTypes.ITEM_TYPES.editable) {
        var _state$editables$item;

        var _activeItemId$split = activeItemId.split('-'),
            _activeItemId$split2 = _slicedToArray(_activeItemId$split, 1),
            fragmentEntryLinkId = _activeItemId$split2[0];

        var _ref = Object.values(state.layoutData.items).find(function (item) {
          return item.config.fragmentEntryLinkId === fragmentEntryLinkId;
        }) || {},
            itemId = _ref.itemId;

        activeItem = (_state$editables$item = state.editables[itemId]) === null || _state$editables$item === void 0 ? void 0 : _state$editables$item[activeItemId];
      }

      if (!activeItem) {
        return {
          activeItem: activeItem,
          panelsIds: panelsIds
        };
      }

      var canUpdateEditables = (0, _selectCanUpdateEditables["default"])(state);
      var canUpdateItemConfiguration = (0, _selectCanUpdateItemConfiguration["default"])(state);

      if (canUpdateEditables && activeItem.editableId) {
        var _panelsIds;

        var editableValue = (0, _selectEditableValue["default"])(state, activeItem.fragmentEntryLinkId, activeItem.editableId, activeItem.editableValueNamespace);
        var editableIsMapped = (0, _isMapped["default"])(editableValue);
        panelsIds = (_panelsIds = {}, _defineProperty(_panelsIds, PANEL_IDS.editableLink, [_editableTypes.EDITABLE_TYPES.text, _editableTypes.EDITABLE_TYPES.image, _editableTypes.EDITABLE_TYPES.link].includes(activeItem.type)), _defineProperty(_panelsIds, PANEL_IDS.imageProperties, !editableIsMapped && [_editableTypes.EDITABLE_TYPES.image, _editableTypes.EDITABLE_TYPES.backgroundImage].includes(activeItem.type)), _defineProperty(_panelsIds, PANEL_IDS.editableMapping, true), _panelsIds);
      } else if (activeItem.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection) {
        panelsIds = _defineProperty({}, PANEL_IDS.collectionGeneral, state.selectedViewportSize === _viewportSizes.VIEWPORT_SIZES.desktop && canUpdateItemConfiguration);
      } else if (activeItem.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.container) {
        var _panelsIds3;

        panelsIds = (_panelsIds3 = {}, _defineProperty(_panelsIds3, PANEL_IDS.containerStyles, canUpdateItemConfiguration), _defineProperty(_panelsIds3, PANEL_IDS.containerLink, state.selectedViewportSize === _viewportSizes.VIEWPORT_SIZES.desktop && canUpdateItemConfiguration), _panelsIds3);
      } else if (activeItem.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment) {
        var _state$fragmentEntryL, _state$fragmentEntryL2, _state$fragmentEntryL3, _panelsIds4;

        var fieldSets = (_state$fragmentEntryL = (_state$fragmentEntryL2 = state.fragmentEntryLinks[activeItem.config.fragmentEntryLinkId]) === null || _state$fragmentEntryL2 === void 0 ? void 0 : (_state$fragmentEntryL3 = _state$fragmentEntryL2.configuration) === null || _state$fragmentEntryL3 === void 0 ? void 0 : _state$fragmentEntryL3.fieldSets) !== null && _state$fragmentEntryL !== void 0 ? _state$fragmentEntryL : [];
        panelsIds = (_panelsIds4 = {}, _defineProperty(_panelsIds4, PANEL_IDS.fragmentStyles, canUpdateItemConfiguration), _defineProperty(_panelsIds4, PANEL_IDS.fragmentGeneral, state.selectedViewportSize === _viewportSizes.VIEWPORT_SIZES.desktop && canUpdateItemConfiguration && fieldSets.some(function (fieldSet) {
          return fieldSet.configurationRole !== _fragmentConfigurationRoles.FRAGMENT_CONFIGURATION_ROLES.style;
        })), _panelsIds4);
      } else if (activeItem.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row) {
        var _panelsIds5;

        panelsIds = (_panelsIds5 = {}, _defineProperty(_panelsIds5, PANEL_IDS.rowStyles, canUpdateItemConfiguration), _defineProperty(_panelsIds5, PANEL_IDS.rowGeneral, canUpdateItemConfiguration && state.selectedViewportSize === _viewportSizes.VIEWPORT_SIZES.desktop), _panelsIds5);
      }

      return {
        activeItem: activeItem,
        panelsIds: panelsIds
      };
    };

    exports.selectPanels = selectPanels;
    //# sourceMappingURL=selectPanels.js.map
  }
});
//# sourceMappingURL=selectPanels.js.map