Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/plugins/page-structure/components/item-configuration-panels/RowStylesPanel", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../../app/config/constants/columnSizes', '../../../../app/config/constants/viewportSizes', '../../../../app/config/index', '../../../../app/selectors/selectSegmentsExperienceId', '../../../../app/store/index', '../../../../app/thunks/updateItemConfig', '../../../../app/thunks/updateRowColumns', '../../../../app/utils/checkDeepEqual', '../../../../app/utils/getResponsiveColumnSize', '../../../../app/utils/getResponsiveConfig', '../../../../app/utils/useId', '../../../../prop-types/index', './CommonStyles'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.RowStylesPanel = void 0;

    var _form = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/form"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _columnSizes = require("../../../../app/config/constants/columnSizes");

    var _viewportSizes = require("../../../../app/config/constants/viewportSizes");

    var _index = require("../../../../app/config/index");

    var _selectSegmentsExperienceId = _interopRequireDefault(require("../../../../app/selectors/selectSegmentsExperienceId"));

    var _index2 = require("../../../../app/store/index");

    var _updateItemConfig = _interopRequireDefault(require("../../../../app/thunks/updateItemConfig"));

    var _updateRowColumns = _interopRequireDefault(require("../../../../app/thunks/updateRowColumns"));

    var _checkDeepEqual = require("../../../../app/utils/checkDeepEqual");

    var _getResponsiveColumnSize = require("../../../../app/utils/getResponsiveColumnSize");

    var _getResponsiveConfig2 = require("../../../../app/utils/getResponsiveConfig");

    var _useId = require("../../../../app/utils/useId");

    var _index3 = require("../../../../prop-types/index");

    var _CommonStyles = require("./CommonStyles");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    var CUSTOM_ROW = 'custom';
    var MODULES_PER_ROW_OPTIONS = [[1], [1, 2], [1, 3], [1, 2, 4], [1, 2, 5], [1, 2, 3, 6]];
    var MODULES_PER_ROW_OPTIONS_WITH_CUSTOM = MODULES_PER_ROW_OPTIONS.map(function (option) {
      return [CUSTOM_ROW].concat(_toConsumableArray(option));
    });
    var VERTICAL_ALIGNMENT_OPTIONS = [{
      label: Liferay.Language.get('top'),
      value: 'top'
    }, {
      label: Liferay.Language.get('middle'),
      value: 'middle'
    }, {
      label: Liferay.Language.get('bottom'),
      value: 'bottom'
    }];
    var ROW_STYLE_IDENTIFIERS = {
      modulesPerRow: 'modulesPerRow',
      reverseOrder: 'reverseOrder',
      verticalAlignment: 'verticalAlignment'
    };

    var RowStylesPanel = function RowStylesPanel(_ref) {
      var item = _ref.item;
      var availableViewportSizes = _index.config.availableViewportSizes;
      var dispatch = (0, _index2.useDispatch)();
      var layoutData = (0, _index2.useSelector)(function (state) {
        return state.layoutData;
      });
      var segmentsExperienceId = (0, _index2.useSelector)(_selectSegmentsExperienceId["default"]);
      var selectedViewportSize = (0, _index2.useSelector)(function (state) {
        return state.selectedViewportSize;
      });
      var viewportSize = availableViewportSizes[selectedViewportSize];
      var rowConfig = (0, _getResponsiveConfig2.getResponsiveConfig)(item.config, selectedViewportSize);

      var onCustomStylesValueSelect = function onCustomStylesValueSelect(identifier, value) {
        var itemStyles = _defineProperty({}, identifier, value);

        if (selectedViewportSize !== _viewportSizes.VIEWPORT_SIZES.desktop && identifier !== ROW_STYLE_IDENTIFIERS.gutters) {
          itemStyles = _defineProperty({}, selectedViewportSize, itemStyles);
        }

        if (identifier === ROW_STYLE_IDENTIFIERS.numberOfColumns) {
          var currentNumberOfColumns = rowConfig.numberOfColumns;
          var newNumberOfColumns = value;
          var columnsToBeModified = Math.abs(newNumberOfColumns - currentNumberOfColumns);

          if (columnsToBeModified === 0) {
            return;
          }

          if (item && item.itemId) {
            dispatch((0, _updateRowColumns["default"])({
              itemId: item.itemId,
              numberOfColumns: newNumberOfColumns,
              segmentsExperienceId: segmentsExperienceId,
              viewportSizeId: selectedViewportSize
            }));
          }

          return;
        }

        dispatch((0, _updateItemConfig["default"])({
          itemConfig: itemStyles,
          itemId: item.itemId,
          segmentsExperienceId: segmentsExperienceId
        }));
      };

      var getModulesPerRowOptionLabel = function getModulesPerRowOptionLabel(value) {
        return value > 1 ? Liferay.Language.get('x-modules-per-row') : Liferay.Language.get('x-module-per-row');
      };

      var isCustomRow = (0, _react.useMemo)(function () {
        var _COLUMN_SIZE_MODULE_P, _COLUMN_SIZE_MODULE_P2;

        var numberOfColumns = rowConfig.numberOfColumns;

        var _getResponsiveConfig = (0, _getResponsiveConfig2.getResponsiveConfig)(rowConfig, selectedViewportSize),
            modulesPerRow = _getResponsiveConfig.modulesPerRow;

        var columnSizes = item.children.map(function (columnId) {
          var columnSizeConfig = (0, _getResponsiveColumnSize.getResponsiveColumnSize)(layoutData.items[columnId].config, selectedViewportSize);
          return columnSizeConfig;
        });
        var columnConfiguration = (_COLUMN_SIZE_MODULE_P = (_COLUMN_SIZE_MODULE_P2 = _columnSizes.COLUMN_SIZE_MODULE_PER_ROW_SIZES[numberOfColumns]) === null || _COLUMN_SIZE_MODULE_P2 === void 0 ? void 0 : _COLUMN_SIZE_MODULE_P2[modulesPerRow]) !== null && _COLUMN_SIZE_MODULE_P !== void 0 ? _COLUMN_SIZE_MODULE_P : [];
        return !(0, _checkDeepEqual.deepEqual)(columnConfiguration, columnSizes);
      }, [item.children, layoutData.items, rowConfig, selectedViewportSize]);
      var modulesPerRowOptions = isCustomRow ? MODULES_PER_ROW_OPTIONS_WITH_CUSTOM : MODULES_PER_ROW_OPTIONS;
      return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement("p", {
        className: "page-editor__row-styles-panel__viewport-label"
      }, _react["default"].createElement(_icon["default"], {
        className: "mr-2",
        symbol: viewportSize.icon
      }), viewportSize.label), _react["default"].createElement("div", {
        className: "page-editor__page-structure__section__custom-styles"
      }, _react["default"].createElement("h1", {
        className: "sr-only"
      }, Liferay.Language.get('custom-styles')), _react["default"].createElement(Select, {
        configurationKey: "modulesPerRow",
        handleChange: onCustomStylesValueSelect,
        label: Liferay.Language.get('layout'),
        options: modulesPerRowOptions[rowConfig.numberOfColumns - 1].map(function (option) {
          return {
            disabled: option === CUSTOM_ROW,
            label: option === CUSTOM_ROW ? Liferay.Language.get('custom') : Liferay.Util.sub(getModulesPerRowOptionLabel(option), option),
            value: option
          };
        }),
        value: isCustomRow ? CUSTOM_ROW : rowConfig.modulesPerRow
      }), rowConfig.numberOfColumns === 2 && rowConfig.modulesPerRow === 1 && !isCustomRow && _react["default"].createElement(_form.ClayCheckbox, {
        checked: rowConfig.reverseOrder,
        label: Liferay.Language.get('inverse-order'),
        onChange: function onChange(_ref2) {
          var checked = _ref2.target.checked;
          return onCustomStylesValueSelect('reverseOrder', checked);
        }
      }), _react["default"].createElement(Select, {
        configurationKey: "verticalAlignment",
        handleChange: onCustomStylesValueSelect,
        label: Liferay.Language.get('vertical-alignment'),
        options: VERTICAL_ALIGNMENT_OPTIONS,
        value: rowConfig.verticalAlignment
      })), _react["default"].createElement(_CommonStyles.CommonStyles, {
        commonStylesValues: rowConfig.styles,
        item: item
      }));
    };

    exports.RowStylesPanel = RowStylesPanel;

    var Select = function Select(_ref3) {
      var configurationKey = _ref3.configurationKey,
          handleChange = _ref3.handleChange,
          label = _ref3.label,
          options = _ref3.options,
          value = _ref3.value;
      var inputId = (0, _useId.useId)();
      return _react["default"].createElement(_form["default"].Group, {
        small: true
      }, _react["default"].createElement("label", {
        htmlFor: inputId
      }, label), _react["default"].createElement(_form.ClaySelectWithOption, {
        id: inputId,
        onChange: function onChange(event) {
          var nextValue = event.target.value;
          handleChange(configurationKey, typeof value === 'string' ? String(nextValue) : Number(nextValue));
        },
        options: options,
        value: String(value)
      }));
    };
    //# sourceMappingURL=RowStylesPanel.js.map
  }
});
//# sourceMappingURL=RowStylesPanel.js.map