Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/plugins/page-design-options/components/PageDesignOptionsSidebar", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/card', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/link', '@frontend-taglib-clay$clayui/tabs', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', '../../../app/config/constants/layoutTypes', '../../../app/config/index', '../../../app/services/LayoutService', '../../../app/store/index', '../../../app/thunks/changeMasterLayout', '../../../app/utils/useId', '../../../common/components/SidebarPanelContent', '../../../common/components/SidebarPanelHeader', '../hooks/useStyleBook'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = PageDesignOptionsSidebar;

    var _card = _interopRequireDefault(require("@frontend-taglib-clay$clayui/card"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _link = _interopRequireDefault(require("@frontend-taglib-clay$clayui/link"));

    var _tabs = _interopRequireDefault(require("@frontend-taglib-clay$clayui/tabs"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _layoutTypes = require("../../../app/config/constants/layoutTypes");

    var _index = require("../../../app/config/index");

    var _LayoutService = _interopRequireDefault(require("../../../app/services/LayoutService"));

    var _index2 = require("../../../app/store/index");

    var _changeMasterLayout = _interopRequireDefault(require("../../../app/thunks/changeMasterLayout"));

    var _useId = require("../../../app/utils/useId");

    var _SidebarPanelContent = _interopRequireDefault(require("../../../common/components/SidebarPanelContent"));

    var _SidebarPanelHeader = _interopRequireDefault(require("../../../common/components/SidebarPanelHeader"));

    var _useStyleBook = require("../hooks/useStyleBook");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var OPTIONS_TYPES = {
      master: 'master',
      styleBook: 'styleBook'
    };

    function PageDesignOptionsSidebar() {
      var dispatch = (0, _index2.useDispatch)();
      var selectedStyleBook = (0, _useStyleBook.useStyleBook)();
      var setSelectedStyleBook = (0, _useStyleBook.useSetStyleBook)();
      var masterLayoutPlid = (0, _index2.useSelector)(function (state) {
        var _state$masterLayout;

        return (_state$masterLayout = state.masterLayout) === null || _state$masterLayout === void 0 ? void 0 : _state$masterLayout.masterLayoutPlid;
      });
      var onSelectMasterLayout = (0, _react.useCallback)(function (masterLayout) {
        dispatch((0, _changeMasterLayout["default"])({
          masterLayoutPlid: masterLayout.masterLayoutPlid
        })).then(function (_ref) {
          var styleBook = _ref.styleBook;

          if (styleBook) {
            setSelectedStyleBook(styleBook);
          }
        });
      }, [dispatch, setSelectedStyleBook]);
      var onSelectStyleBook = (0, _react.useCallback)(function (styleBook) {
        _LayoutService["default"].changeStyleBookEntry({
          onNetworkStatus: function onNetworkStatus() {},
          styleBookEntryId: styleBook.styleBookEntryId
        }).then(function (styleBookWithTokens) {
          setSelectedStyleBook(function (selectedStyleBook) {
            return {
              defaultStyleBookEntryName: selectedStyleBook.defaultStyleBookEntryName,
              styleBookEntryId: styleBook.styleBookEntryId,
              tokenValues: styleBookWithTokens.tokenValues
            };
          });
        });
      }, [setSelectedStyleBook]);
      (0, _react.useEffect)(function () {
        var wrapper = document.getElementById('wrapper');

        if (selectedStyleBook && wrapper) {
          Object.values(selectedStyleBook.tokenValues).forEach(function (token) {
            wrapper.style.setProperty("--".concat(token.cssVariable), token.value);
          });
        }
      }, [selectedStyleBook]);
      var tabs = (0, _react.useMemo)(function () {
        return getTabs(masterLayoutPlid, selectedStyleBook, onSelectMasterLayout, onSelectStyleBook);
      }, [masterLayoutPlid, onSelectMasterLayout, onSelectStyleBook, selectedStyleBook]);

      var _useState = (0, _react.useState)(0),
          _useState2 = _slicedToArray(_useState, 2),
          activeTabId = _useState2[0],
          setActiveTabId = _useState2[1];

      var tabIdNamespace = (0, _useId.useId)();

      var getTabId = function getTabId(tabId) {
        return "".concat(tabIdNamespace, "tab").concat(tabId);
      };

      var getTabPanelId = function getTabPanelId(tabId) {
        return "".concat(tabIdNamespace, "tabPanel").concat(tabId);
      };

      return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_SidebarPanelHeader["default"], {
        className: "justify-content-between"
      }, Liferay.Language.get('page-design-options'), _react["default"].createElement(_link["default"], {
        className: "font-weight-normal",
        href: _index.config.lookAndFeelURL
      }, Liferay.Language.get('more'))), _react["default"].createElement(_SidebarPanelContent["default"], null, _react["default"].createElement(_tabs["default"], {
        className: "page-editor__sidebar__page-design-options__tabs",
        modern: true
      }, tabs.map(function (tab, index) {
        return _react["default"].createElement(_tabs["default"].Item, {
          active: activeTabId === index,
          innerProps: {
            'aria-controls': getTabPanelId(index),
            id: getTabId(index)
          },
          key: index,
          onClick: function onClick() {
            return setActiveTabId(index);
          }
        }, tab.label);
      })), _react["default"].createElement(_tabs["default"].Content, {
        activeIndex: activeTabId,
        fade: true
      }, tabs.map(function (_ref2, index) {
        var icon = _ref2.icon,
            options = _ref2.options,
            type = _ref2.type;
        return _react["default"].createElement(_tabs["default"].TabPane, {
          "aria-labelledby": getTabId(index),
          id: getTabPanelId(index),
          key: index
        }, _react["default"].createElement(OptionList, {
          icon: icon,
          options: options,
          type: type
        }));
      }))));
    }

    var OptionList = function OptionList(_ref3) {
      var _ref3$options = _ref3.options,
          options = _ref3$options === void 0 ? [] : _ref3$options,
          icon = _ref3.icon;
      return _react["default"].createElement("ul", {
        className: "list-unstyled mt-3"
      }, options.map(function (_ref4, index) {
        var imagePreviewURL = _ref4.imagePreviewURL,
            isActive = _ref4.isActive,
            name = _ref4.name,
            _onClick = _ref4.onClick,
            subtitle = _ref4.subtitle;
        return _react["default"].createElement("li", {
          key: index
        }, _react["default"].createElement(_card["default"], {
          "aria-label": name,
          className: (0, _classnames["default"])({
            'page-editor__sidebar__design-options__tab-card--active': isActive
          }),
          displayType: "file",
          onClick: function onClick() {
            if (!isActive) {
              _onClick();
            }
          },
          selectable: true
        }, _react["default"].createElement(_card["default"].AspectRatio, {
          className: "card-item-first",
          containerAspectRatio: "16/9"
        }, imagePreviewURL ? _react["default"].createElement("img", {
          alt: "thumbnail",
          className: "aspect-ratio-item aspect-ratio-item-center-middle aspect-ratio-item-fluid",
          src: imagePreviewURL
        }) : _react["default"].createElement("div", {
          className: "aspect-ratio-item aspect-ratio-item-center-middle aspect-ratio-item-fluid card-type-asset-icon"
        }, _react["default"].createElement(_icon["default"], {
          symbol: icon
        }))), _react["default"].createElement(_card["default"].Body, null, _react["default"].createElement(_card["default"].Row, null, _react["default"].createElement("div", {
          className: "autofit-col autofit-col-expand"
        }, _react["default"].createElement("section", {
          className: "autofit-section"
        }, _react["default"].createElement(_card["default"].Description, {
          displayType: "title"
        }, name), subtitle && _react["default"].createElement(_card["default"].Description, {
          displayType: "subtitle"
        }, subtitle)))))));
      }));
    };

    function getTabs(masterLayoutPlid, selectedStyleBook, onSelectMasterLayout, onSelectStyleBook) {
      var styleBooks = [{
        imagePreviewURL: selectedStyleBook.imagePreviewURL,
        name: _index.config.layoutType === _layoutTypes.LAYOUT_TYPES.master ? Liferay.Language.get('default-style-book') : Liferay.Language.get('inherited-from-master'),
        styleBookEntryId: '0',
        subtitle: selectedStyleBook.defaultStyleBookEntryName || Liferay.Language.get('provided-by-theme')
      }].concat(_toConsumableArray(_index.config.styleBooks));
      var tabs = [{
        icon: 'magic',
        label: Liferay.Language.get('style-book'),
        options: styleBooks.map(function (styleBook) {
          return _objectSpread({}, styleBook, {
            isActive: selectedStyleBook.styleBookEntryId === styleBook.styleBookEntryId,
            onClick: function onClick() {
              return onSelectStyleBook(styleBook);
            }
          });
        }),
        type: OPTIONS_TYPES.styleBook
      }];

      if (_index.config.layoutType !== _layoutTypes.LAYOUT_TYPES.master) {
        tabs.splice(0, 0, {
          disabled: _index.config.layoutType === _layoutTypes.LAYOUT_TYPES.master,
          icon: 'page',
          label: Liferay.Language.get('master'),
          options: _index.config.masterLayouts.map(function (masterLayout) {
            return _objectSpread({}, masterLayout, {
              isActive: masterLayoutPlid === masterLayout.masterLayoutPlid,
              onClick: function onClick() {
                return onSelectMasterLayout(masterLayout);
              }
            });
          }),
          type: OPTIONS_TYPES.master
        });
      }

      return tabs;
    }
    //# sourceMappingURL=PageDesignOptionsSidebar.js.map
  }
});
//# sourceMappingURL=PageDesignOptionsSidebar.js.map