Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/plugins/fragments-widgets/components/TabsPanel", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/tabs', 'frontend-js-react-web$react', '../../../app/utils/useId', '../../../common/components/Collapse', './TabItem'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = TabsPanel;

    var _tabs = _interopRequireDefault(require("@frontend-taglib-clay$clayui/tabs"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _useId = require("../../../app/utils/useId");

    var _Collapse = _interopRequireDefault(require("../../../common/components/Collapse"));

    var _TabItem = _interopRequireDefault(require("./TabItem"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var INITIAL_EXPANDED_ITEM_COLLECTIONS = 3;

    function TabsPanel(_ref) {
      var tabs = _ref.tabs;

      var _useState = (0, _react.useState)(0),
          _useState2 = _slicedToArray(_useState, 2),
          activeTabId = _useState2[0],
          setActiveTabId = _useState2[1];

      var tabIdNamespace = (0, _useId.useId)();

      var getTabId = function getTabId(tabId) {
        return "".concat(tabIdNamespace, "tab").concat(tabId);
      };

      var getTabPanelId = function getTabPanelId(tabId) {
        return "".concat(tabIdNamespace, "tabPanel").concat(tabId);
      };

      return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_tabs["default"], {
        className: "page-editor__sidebar__fragments-widgets-panel__tabs",
        modern: true
      }, tabs.map(function (tab, index) {
        return _react["default"].createElement(_tabs["default"].Item, {
          active: activeTabId === index,
          innerProps: {
            'aria-controls': getTabPanelId(index),
            id: getTabId(index)
          },
          key: index,
          onClick: function onClick() {
            return setActiveTabId(index);
          }
        }, tab.label);
      })), _react["default"].createElement(_tabs["default"].Content, {
        activeIndex: activeTabId,
        className: "page-editor__sidebar__fragments-widgets-panel__tab-content",
        fade: true
      }, tabs.map(function (tab, index) {
        return _react["default"].createElement(_tabs["default"].TabPane, {
          "aria-labelledby": getTabId(index),
          id: getTabPanelId(index),
          key: index
        }, _react["default"].createElement("ul", {
          className: "list-unstyled"
        }, _react["default"].createElement(Collections, {
          collections: tab.collections,
          open: true
        })));
      })));
    }

    var Collections = function Collections(_ref2) {
      var collections = _ref2.collections,
          open = _ref2.open;
      return collections.map(function (collection, index) {
        return _react["default"].createElement(_Collapse["default"], {
          key: collection.collectionId,
          label: collection.label,
          open: open && index < INITIAL_EXPANDED_ITEM_COLLECTIONS
        }, collection.collections && _react["default"].createElement(Collections, {
          collections: collection.collections
        }), _react["default"].createElement("ul", {
          className: "list-unstyled"
        }, collection.children.map(function (item, index) {
          var _item$portletItems;

          return _react["default"].createElement(_react["default"].Fragment, {
            key: index
          }, _react["default"].createElement(_TabItem["default"], {
            item: item
          }), ((_item$portletItems = item.portletItems) === null || _item$portletItems === void 0 ? void 0 : _item$portletItems.length) && _react["default"].createElement(TabPortletItem, {
            item: item
          }));
        })));
      });
    };

    var TabPortletItem = function TabPortletItem(_ref3) {
      var item = _ref3.item;
      return item.portletItems.map(function (portlet, index) {
        return _react["default"].createElement(_TabItem["default"], {
          item: portlet,
          key: index
        });
      });
    };
    //# sourceMappingURL=TabsPanel.js.map
  }
});
//# sourceMappingURL=TabsPanel.js.map