Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/plugins/fragments-widgets/components/FragmentsSidebar", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../../app/config/constants/layoutDataItemTypes', '../../../app/store/index', '../../../common/components/SearchForm', '../../../common/components/SidebarPanelContent', '../../../common/components/SidebarPanelHeader', './SearchResultsPanel', './TabsPanel'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = FragmentsSidebar;

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _layoutDataItemTypes = require("../../../app/config/constants/layoutDataItemTypes");

    var _index = require("../../../app/store/index");

    var _SearchForm = _interopRequireDefault(require("../../../common/components/SearchForm"));

    var _SidebarPanelContent = _interopRequireDefault(require("../../../common/components/SidebarPanelContent"));

    var _SidebarPanelHeader = _interopRequireDefault(require("../../../common/components/SidebarPanelHeader"));

    var _SearchResultsPanel = _interopRequireDefault(require("./SearchResultsPanel"));

    var _TabsPanel = _interopRequireDefault(require("./TabsPanel"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var BASIC_COMPONENT_COLLECTION = 'BASIC_COMPONENT';

    function FragmentsSidebar() {
      var fragments = (0, _index.useSelector)(function (state) {
        return state.fragments;
      });
      var widgets = (0, _index.useSelector)(function (state) {
        return state.widgets;
      });

      var _useState = (0, _react.useState)(''),
          _useState2 = _slicedToArray(_useState, 2),
          searchValue = _useState2[0],
          setSearchValue = _useState2[1];

      var searchValueLowerCase = (0, _react.useMemo)(function () {
        return searchValue.toLowerCase();
      }, [searchValue]);
      var tabs = (0, _react.useMemo)(function () {
        return [{
          collections: fragments.map(function (collection) {
            return {
              children: collection.fragmentEntries.map(function (fragmentEntry) {
                return normalizeFragmentEntry(fragmentEntry, collection.fragmentCollectionId);
              }),
              collectionId: collection.fragmentCollectionId,
              label: collection.name
            };
          }),
          label: Liferay.Language.get('fragments')
        }, {
          collections: widgets.map(function (collection) {
            return normalizeCollections(collection);
          }),
          label: Liferay.Language.get('widgets')
        }];
      }, [fragments, widgets]);
      var filteredTabs = (0, _react.useMemo)(function () {
        return searchValueLowerCase ? tabs.map(function (tab) {
          return _objectSpread({}, tab, {
            collections: tab.collections.map(function (collection) {
              var filteredChildren = collection.children;

              if (collection.collections) {
                filteredChildren = filteredChildren.concat(collection.collections.map(collectionFilter)).flat();
              }

              return _objectSpread({}, collection, {
                children: filteredChildren.filter(function (item) {
                  return item.label.toLowerCase().indexOf(searchValueLowerCase) !== -1;
                })
              });
            }).filter(function (collection) {
              return collection.children.length;
            })
          });
        }).filter(function (tab) {
          return tab.collections.length;
        }) : tabs;
      }, [tabs, searchValueLowerCase]);
      return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_SidebarPanelHeader["default"], null, Liferay.Language.get('fragments-and-widgets')), _react["default"].createElement(_SidebarPanelContent["default"], {
        className: "page-editor__sidebar__fragments-widgets-panel"
      }, _react["default"].createElement(_SearchForm["default"], {
        onChange: setSearchValue,
        value: searchValue
      }), searchValue ? _react["default"].createElement(_SearchResultsPanel["default"], {
        filteredTabs: filteredTabs
      }) : _react["default"].createElement(_TabsPanel["default"], {
        tabs: tabs
      })));
    }

    var normalizeCollections = function normalizeCollections(collection) {
      var _collection$categorie;

      var normalizedElement = {
        children: collection.portlets.map(normalizeWidget),
        collectionId: collection.path,
        label: collection.title
      };

      if ((_collection$categorie = collection.categories) === null || _collection$categorie === void 0 ? void 0 : _collection$categorie.length) {
        normalizedElement.collections = collection.categories.map(normalizeCollections);
      }

      return normalizedElement;
    };

    var normalizeFragmentEntry = function normalizeFragmentEntry(fragmentEntry, collectionId) {
      if (!fragmentEntry.fragmentEntryKey) {
        return fragmentEntry;
      }

      return {
        data: {
          fragmentEntryKey: fragmentEntry.fragmentEntryKey,
          groupId: fragmentEntry.groupId,
          type: fragmentEntry.type
        },
        icon: fragmentEntry.icon,
        itemId: fragmentEntry.fragmentEntryKey,
        label: fragmentEntry.name,
        preview: collectionId !== BASIC_COMPONENT_COLLECTION ? fragmentEntry.imagePreviewURL : null,
        type: _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment
      };
    };

    var normalizeWidget = function normalizeWidget(widget) {
      var _widget$portletItems;

      return {
        data: {
          instanceable: widget.instanceable,
          portletId: widget.portletId,
          portletItemId: widget.portletItemId || null,
          used: widget.used
        },
        disabled: !widget.instanceable && widget.used,
        icon: widget.instanceable ? 'cards2' : 'square-hole',
        itemId: widget.portletId,
        label: widget.title,
        portletItems: ((_widget$portletItems = widget.portletItems) === null || _widget$portletItems === void 0 ? void 0 : _widget$portletItems.length) ? widget.portletItems.map(normalizeWidget) : null,
        preview: '',
        type: _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment
      };
    };

    var collectionFilter = function collectionFilter(collection) {
      return collection.collections.reduce(function (acc, item) {
        var _item$collections;

        return ((_item$collections = item.collections) === null || _item$collections === void 0 ? void 0 : _item$collections.length) > 0 ? acc.concat(item.children, collectionFilter(item)) : acc.concat(item.children);
      }, []);
    };
    //# sourceMappingURL=FragmentsSidebar.js.map
  }
});
//# sourceMappingURL=FragmentsSidebar.js.map