Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/plugins/experience/thunks/removeExperience", ['module', 'exports', 'require', '../../../app/config/index', '../../../app/services/ExperienceService', '../actions/deleteExperience', '../actions/selectExperience'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = removeExperience;

    var _index = require("../../../app/config/index");

    var _ExperienceService = _interopRequireDefault(require("../../../app/services/ExperienceService"));

    var _deleteExperience = _interopRequireDefault(require("../actions/deleteExperience"));

    var _selectExperience = _interopRequireDefault(require("../actions/selectExperience"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function removeExperience(_ref) {
      var segmentsExperienceId = _ref.segmentsExperienceId,
          selectedExperienceId = _ref.selectedExperienceId;
      return function (dispatch) {
        if (segmentsExperienceId === selectedExperienceId) {
          return _ExperienceService["default"].selectExperience({
            body: {
              segmentsExperienceId: _index.config.defaultSegmentsExperienceId
            },
            dispatch: dispatch
          }).then(function (portletIds) {
            dispatch((0, _selectExperience["default"])({
              portletIds: portletIds,
              segmentsExperienceId: _index.config.defaultSegmentsExperienceId
            }));

            _ExperienceService["default"].removeExperience({
              body: {
                segmentsExperienceId: segmentsExperienceId
              },
              dispatch: dispatch
            }).then(function () {
              return dispatch((0, _deleteExperience["default"])({
                segmentsExperienceId: segmentsExperienceId
              }));
            });
          });
        } else {
          return _ExperienceService["default"].removeExperience({
            body: {
              segmentsExperienceId: segmentsExperienceId
            },
            dispatch: dispatch
          }).then(function () {
            return dispatch((0, _deleteExperience["default"])({
              segmentsExperienceId: segmentsExperienceId
            }));
          });
        }
      };
    }
    //# sourceMappingURL=removeExperience.js.map
  }
});
//# sourceMappingURL=removeExperience.js.map