Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/plugins/experience/components/ExperiencesList", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/list', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../app/store/index', '../thunks/selectExperience', '../types', './ExperienceItem'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _list = _interopRequireDefault(require("@frontend-taglib-clay$clayui/list"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _index = require("../../../app/store/index");

    var _selectExperience = _interopRequireDefault(require("../thunks/selectExperience"));

    var _types = require("../types");

    var _ExperienceItem = _interopRequireDefault(require("./ExperienceItem"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var ExperiencesList = function ExperiencesList(_ref) {
      var activeExperienceId = _ref.activeExperienceId,
          canUpdateExperiences = _ref.canUpdateExperiences,
          defaultExperienceId = _ref.defaultExperienceId,
          experiences = _ref.experiences,
          onDeleteExperience = _ref.onDeleteExperience,
          onEditExperience = _ref.onEditExperience,
          onPriorityDecrease = _ref.onPriorityDecrease,
          onPriorityIncrease = _ref.onPriorityIncrease;
      var dispatch = (0, _index.useDispatch)();

      var handleExperienceSelection = function handleExperienceSelection(id) {
        return dispatch((0, _selectExperience["default"])({
          id: id
        }));
      };

      return _react["default"].createElement(_list["default"], {
        className: "mt-3"
      }, experiences.map(function (experience, i) {
        var active = experience.segmentsExperienceId === activeExperienceId;
        var lockedDecreasePriority = experiences.length - 2 === i;

        var editable = canUpdateExperiences && experience.segmentsExperienceId !== defaultExperienceId && !experience.hasLockedSegmentsExperiment;
        return _react["default"].createElement(_ExperienceItem["default"], {
          active: active,
          editable: editable,
          experience: experience,
          key: experience.segmentsExperienceId,
          lockedDecreasePriority: lockedDecreasePriority,
          lockedIncreasePriority: i === 0,
          onDeleteExperience: onDeleteExperience,
          onEditExperience: onEditExperience,
          onPriorityDecrease: onPriorityDecrease,
          onPriorityIncrease: onPriorityIncrease,
          onSelect: handleExperienceSelection
        });
      }));
    };

    var _default = ExperiencesList;
    exports["default"] = _default;
    //# sourceMappingURL=ExperiencesList.js.map
  }
});
//# sourceMappingURL=ExperiencesList.js.map