Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/plugins/comments/components/ResolvedCommentsToggle", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/form', 'frontend-js-react-web$react', '../../../app/actions/toggleShowResolvedComments', '../../../app/store/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = ResolvedCommentsToggle;

    var _form = require("@frontend-taglib-clay$clayui/form");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _toggleShowResolvedComments = _interopRequireDefault(require("../../../app/actions/toggleShowResolvedComments"));

    var _index = require("../../../app/store/index");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function ResolvedCommentsToggle() {
      var dispatch = (0, _index.useDispatch)();
      var showResolvedComments = (0, _index.useSelector)(function (state) {
        return !!state.showResolvedComments;
      });
      var hasResolvedComments = (0, _index.useSelector)(function (state) {
        return Object.values(state.fragmentEntryLinks || {}).some(function (fragmentEntryLink) {
          return fragmentEntryLink.comments && fragmentEntryLink.comments.some(function (comment) {
            return comment.resolved;
          });
        });
      });
      (0, _react.useEffect)(function () {
        if (!hasResolvedComments) {
          dispatch((0, _toggleShowResolvedComments["default"])({
            showResolvedComments: false
          }));
        }
      }, [dispatch, hasResolvedComments]);
      return _react["default"].createElement("div", {
        className: "pb-3 px-3"
      }, _react["default"].createElement(_form.ClayCheckbox, {
        checked: showResolvedComments,
        disabled: !showResolvedComments && !hasResolvedComments,
        label: Liferay.Language.get('show-resolved-comments'),
        onChange: function onChange(event) {
          return dispatch((0, _toggleShowResolvedComments["default"])({
            showResolvedComments: Boolean(event.target.checked)
          }));
        }
      }));
    }
    //# sourceMappingURL=ResolvedCommentsToggle.js.map
  }
});
//# sourceMappingURL=ResolvedCommentsToggle.js.map