Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/plugins/comments/components/CommentsSidebar", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../../app/components/Controls', '../../../app/config/constants/highlightedCommentIdKey', '../../../app/config/constants/layoutDataItemTypes', '../../../app/store/index', './FragmentComments', './FragmentEntryLinksWithComments'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = CommentsSidebar;

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _Controls = require("../../../app/components/Controls");

    var _highlightedCommentIdKey = require("../../../app/config/constants/highlightedCommentIdKey");

    var _layoutDataItemTypes = require("../../../app/config/constants/layoutDataItemTypes");

    var _index = require("../../../app/store/index");

    var _FragmentComments = _interopRequireDefault(require("./FragmentComments"));

    var _FragmentEntryLinksWithComments = _interopRequireDefault(require("./FragmentEntryLinksWithComments"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function getActiveFragmentEntryLink(_ref) {
      var fragmentEntryLinks = _ref.fragmentEntryLinks,
          highlightMessageId = _ref.highlightMessageId,
          itemId = _ref.itemId,
          layoutData = _ref.layoutData;

      if (highlightMessageId) {
        return Object.values(fragmentEntryLinks).find(function (fragmentEntryLink) {
          return fragmentEntryLink.comments.some(function (comment) {
            var _comment$children;

            return comment.commentId === highlightMessageId || ((_comment$children = comment.children) === null || _comment$children === void 0 ? void 0 : _comment$children.some(function (childComment) {
              return childComment.commentId === highlightMessageId;
            }));
          });
        });
      } else {
        var item = layoutData.items[itemId];

        if (item) {
          if (item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment) {
            return fragmentEntryLinks[item.config.fragmentEntryLinkId];
          } else if (item.parentId) {
            return getActiveFragmentEntryLink({
              fragmentEntryLinks: fragmentEntryLinks,
              itemId: item.parentId,
              layoutData: layoutData
            });
          }
        }
      }

      return null;
    }

    function CommentsSidebar() {
      var fragmentEntryLinks = (0, _index.useSelector)(function (state) {
        return state.fragmentEntryLinks;
      });
      var layoutData = (0, _index.useSelector)(function (state) {
        return state.layoutData;
      });
      var activeItemId = (0, _Controls.useActiveItemId)();
      var selectItem = (0, _Controls.useSelectItem)();
      var highlightMessageId = window.sessionStorage.getItem(_highlightedCommentIdKey.HIGHLIGHTED_COMMENT_ID_KEY);
      var activeFragmentEntryLink = getActiveFragmentEntryLink({
        fragmentEntryLinks: fragmentEntryLinks,
        highlightMessageId: highlightMessageId,
        itemId: activeItemId,
        layoutData: layoutData
      });

      if (highlightMessageId && activeFragmentEntryLink) {
        var activeItem = Object.values(layoutData.items).find(function (item) {
          return item.config.fragmentEntryLinkId === activeFragmentEntryLink.fragmentEntryLinkId;
        });
        selectItem(activeItem.itemId);
      }

      return _react["default"].createElement("div", {
        onMouseDown: function onMouseDown(event) {
          return event.nativeEvent.stopImmediatePropagation();
        }
      }, activeFragmentEntryLink ? _react["default"].createElement(_FragmentComments["default"], {
        fragmentEntryLink: activeFragmentEntryLink
      }) : _react["default"].createElement(_FragmentEntryLinksWithComments["default"], null));
    }
    //# sourceMappingURL=CommentsSidebar.js.map
  }
});
//# sourceMappingURL=CommentsSidebar.js.map