Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/core/hooks/usePlugins", ['module', 'exports', 'require', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = usePlugins;

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var useCallback = _react["default"].useCallback,
        useRef = _react["default"].useRef;
    /**
     * Maintains a registry of plugins and provides methods for adding to and
     * looking things up in the registry.
     */

    function usePlugins() {
      var plugins = useRef(new Map());
      var getInstance = useCallback(function (key) {
        return plugins.current.get(key) || Promise.resolve(null);
      }, []);
      var register = useCallback(function (key, promise, init) {
        if (!plugins.current.has(key)) {
          plugins.current.set(key, promise.then(function (Plugin) {
            return new Plugin(init);
          })["catch"](function (error) {

            return null;
          }));
        }

        return plugins.current.get(key);
      }, []);
      return {
        getInstance: getInstance,
        register: register
      };
    }
    //# sourceMappingURL=usePlugins.js.map
  }
});
//# sourceMappingURL=usePlugins.js.map