Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/utils/setWidgetUsage", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.setWidgetUsage = setWidgetUsage;

    function _toArray(arr) {
      return _arrayWithHoles(arr) || _iterableToArray(arr) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */

    /**
     * Iterates the widgets array recursively to set a given widget 'used' property
     * and returns a new array with the given widget modified
     */
    function setWidgetUsage(widgets, path, usage) {
      if (!path.length) {
        var _widgets$portletItems;

        if ((_widgets$portletItems = widgets.portletItems) === null || _widgets$portletItems === void 0 ? void 0 : _widgets$portletItems.length) {
          widgets.portletItems.forEach(function (item) {
            item.used = usage.used;
          });
        }

        return _objectSpread({}, widgets, {
          used: usage.used
        });
      }

      var _path = _toArray(path),
          currentPath = _path[0],
          restPath = _path.slice(1);

      if (Array.isArray(widgets)) {
        return widgets.map(function (widget, index) {
          if (index === currentPath) {
            return setWidgetUsage(widgets[currentPath], restPath, usage);
          }

          return widget;
        });
      } else {
        return _objectSpread({}, widgets, _defineProperty({}, currentPath, setWidgetUsage(widgets[currentPath], restPath, usage)));
      }
    }
    //# sourceMappingURL=setWidgetUsage.js.map
  }
});
//# sourceMappingURL=setWidgetUsage.js.map