Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/utils/getResponsiveColumnSize", ['module', 'exports', 'require', '../config/constants/viewportSizes'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.getResponsiveColumnSize = getResponsiveColumnSize;

    var _viewportSizes = require("../config/constants/viewportSizes");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var ORDERED_VIEWPORT_SIZES = [_viewportSizes.VIEWPORT_SIZES.desktop, _viewportSizes.VIEWPORT_SIZES.tablet, _viewportSizes.VIEWPORT_SIZES.landscapeMobile, _viewportSizes.VIEWPORT_SIZES.portraitMobile];

    function getResponsiveColumnSize(config, viewportSize) {

      var newViewportSize = function getViewportSize(config, viewportSize) {
        var viewportSizePosition = ORDERED_VIEWPORT_SIZES.indexOf(viewportSize);

        if (viewportSize === _viewportSizes.VIEWPORT_SIZES.desktop || viewportSizePosition === -1) {
          return _viewportSizes.VIEWPORT_SIZES.desktop;
        }

        return config[viewportSize] && config[viewportSize].size ? viewportSize : getViewportSize(config, ORDERED_VIEWPORT_SIZES[viewportSizePosition - 1]);
      }(config, viewportSize);
      return config[newViewportSize] ? config[newViewportSize].size : config.size;
    }
    //# sourceMappingURL=getResponsiveColumnSize.js.map
  }
});
//# sourceMappingURL=getResponsiveColumnSize.js.map