Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/utils/dragAndDrop/toControlsId", ['module', 'exports', 'require', '../../components/layout-data-items/Collection', '../../config/constants/layoutDataItemTypes'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = toControlsId;

    var _Collection = require("../../components/layout-data-items/Collection");

    var _layoutDataItemTypes = require("../../config/constants/layoutDataItemTypes");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */

    /**
     * Translates the given item ID into a collectionId-itemId if the item is
     * inside a collection. Otherwise, returns the plain itemId.
     * @param {{current: object}} layoutDataRef
     * @param {object} item
     * @return {string}
     */
    function toControlsId(layoutDataRef, item) {
      var baseItem = item;

      return function computeControlsId(layoutDataRef, item) {
        var parent = layoutDataRef.current.items[item.parentId];

        if (item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collectionItem && baseItem.collectionItemIndex && parent) {
          return (0, _Collection.getToControlsId)(parent.itemId, baseItem.collectionItemIndex)(baseItem.itemId);
        } else if (parent) {
          return computeControlsId(layoutDataRef, parent);
        }

        return baseItem.itemId;
      }(layoutDataRef, item);
    }
    //# sourceMappingURL=toControlsId.js.map
  }
});
//# sourceMappingURL=toControlsId.js.map