Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/utils/dragAndDrop/defaultComputeHover", ['module', 'exports', 'require', '../../config/constants/layoutDataItemTypes', './checkAllowedChild', './constants/dragDropTargetType', './constants/targetPosition', './getTargetPosition', './itemIsAncestor', './toControlsId', './useDragAndDrop'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = defaultComputeHover;

    var _layoutDataItemTypes = require("../../config/constants/layoutDataItemTypes");

    var _checkAllowedChild = _interopRequireDefault(require("./checkAllowedChild"));

    var _dragDropTargetType = require("./constants/dragDropTargetType");

    var _targetPosition = require("./constants/targetPosition");

    var _getTargetPosition3 = _interopRequireDefault(require("./getTargetPosition"));

    var _itemIsAncestor = _interopRequireDefault(require("./itemIsAncestor"));

    var _toControlsId = _interopRequireDefault(require("./toControlsId"));

    var _useDragAndDrop = require("./useDragAndDrop");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function defaultComputeHover(_ref) {
      var dispatch = _ref.dispatch,
          layoutDataRef = _ref.layoutDataRef,
          monitor = _ref.monitor,
          _ref$siblingItem = _ref.siblingItem,
          siblingItem = _ref$siblingItem === void 0 ? null : _ref$siblingItem,
          sourceItem = _ref.sourceItem,
          targetItem = _ref.targetItem,
          targetRefs = _ref.targetRefs;

      // Not dragging over direct child
      // We do not want to alter state here,
      // as dnd generate extra hover events when
      // items are being dragged over nested children
      if (!monitor.isOver({
        shallow: true
      })) {
        return;
      } // Dragging over itself or a descendant


      if ((0, _itemIsAncestor["default"])(sourceItem, targetItem, layoutDataRef)) {
        return dispatch(_objectSpread({}, _useDragAndDrop.initialDragDrop.state, {
          type: _dragDropTargetType.DRAG_DROP_TARGET_TYPE.DRAGGING_TO_ITSELF
        }));
      } // Apparently valid drag, calculate vertical position and
      // nesting validation


      var _getItemPosition = getItemPosition(siblingItem || targetItem, monitor, layoutDataRef, targetRefs),
          _getItemPosition2 = _slicedToArray(_getItemPosition, 3),
          targetPositionWithMiddle = _getItemPosition2[0],
          targetPositionWithoutMiddle = _getItemPosition2[1],
          elevationDepth = _getItemPosition2[2]; // Drop inside target


      var validDropInsideTarget = function () {
        var _layoutDataRef$curren;

        var targetIsColumn = targetItem.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.column;
        var targetIsFragment = targetItem.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment;
        var targetIsEmpty = ((_layoutDataRef$curren = layoutDataRef.current.items[targetItem.itemId]) === null || _layoutDataRef$curren === void 0 ? void 0 : _layoutDataRef$curren.children.length) === 0;
        return targetPositionWithMiddle === _targetPosition.TARGET_POSITION.MIDDLE && (targetIsEmpty || targetIsColumn) && !targetIsFragment;
      }();

      if (!siblingItem && validDropInsideTarget) {
        return dispatch({
          dropItem: sourceItem,
          dropTargetItem: targetItem,
          droppable: (0, _checkAllowedChild["default"])(sourceItem, targetItem, layoutDataRef),
          elevate: null,
          targetPositionWithMiddle: targetPositionWithMiddle,
          targetPositionWithoutMiddle: targetPositionWithoutMiddle,
          type: _dragDropTargetType.DRAG_DROP_TARGET_TYPE.INSIDE
        });
      } // Valid elevation:
      // - dropItem should be child of dropTargetItem
      // - dropItem should be sibling of siblingItem


      if (siblingItem && (0, _checkAllowedChild["default"])(sourceItem, targetItem, layoutDataRef)) {
        return dispatch({
          dropItem: sourceItem,
          dropTargetItem: siblingItem,
          droppable: true,
          elevate: true,
          targetPositionWithMiddle: targetPositionWithMiddle,
          targetPositionWithoutMiddle: targetPositionWithoutMiddle,
          type: _dragDropTargetType.DRAG_DROP_TARGET_TYPE.ELEVATE
        });
      } // Try to elevate to some valid ancestor
      // Using dropTargetItem parent as target and dropTargetItem as sibling
      // It will try elevate multiple levels if elevationDepth is enough and
      // there are valid ancestors


      if (elevationDepth) {
        var getElevatedTargetItem = function getElevatedTargetItem(sibling, maximumDepth) {
          var parent = layoutDataRef.current.items[sibling.parentId] ? _objectSpread({}, layoutDataRef.current.items[sibling.parentId], {
            collectionItemIndex: sibling.collectionItemIndex
          }) : null;

          if (parent) {
            var _getItemPosition3 = getItemPosition(sibling, monitor, layoutDataRef, targetRefs),
                _getItemPosition4 = _slicedToArray(_getItemPosition3, 1),
                siblingPositionWithMiddle = _getItemPosition4[0];

            var _getItemPosition5 = getItemPosition(parent, monitor, layoutDataRef, targetRefs),
                _getItemPosition6 = _slicedToArray(_getItemPosition5, 1),
                parentPositionWithMiddle = _getItemPosition6[0];

            if ((siblingPositionWithMiddle === targetPositionWithMiddle || parentPositionWithMiddle === targetPositionWithMiddle) && (0, _checkAllowedChild["default"])(sourceItem, parent, layoutDataRef)) {
              if (maximumDepth > 1) {
                var _getElevatedTargetIte = getElevatedTargetItem(parent, maximumDepth - 1),
                    _getElevatedTargetIte2 = _slicedToArray(_getElevatedTargetIte, 2),
                    grandParent = _getElevatedTargetIte2[0],
                    parentSibling = _getElevatedTargetIte2[1];

                if (grandParent) {
                  return [grandParent, parentSibling];
                }
              }

              return [parent, sibling];
            } else {
              return getElevatedTargetItem(parent, maximumDepth);
            }
          }

          return [null, null];
        };

        var _getElevatedTargetIte3 = getElevatedTargetItem(targetItem, elevationDepth),
            _getElevatedTargetIte4 = _slicedToArray(_getElevatedTargetIte3, 2),
            elevatedTargetItem = _getElevatedTargetIte4[0],
            _siblingItem = _getElevatedTargetIte4[1];

        if (elevatedTargetItem && elevatedTargetItem !== targetItem) {
          return defaultComputeHover({
            dispatch: dispatch,
            layoutDataRef: layoutDataRef,
            monitor: monitor,
            siblingItem: _siblingItem,
            sourceItem: sourceItem,
            targetItem: elevatedTargetItem,
            targetRefs: targetRefs
          });
        }
      }
    }

    var ELEVATION_BORDER_SIZE = 15;
    var MAXIMUM_ELEVATION_STEPS = 3;
    /**
     * Returns the cursor vertical position (extracted from provided dnd monitor)
     * relative to the given item, taking into account configured elevation steps
     * with ELEVATION_BORDER_SIZE and MAXIMUM_ELEVATION_STEPS.
     *
     * For each elevation step, a border on the top/bottom of the element is added.
     * The first elevation step (being the nearest to the element's center)
     * elevates two its first valid ancestor, the second to the next one, and all
     * the way up until MAXIMUM_ELEVATION_STEPS has been reached or there are no
     * more valid ancestors.
     */

    function getItemPosition(item, monitor, layoutDataRef, targetRefs) {
      var targetRef = targetRefs.get((0, _toControlsId["default"])(layoutDataRef, item));

      if (!targetRef || !targetRef.current) {
        return [null, null, 0];
      }

      var clientOffsetY = monitor.getClientOffset().y;
      var hoverBoundingRect = targetRef.current.getBoundingClientRect();
      var elevationStepSize = Math.min(hoverBoundingRect.height / (2 * (MAXIMUM_ELEVATION_STEPS + 1)), ELEVATION_BORDER_SIZE);
      var totalElevationBorderSize = elevationStepSize * MAXIMUM_ELEVATION_STEPS;

      var _getTargetPosition = (0, _getTargetPosition3["default"])(clientOffsetY, hoverBoundingRect, totalElevationBorderSize),
          _getTargetPosition2 = _slicedToArray(_getTargetPosition, 2),
          targetPositionWithMiddle = _getTargetPosition2[0],
          targetPositionWithoutMiddle = _getTargetPosition2[1];

      var elevationDepth = 0;

      if (targetPositionWithMiddle !== _targetPosition.TARGET_POSITION.MIDDLE) {
        var distanceFromBorder = targetPositionWithMiddle === _targetPosition.TARGET_POSITION.TOP ? clientOffsetY - hoverBoundingRect.top : hoverBoundingRect.bottom - clientOffsetY;
        elevationDepth = MAXIMUM_ELEVATION_STEPS - Math.floor(distanceFromBorder / totalElevationBorderSize * MAXIMUM_ELEVATION_STEPS);
      }

      return [targetPositionWithMiddle, targetPositionWithoutMiddle, elevationDepth];
    }
    //# sourceMappingURL=defaultComputeHover.js.map
  }
});
//# sourceMappingURL=defaultComputeHover.js.map