Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/thunks/updateEditableValues", ['module', 'exports', 'require', '../actions/updateEditableValues', '../actions/updatePageContents', '../services/FragmentService', '../services/InfoItemService'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = updateEditableValues;

    var _updateEditableValues = _interopRequireDefault(require("../actions/updateEditableValues"));

    var _updatePageContents = _interopRequireDefault(require("../actions/updatePageContents"));

    var _FragmentService = _interopRequireDefault(require("../services/FragmentService"));

    var _InfoItemService = _interopRequireDefault(require("../services/InfoItemService"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function updateEditableValues(_ref) {
      var editableValues = _ref.editableValues,
          fragmentEntryLinkId = _ref.fragmentEntryLinkId,
          segmentsExperienceId = _ref.segmentsExperienceId;
      return function (dispatch) {
        return _FragmentService["default"].updateEditableValues({
          editableValues: editableValues,
          fragmentEntryLinkId: fragmentEntryLinkId,
          onNetworkStatus: dispatch
        }).then(function (fragmentEntryLink) {
          dispatch((0, _updateEditableValues["default"])({
            content: fragmentEntryLink.content,
            editableValues: editableValues,
            fragmentEntryLinkId: fragmentEntryLinkId,
            segmentsExperienceId: segmentsExperienceId
          }));
        }).then(function () {
          _InfoItemService["default"].getPageContents({
            onNetworkStatus: dispatch
          }).then(function (pageContents) {
            dispatch((0, _updatePageContents["default"])({
              pageContents: pageContents
            }));
          });
        });
      };
    }
    //# sourceMappingURL=updateEditableValues.js.map
  }
});
//# sourceMappingURL=updateEditableValues.js.map