Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/services/CollectionService", ['module', 'exports', 'require', '../config/index', './serviceFetch'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _index = require("../config/index");

    var _serviceFetch = _interopRequireDefault(require("./serviceFetch"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var _default = {
      /**
       * Get an asset's value
       * @param {object} options
       * @param {string} options.listItemStyle
       * @param {string} options.listStyle
       * @param {function} options.onNetworkStatus
       */
      getCollectionField: function getCollectionField(_ref) {
        var collection = _ref.collection,
            languageId = _ref.languageId,
            listItemStyle = _ref.listItemStyle,
            listStyle = _ref.listStyle,
            onNetworkStatus = _ref.onNetworkStatus,
            segmentsExperienceId = _ref.segmentsExperienceId,
            size = _ref.size,
            templateKey = _ref.templateKey;
        return (0, _serviceFetch["default"])(_index.config.getCollectionFieldURL, {
          body: {
            languageId: languageId,
            layoutObjectReference: JSON.stringify(collection),
            listItemStyle: listItemStyle,
            listStyle: listStyle,
            segmentsExperienceId: segmentsExperienceId,
            size: size,
            templateKey: templateKey
          }
        }, onNetworkStatus);
      },

      /**
       * Get available collection mapping fields
       * @param {object} options
       * @param {string} options.fieldType Type of field to which we are mapping
       * @param {string} options.itemSubtype Collection itemSubtype
       * @param {string} options.itemType Collection itemType
       * @param {function} options.onNetworkStatus
       */
      getCollectionMappingFields: function getCollectionMappingFields(_ref2) {
        var fieldType = _ref2.fieldType,
            itemSubtype = _ref2.itemSubtype,
            itemType = _ref2.itemType,
            onNetworkStatus = _ref2.onNetworkStatus;
        return (0, _serviceFetch["default"])(_index.config.getCollectionMappingFieldsURL, {
          body: {
            fieldType: fieldType,
            itemSubtype: itemSubtype,
            itemType: itemType
          }
        }, onNetworkStatus);
      }
    };
    exports["default"] = _default;
    //# sourceMappingURL=CollectionService.js.map
  }
});
//# sourceMappingURL=CollectionService.js.map