Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/reducers/undoReducer", ['module', 'exports', 'require', '../../plugins/experience/actions', '../actions/types', '../components/undo/undoActions'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = undoReducer;

    var _actions = require("../../plugins/experience/actions");

    var _types = require("../actions/types");

    var _undoActions = require("../components/undo/undoActions");

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var MAX_UNDO_ACTIONS = 100;
    var actionId = 0;

    function undoReducer(state, action) {
      switch (action.type) {
        case _types.ADD_REDO_ACTION:
          {
            var actionType = action.actionType,
                originalType = action.originalType;
            var nextRedoHistory = state.redoHistory || [];
            return _objectSpread({}, state, {
              redoHistory: [_objectSpread({}, (0, _undoActions.getDerivedStateForUndo)({
                action: action,
                state: state,
                type: actionType
              }), {
                actionId: actionId++,
                originalType: originalType
              })].concat(_toConsumableArray(nextRedoHistory))
            });
          }

        case _types.ADD_UNDO_ACTION:
          {
            var _actionType = action.actionType,
                _originalType = action.originalType;
            var nextUndoHistory = state.undoHistory || [];

            var _nextRedoHistory = action.isRedo ? state.redoHistory : [];

            return _objectSpread({}, state, {
              redoHistory: _nextRedoHistory,
              undoHistory: [_objectSpread({}, (0, _undoActions.getDerivedStateForUndo)({
                action: action,
                state: state,
                type: _actionType
              }), {
                actionId: actionId++,
                originalType: _originalType
              })].concat(_toConsumableArray(nextUndoHistory.slice(0, MAX_UNDO_ACTIONS - 1)))
            });
          }

        case _actions.DELETE_SEGMENTS_EXPERIENCE:
          {
            var segmentsExperienceId = action.payload.segmentsExperienceId;

            var _nextUndoHistory = state.undoHistory || [];

            var _nextRedoHistory2 = state.redoHistory || [];

            return _objectSpread({}, state, {
              redoHistory: _nextRedoHistory2.filter(function (action) {
                return action.segmentsExperienceId !== segmentsExperienceId && action.nextSegmentsExperienceId !== segmentsExperienceId;
              }),
              undoHistory: _nextUndoHistory.filter(function (action) {
                return action.segmentsExperienceId !== segmentsExperienceId && action.nextSegmentsExperienceId !== segmentsExperienceId;
              })
            });
          }

        case _types.UPDATE_REDO_ACTIONS:
          {
            return _objectSpread({}, state, {
              redoHistory: action.redoHistory
            });
          }

        case 'UPDATE_STORE':
          {
            return _objectSpread({}, action.store);
          }

        case _types.UPDATE_UNDO_ACTIONS:
          {
            return _objectSpread({}, state, {
              undoHistory: action.undoHistory
            });
          }

        default:
          return state;
      }
    }
    //# sourceMappingURL=undoReducer.js.map
  }
});
//# sourceMappingURL=undoReducer.js.map