Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/reducers/editablesReducer", ['module', 'exports', 'require', '../actions/types'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = editablesReducer;

    var _types = require("../actions/types");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function editablesReducer() {
      var editables = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var action = arguments.length > 1 ? arguments[1] : undefined;

      switch (action.type) {
        case _types.SET_FRAGMENT_EDITABLES:
          {
            var editablesMap = {};
            action.editables.forEach(function (editable) {
              var editableUniqueId = "".concat(action.fragmentEntryLinkId, "-").concat(editable.editableId);
              editablesMap[editableUniqueId] = _objectSpread({}, editable, {
                fragmentEntryLinkId: action.fragmentEntryLinkId,
                itemId: editableUniqueId,
                parentId: action.itemId
              });
            });
            return _objectSpread({}, editables, _defineProperty({}, action.itemId, editablesMap));
          }

        case _types.UPDATE_LAYOUT_DATA:
          {
            var nextEditables = editables;
            action.deletedFragmentEntryLinkIds.forEach(function (fragmentEntryLinkId) {
              nextEditables = _objectSpread({}, nextEditables);
              delete nextEditables[fragmentEntryLinkId];
            });
            return nextEditables;
          }

        default:
          return editables;
      }
    }
    //# sourceMappingURL=editablesReducer.js.map
  }
});
//# sourceMappingURL=editablesReducer.js.map