Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/config/index", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.initializeConfig = initializeConfig;
    exports.config = void 0;

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var DEFAULT_CONFIG = {
      toolbarId: 'pageEditorToolbar'
    };
    /** @type {import('../../types/config').Config} */

    var config = DEFAULT_CONFIG;
    /**
     * Extracts the immutable parts from the server data.
     *
     * Unlike data in the store, this config does not change over the lifetime of
     * the app, so we can safely store is as a variable.
     */

    exports.config = config;

    function initializeConfig(backendConfig) {
      var pluginsRootPath = backendConfig.pluginsRootPath,
          portletNamespace = backendConfig.portletNamespace,
          sidebarPanels = backendConfig.sidebarPanels;
      var toolbarId = "".concat(portletNamespace).concat(DEFAULT_CONFIG.toolbarId); // Special items requiring augmentation, creation, or transformation.

      var augmentedPanels = augmentPanelData(pluginsRootPath, sidebarPanels);
      var syntheticItems = {
        marginOptions: _toConsumableArray(backendConfig.paddingOptions),
        panels: generatePanels(augmentedPanels),
        sidebarPanels: partitionPanels(augmentedPanels),
        toolbarId: toolbarId,
        toolbarPlugins: getToolbarPlugins(pluginsRootPath, toolbarId)
      };
      exports.config = config = _objectSpread({}, DEFAULT_CONFIG, {}, backendConfig, {}, syntheticItems);
      return config;
    }
    /**
     * In general, we expect the sidebarPanelId to correspond with the name
     * of a plugin. Here we deal with the exceptions by mapping IDs to
     * plugin names.
     */

    var SIDEBAR_PANEL_IDS_TO_PLUGINS = {};

    function augmentPanelData(pluginsRootPath, sidebarPanels) {
      return sidebarPanels.map(function (panel) {
        if (isSeparator(panel) || panel.isLink) {
          return panel;
        }

        var mapping = SIDEBAR_PANEL_IDS_TO_PLUGINS[panel.sidebarPanelId];
        var sidebarPanelId = mapping || panel.sidebarPanelId;
        return _objectSpread({}, panel, {
          // https://github.com/liferay/liferay-js-toolkit/issues/324
          pluginEntryPoint: "".concat(pluginsRootPath, "/").concat(sidebarPanelId, "/index"),
          sidebarPanelId: sidebarPanelId
        });
      });
    }

    function generatePanels(sidebarPanels) {
      return sidebarPanels.reduce(function (groups, panel) {
        if (isSeparator(panel)) {
          groups.push([]);
        } else {
          groups[groups.length - 1].push(panel.sidebarPanelId);
        }

        return groups;
      }, [[]]);
    }
    /**
     * Currently we have segments experience data sprinkled throughout the
     * server data. In the future we may choose to encapsulate it better and
     * deal with it inside the plugin.
     */

    function getToolbarPlugins(pluginsRootPath, toolbarId) {
      var selectId = "".concat(toolbarId, "_").concat('experience');
      return [{
        loadingPlaceholder: "\n\t\t\t\t<div class=\"align-items-center d-flex mr-2\">\n\t\t\t\t\t<label class=\"mr-2\" for=\"".concat(selectId, "\">\n\t\t\t\t\t\tExperience\n\t\t\t\t\t</label>\n\t\t\t\t\t<select class=\"form-control\" disabled id=\"").concat(selectId, "\">\n\t\t\t\t\t\t<option value=\"1\">Default</option>\n\t\t\t\t\t</select>\n\t\t\t\t</div>\n\t\t\t"),
        pluginEntryPoint: "".concat(pluginsRootPath, "/experience/index"),
        toolbarPluginId: 'experience'
      }];
    }

    function isSeparator(panel) {
      return panel.sidebarPanelId === 'separator';
    }
    /**
     * Instead of using fake panels with an ID of `separator`, partition the panels
     * array into an array of arrays; we'll draw a separator between each group.
     */

    function partitionPanels(panels) {
      return panels.reduce(function (map, panel) {
        var sidebarPanelId = panel.sidebarPanelId;

        if (!isSeparator(panel)) {
          map[sidebarPanelId] = panel;
        }

        return map;
      }, {});
    }
    //# sourceMappingURL=index.js.map
  }
});
//# sourceMappingURL=index.js.map