Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/components/undo/getActionLabel", ['module', 'exports', 'require', '../../../plugins/experience/actions', '../../actions/types', '../../config/constants/undoTypes', '../../config/index', '../../utils/getSegmentsExperienceName'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = getActionLabel;

    var _actions = require("../../../plugins/experience/actions");

    var _types = require("../../actions/types");

    var _undoTypes = require("../../config/constants/undoTypes");

    var _index = require("../../config/index");

    var _getSegmentsExperienceName = _interopRequireDefault(require("../../utils/getSegmentsExperienceName"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function getActionLabel(action, type, _ref) {
      var availableSegmentsExperiences = _ref.availableSegmentsExperiences;

      switch (action.originalType || action.type) {
        case _types.ADD_FRAGMENT_ENTRY_LINKS:
        case _types.ADD_ITEM:
          return Liferay.Util.sub(Liferay.Language.get('add-x'), action.itemName);

        case _types.CHANGE_MASTER_LAYOUT:
          return type === _undoTypes.UNDO_TYPES.undo ? Liferay.Util.sub(Liferay.Language.get('select-x-master-layout'), _index.config.masterLayouts.find(function (masterLayout) {
            return masterLayout.masterLayoutPlid === action.nextMasterLayoutPlid;
          }).name) : Liferay.Util.sub(Liferay.Language.get('select-x-master-layout'), _index.config.masterLayouts.find(function (masterLayout) {
            return masterLayout.masterLayoutPlid === action.masterLayoutPlid;
          }).name);

        case _types.DELETE_ITEM:
          return Liferay.Util.sub(Liferay.Language.get('delete-x'), action.itemName);

        case _types.DUPLICATE_ITEM:
          return Liferay.Util.sub(Liferay.Language.get('duplicate-x'), action.itemName);

        case _types.MOVE_ITEM:
          return Liferay.Util.sub(Liferay.Language.get('move-x'), action.itemName);

        case _actions.SELECT_SEGMENTS_EXPERIENCE:
          return type === _undoTypes.UNDO_TYPES.undo ? Liferay.Util.sub(Liferay.Language.get('select-x-experience'), (0, _getSegmentsExperienceName["default"])(action.nextSegmentsExperienceId, availableSegmentsExperiences)) : Liferay.Util.sub(Liferay.Language.get('select-x-experience'), (0, _getSegmentsExperienceName["default"])(action.segmentsExperienceId, availableSegmentsExperiences));

        case _types.SWITCH_VIEWPORT_SIZE:
          return type === _undoTypes.UNDO_TYPES.undo ? Liferay.Util.sub(Liferay.Language.get('select-x-viewport'), _index.config.availableViewportSizes[action.nextSize].label) : Liferay.Util.sub(Liferay.Language.get('select-x-viewport'), _index.config.availableViewportSizes[action.size].label);

        case _types.UPDATE_COL_SIZE:
          return Liferay.Language.get('update-column-size');

        case _types.UPDATE_FRAGMENT_ENTRY_LINK_CONFIGURATION:
        case _types.UPDATE_ITEM_CONFIG:
        case _types.UPDATE_ROW_COLUMNS:
          return Liferay.Util.sub(Liferay.Language.get('update-x-configuration'), action.itemName);

        case _types.UPDATE_EDITABLE_VALUES:
          return Liferay.Util.sub(Liferay.Language.get('update-x-editable-values'), action.itemName);

        case _types.UPDATE_LANGUAGE_ID:
          return type === _undoTypes.UNDO_TYPES.undo ? Liferay.Util.sub(Liferay.Language.get('select-x-language'), action.nextLanguageId) : Liferay.Util.sub(Liferay.Language.get('select-x-language'), action.languageId);

        default:
      }
    }
    //# sourceMappingURL=getActionLabel.js.map
  }
});
//# sourceMappingURL=getActionLabel.js.map