Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/components/fragment-content/getAllEditables", ['module', 'exports', 'require', '../../config/constants/backgroundImageFragmentEntryProcessor', '../../config/constants/editableFragmentEntryProcessor', '../../processors/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = getAllEditables;

    var _backgroundImageFragmentEntryProcessor = require("../../config/constants/backgroundImageFragmentEntryProcessor");

    var _editableFragmentEntryProcessor = require("../../config/constants/editableFragmentEntryProcessor");

    var _index = _interopRequireDefault(require("../../processors/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    /**
     * @param {HTMLElement} fragmentElement
     * @return {Array<{editableId: string, editableValueNamespace: string, element: HTMLElement, processor: object }>}
     */
    function getAllEditables(fragmentElement) {
      var cleanedFragmentElement = fragmentElement.cloneNode(true);
      Array.from(cleanedFragmentElement.querySelectorAll('lfr-drop-zone')).forEach(function (dropZoneElement) {
        dropZoneElement.parentElement.removeChild(dropZoneElement);
      });
      return [].concat(_toConsumableArray(Array.from(cleanedFragmentElement.querySelectorAll('lfr-editable')).map(function (editableElement) {
        var editableId = editableElement.getAttribute('id');
        var type = editableElement.getAttribute('type');
        return {
          editableId: editableId,
          editableValueNamespace: _editableFragmentEntryProcessor.EDITABLE_FRAGMENT_ENTRY_PROCESSOR,
          element: fragmentElement.querySelector("lfr-editable[id=\"".concat(editableId, "\"]")),
          processor: _index["default"][type] || _index["default"].fallback,
          type: type
        };
      })), _toConsumableArray(Array.from(cleanedFragmentElement.querySelectorAll('[data-lfr-editable-id]')).map(function (editableElement) {
        var editableId = editableElement.dataset.lfrEditableId;
        var type = editableElement.dataset.lfrEditableType;
        return {
          editableId: editableId,
          editableValueNamespace: _editableFragmentEntryProcessor.EDITABLE_FRAGMENT_ENTRY_PROCESSOR,
          element: fragmentElement.querySelector("[data-lfr-editable-id=\"".concat(editableId, "\"]")),
          processor: _index["default"][type] || _index["default"].fallback,
          type: type
        };
      })), _toConsumableArray(Array.from(cleanedFragmentElement.querySelectorAll('[data-lfr-background-image-id]')).map(function (editableElement) {
        var editableId = editableElement.dataset.lfrBackgroundImageId;
        return {
          editableId: editableId,
          editableValueNamespace: _backgroundImageFragmentEntryProcessor.BACKGROUND_IMAGE_FRAGMENT_ENTRY_PROCESSOR,
          element: fragmentElement.querySelector("[data-lfr-background-image-id=\"".concat(editableId, "\"]")),
          processor: _index["default"]['background-image'],
          type: 'background-image'
        };
      })));
    }
    //# sourceMappingURL=getAllEditables.js.map
  }
});
//# sourceMappingURL=getAllEditables.js.map