Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/components/fragment-content/FragmentContentInteractionsFilter", ['module', 'exports', 'require', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../config/constants/editableFragmentEntryProcessor', '../../config/constants/itemActivationOrigins', '../../config/constants/itemTypes', '../../config/index', '../../selectors/selectCanUpdateEditables', '../../selectors/selectCanUpdatePageStructure', '../../store/index', '../../utils/checkDeepEqual', '../../utils/isMapped', '../CollectionItemContext', '../Controls', './EditableProcessorContext', './getEditableElement'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _editableFragmentEntryProcessor = require("../../config/constants/editableFragmentEntryProcessor");

    var _itemActivationOrigins = require("../../config/constants/itemActivationOrigins");

    var _itemTypes = require("../../config/constants/itemTypes");

    var _index = require("../../config/index");

    var _selectCanUpdateEditables = _interopRequireDefault(require("../../selectors/selectCanUpdateEditables"));

    var _selectCanUpdatePageStructure = _interopRequireDefault(require("../../selectors/selectCanUpdatePageStructure"));

    var _index2 = require("../../store/index");

    var _checkDeepEqual = require("../../utils/checkDeepEqual");

    var _isMapped = _interopRequireDefault(require("../../utils/isMapped"));

    var _CollectionItemContext = require("../CollectionItemContext");

    var _Controls = require("../Controls");

    var _EditableProcessorContext = require("./EditableProcessorContext");

    var _getEditableElement = require("./getEditableElement");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    var EDITABLE_CLASS_NAMES = {
      active: 'page-editor__editable--active',
      hovered: 'page-editor__editable--hovered',
      mapped: 'page-editor__editable--mapped',
      translated: 'page-editor__editable--translated'
    };

    var isTranslated = function isTranslated(defaultLanguageId, languageId, editableValue) {
      return defaultLanguageId !== languageId && (editableValue === null || editableValue === void 0 ? void 0 : editableValue[languageId]);
    };

    function FragmentContentInteractionsFilter(_ref) {
      var children = _ref.children,
          fragmentEntryLinkId = _ref.fragmentEntryLinkId,
          itemId = _ref.itemId;
      var activationOrigin = (0, _Controls.useActivationOrigin)();
      var activeItemType = (0, _Controls.useActiveItemType)();
      var canUpdateEditables = (0, _index2.useSelector)(_selectCanUpdateEditables["default"]);
      var canUpdatePageStructure = (0, _index2.useSelector)(_selectCanUpdatePageStructure["default"]);
      var hoverItem = (0, _Controls.useHoverItem)();
      var hoveredItemId = (0, _Controls.useHoveredItemId)();
      var hoveredItemType = (0, _Controls.useHoveredItemType)();
      var isActive = (0, _Controls.useIsActive)();
      var isHovered = (0, _Controls.useIsHovered)();
      var languageId = (0, _index2.useSelector)(function (state) {
        return state.languageId;
      });
      var selectItem = (0, _Controls.useSelectItem)();
      var setEditableProcessorUniqueId = (0, _EditableProcessorContext.useSetEditableProcessorUniqueId)();
      var toControlsId = (0, _CollectionItemContext.useToControlsId)();
      var editables = (0, _index2.useSelectorCallback)(function (state) {
        var _state$editables;

        return Object.values(((_state$editables = state.editables) === null || _state$editables === void 0 ? void 0 : _state$editables[toControlsId(itemId)]) || {});
      }, [itemId, toControlsId]);
      var editableValues = (0, _index2.useSelectorCallback)(function (state) {
        return state.fragmentEntryLinks[fragmentEntryLinkId] ? state.fragmentEntryLinks[fragmentEntryLinkId].editableValues[_editableFragmentEntryProcessor.EDITABLE_FRAGMENT_ENTRY_PROCESSOR] : {};
      }, [fragmentEntryLinkId], _checkDeepEqual.deepEqual);
      var siblingIds = (0, _react.useMemo)(function () {
        return [itemId].concat(_toConsumableArray(editables.map(function (editable) {
          return editable.itemId;
        })));
      }, [itemId, editables]);
      (0, _react.useEffect)(function () {
        editables.forEach(function (editable) {
          if (editableValues) {
            var editableValue = editableValues[editable.editableId];
            var element = editable.element;

            if ((0, _isMapped["default"])(editableValue)) {
              element.classList.add(EDITABLE_CLASS_NAMES.mapped);
            } else if (isTranslated(_index.config.defaultLanguageId, languageId, editableValue)) {
              element.classList.add(EDITABLE_CLASS_NAMES.translated);
            } else {
              element.classList.remove(EDITABLE_CLASS_NAMES.mapped);
              element.classList.remove(EDITABLE_CLASS_NAMES.translated);
            }
          }
        });
      }, [editables, editableValues, languageId]);
      (0, _react.useEffect)(function () {
        editables.forEach(function (editable) {
          if (isActive(editable.itemId)) {
            editable.element.classList.add(EDITABLE_CLASS_NAMES.active);
          } else {
            editable.element.classList.remove(EDITABLE_CLASS_NAMES.active);
          }
        });
      }, [editables, isActive]);
      (0, _react.useEffect)(function () {
        editables.forEach(function (editable) {
          if (editableValues) {
            var editableValue = editableValues[editable.editableId] || {};
            var hovered = hoveredItemType === _itemTypes.ITEM_TYPES.mappedContent && "".concat(editableValue.classNameId, "-").concat(editableValue.classPK) === hoveredItemId || (siblingIds.some(isActive) || !canUpdatePageStructure) && isHovered(editable.itemId);

            if (hovered) {
              editable.element.classList.add(EDITABLE_CLASS_NAMES.hovered);
            } else {
              editable.element.classList.remove(EDITABLE_CLASS_NAMES.hovered);
            }
          }
        });
      }, [canUpdatePageStructure, editables, editableValues, fragmentEntryLinkId, hoveredItemId, hoveredItemType, isActive, isHovered, itemId, siblingIds]);
      (0, _react.useEffect)(function () {
        var activeEditable;

        var enableProcessor = function enableProcessor(event) {
          var editableElement = (0, _getEditableElement.getEditableElement)(event.target);
          var editable = editables.find(function (editable) {
            return editable.element === editableElement;
          });

          if (editable) {
            var editableValue = editableValues[editable.editableId] || {};

            if ((0, _isMapped["default"])(editableValue)) {
              return;
            }

            var editableClickPosition = {
              clientX: event.clientX,
              clientY: event.clientY
            };

            if (isActive(editable.itemId)) {
              setEditableProcessorUniqueId(editable.itemId, editableClickPosition);
            }
          }
        };

        if (activeItemType === _itemTypes.ITEM_TYPES.editable) {
          activeEditable = editables.find(function (editable) {
            return isActive(editable.itemId);
          });

          if (activeEditable) {
            if (canUpdateEditables) {
              requestAnimationFrame(function () {
                activeEditable.element.addEventListener('dblclick', enableProcessor);
              });
            }

            if (activationOrigin === _itemActivationOrigins.ITEM_ACTIVATION_ORIGINS.structureTree) {
              activeEditable.element.scrollIntoView({
                behavior: 'smooth',
                block: 'center',
                inline: 'nearest'
              });
            }
          }
        }

        return function () {
          if (activeEditable) {
            activeEditable.element.removeEventListener('dblclick', enableProcessor);
          }
        };
      }, [activationOrigin, activeItemType, canUpdateEditables, editables, editableValues, fragmentEntryLinkId, isActive, itemId, setEditableProcessorUniqueId]);

      var hoverEditable = function hoverEditable(event) {
        var editableElement = (0, _getEditableElement.getEditableElement)(event.target);
        var editable = editables.find(function (editable) {
          return editable.element === editableElement;
        });

        if (editable) {
          event.stopPropagation();
          hoverItem(editable.itemId, {
            itemType: _itemTypes.ITEM_TYPES.editable
          });
        }
      };

      var selectEditable = function selectEditable(event) {
        var editableElement = (0, _getEditableElement.getEditableElement)(event.target);
        var editable = editables.find(function (editable) {
          return editable.element === editableElement;
        });

        if (editable) {
          event.stopPropagation();

          if (isActive(editable.itemId)) {
            event.stopPropagation();
          } else {
            selectItem(editable.itemId, {
              itemType: _itemTypes.ITEM_TYPES.editable
            });
          }
        }
      };

      var props = {};

      if (canUpdateEditables && (siblingIds.some(isActive) || !canUpdatePageStructure)) {
        props.onClickCapture = selectEditable;

        props.onMouseLeave = function () {
          return hoverItem(null);
        };

        props.onMouseOverCapture = hoverEditable;
      }

      return _react["default"].createElement("div", props, children);
    }

    var _default = _react["default"].memo(FragmentContentInteractionsFilter);

    exports["default"] = _default;
    //# sourceMappingURL=FragmentContentInteractionsFilter.js.map
  }
});
//# sourceMappingURL=FragmentContentInteractionsFilter.js.map