Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/components/NetworkStatusBar", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/loading-indicator', 'frontend-js-react-web', 'frontend-js-web', 'frontend-js-react-web$react', '../config/constants/serviceNetworkStatusTypes'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _loadingIndicator = _interopRequireDefault(require("@frontend-taglib-clay$clayui/loading-indicator"));

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _frontendJsWeb = require("frontend-js-web");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _serviceNetworkStatusTypes = require("../config/constants/serviceNetworkStatusTypes");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var LoadingText = function LoadingText(_ref) {
      var children = _ref.children;
      return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement("span", {
        className: "m-0 navbar-text page-editor__status-bar text-info"
      }, children), _react["default"].createElement(_loadingIndicator["default"], {
        className: 'mr-3 my-0',
        small: true
      }));
    };

    var SuccessText = function SuccessText(_ref2) {
      var children = _ref2.children;
      return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement("span", {
        className: "m-0 navbar-text page-editor__status-bar text-success"
      }, children), _react["default"].createElement(_icon["default"], {
        className: 'mr-3 text-success',
        symbol: 'check-circle'
      }));
    };

    var getContent = function getContent(isOnline, status) {
      if (!isOnline) {
        return _react["default"].createElement(LoadingText, null, Liferay.Language.get('trying-to-reconnect'));
      }

      if (status === _serviceNetworkStatusTypes.SERVICE_NETWORK_STATUS_TYPES.draftSaved) {
        return _react["default"].createElement(SuccessText, null, Liferay.Language.get('saved'));
      }

      if (status === _serviceNetworkStatusTypes.SERVICE_NETWORK_STATUS_TYPES.savingDraft) {
        return _react["default"].createElement(LoadingText, null, Liferay.Language.get('saving'));
      }

      return null;
    };

    var NetworkStatusBar = function NetworkStatusBar(_ref3) {
      var error = _ref3.error,
          status = _ref3.status;

      var _useState = (0, _react.useState)(true),
          _useState2 = _slicedToArray(_useState, 2),
          isOnline = _useState2[0],
          setIsOnline = _useState2[1];

      (0, _react.useEffect)(function () {
        if (status === _serviceNetworkStatusTypes.SERVICE_NETWORK_STATUS_TYPES.error) {
          (0, _frontendJsWeb.openToast)({
            message: error,
            type: 'danger'
          });
        }
      }, [error, status]);
      (0, _frontendJsReactWeb.useEventListener)('online', function () {
        return setIsOnline(true);
      }, true, window);
      (0, _frontendJsReactWeb.useEventListener)('offline', function () {
        return setIsOnline(false);
      }, true, window);
      var content = getContent(isOnline, status);
      return _react["default"].createElement("li", {
        className: "d-flex flex-direction-row nav-item text-truncate"
      }, content);
    };

    var _default = NetworkStatusBar;
    exports["default"] = _default;
    //# sourceMappingURL=NetworkStatusBar.js.map
  }
});
//# sourceMappingURL=NetworkStatusBar.js.map