Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/components/DisabledArea", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/popover', 'frontend-js-react-web', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-position', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dom', '../store/index', './Controls', './GlobalContext'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _popover = _interopRequireDefault(require("@frontend-taglib-clay$clayui/popover"));

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _metalDom = require("frontend-js-metal-web$metal-dom");

    var _metalPosition = require("frontend-js-metal-web$metal-position");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactDom = require("frontend-js-react-web$react-dom");

    var _index = require("../store/index");

    var _Controls = require("./Controls");

    var _GlobalContext = require("./GlobalContext");

    var _POPOVER_POSITIONS;

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var DEFAULT_DISABLED_AREA_CLASS = 'page-editor__disabled-area';
    var DEFAULT_ORIGIN = '#content';
    var DEFAULT_WHITELIST = [DEFAULT_ORIGIN, ".".concat(DEFAULT_DISABLED_AREA_CLASS), '.control-menu', '.lfr-add-panel', '.lfr-product-menu-panel'];
    var POPOVER_POSITIONS = (_POPOVER_POSITIONS = {}, _defineProperty(_POPOVER_POSITIONS, _metalPosition.Align.Bottom, 'bottom'), _defineProperty(_POPOVER_POSITIONS, _metalPosition.Align.BottomLeft, 'bottom'), _defineProperty(_POPOVER_POSITIONS, _metalPosition.Align.BottomRight, 'bottom'), _defineProperty(_POPOVER_POSITIONS, _metalPosition.Align.Left, 'left'), _defineProperty(_POPOVER_POSITIONS, _metalPosition.Align.Right, 'right'), _defineProperty(_POPOVER_POSITIONS, _metalPosition.Align.Top, 'top'), _defineProperty(_POPOVER_POSITIONS, _metalPosition.Align.TopLeft, 'top'), _defineProperty(_POPOVER_POSITIONS, _metalPosition.Align.TopRight, 'top'), _POPOVER_POSITIONS);
    var STATIC_POSITIONS = ['', 'static', 'relative'];

    var DisabledArea = function DisabledArea() {
      var popoverRef = (0, _react.useRef)(null);

      var _useState = (0, _react.useState)(null),
          _useState2 = _slicedToArray(_useState, 2),
          currentElementClicked = _useState2[0],
          setCurrentElementClicked = _useState2[1];

      var globalContext = (0, _GlobalContext.useGlobalContext)();

      var _useState3 = (0, _react.useState)(false),
          _useState4 = _slicedToArray(_useState3, 2),
          show = _useState4[0],
          setShow = _useState4[1];

      var _useState5 = (0, _react.useState)('bottom'),
          _useState6 = _slicedToArray(_useState5, 2),
          position = _useState6[0],
          setPosition = _useState6[1];

      var sidebarOpen = (0, _index.useSelector)(function (state) {
        return state.sidebar.open;
      });
      var selectItem = (0, _Controls.useSelectItem)();
      var isDisabled = (0, _react.useCallback)(function (element) {
        var _element$getBoundingC = element.getBoundingClientRect(),
            height = _element$getBoundingC.height;

        var _globalContext$window = globalContext.window.getComputedStyle(element),
            position = _globalContext$window.position;

        var hasAbsolutePosition = STATIC_POSITIONS.indexOf(position) === -1;

        return element.tagName !== 'SCRIPT' && !(height === 0) && !hasAbsolutePosition && !DEFAULT_WHITELIST.some(function (selector) {
          return (0, _metalDom.match)(element, selector) || element.querySelector(selector);
        });
      }, [globalContext]);
      (0, _react.useEffect)(function () {
        var element = globalContext.document.querySelector(".".concat(DEFAULT_DISABLED_AREA_CLASS));

        if (element) {
          if (sidebarOpen) {
            element.classList.add('collapsed');
          } else {
            element.classList.remove('collapsed');
          }
        }
      }, [globalContext, sidebarOpen]);
      (0, _frontendJsReactWeb.useEventListener)('scroll', function () {
        if (show) {
          setCurrentElementClicked(null);
          setShow(false);
        }
      }, true, globalContext.document);
      (0, _frontendJsReactWeb.useEventListener)('click', function (event) {
        if (Array.from(event.target.classList).includes(DEFAULT_DISABLED_AREA_CLASS)) {
          setCurrentElementClicked(event.target);
          selectItem(null);
          setShow(true);
        } else if (show) {
          setCurrentElementClicked(null);
          setShow(false);
        }
      }, true, globalContext.document.body);
      (0, _react.useLayoutEffect)(function () {
        if (popoverRef.current && currentElementClicked && show) {
          var suggestedAlign = _metalPosition.Align.suggestAlignBestRegion(popoverRef.current, currentElementClicked, _metalPosition.Align.TopCenter);

          var bestPosition = suggestedAlign.position !== _metalPosition.Align.TopCenter ? _metalPosition.Align.BottomCenter : _metalPosition.Align.TopCenter;

          _metalPosition.Align.align(popoverRef.current, currentElementClicked, bestPosition, false);

          setPosition(POPOVER_POSITIONS[bestPosition]);
        }
      }, [show, popoverRef, currentElementClicked]);
      (0, _react.useLayoutEffect)(function () {
        var element = globalContext.document.querySelector(DEFAULT_ORIGIN);

        while (element && element.parentElement && element !== globalContext.document.body) {
          Array.from(element.parentElement.children).forEach(function (child) {
            return isDisabled(child) && child.classList.add(DEFAULT_DISABLED_AREA_CLASS);
          });
          element = element.parentElement;
        }

        return function () {
          var elements = globalContext.document.querySelectorAll(".".concat(DEFAULT_DISABLED_AREA_CLASS));
          elements.forEach(function (element) {
            return element.classList.remove(DEFAULT_DISABLED_AREA_CLASS);
          });
        };
      }, [globalContext, isDisabled]);
      return show && (0, _reactDom.createPortal)(_react["default"].createElement(_popover["default"], {
        alignPosition: position,
        ref: popoverRef,
        show: true
      }, _react["default"].createElement("div", {
        dangerouslySetInnerHTML: {
          __html: Liferay.Util.sub(Liferay.Language.get('this-area-is-defined-by-the-theme.-you-can-change-the-theme-settings-by-clicking-x-in-the-x-panel-on-the-sidebar'), ["<strong>".concat(Liferay.Language.get('more'), "</strong>"), "<strong>".concat(Liferay.Language.get('page-design-options'), "</strong>")])
        }
      })), globalContext.document.body);
    };

    var _default = DisabledArea;
    exports["default"] = _default;
    //# sourceMappingURL=DisabledArea.js.map
  }
});
//# sourceMappingURL=DisabledArea.js.map