"use strict";

Liferay.Loader.define("layout-content-page-editor-web$dnd-core@11.1.3/dist/cjs/HandlerRegistryImpl", ['module', 'exports', 'require', '@layout-content-page-editor-web$react-dnd/invariant', './actions/registry', './utils/getNextUniqueId', './interfaces', './contracts', '@layout-content-page-editor-web$react-dnd/asap'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.HandlerRegistryImpl = void 0;

    var _invariant = require("@layout-content-page-editor-web$react-dnd/invariant");

    var _registry = require("./actions/registry");

    var _getNextUniqueId = require("./utils/getNextUniqueId");

    var _interfaces = require("./interfaces");

    var _contracts = require("./contracts");

    var _asap = require("@layout-content-page-editor-web$react-dnd/asap");

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }

    function _unsupportedIterableToArray(o, minLen) {
      if (!o) return;if (typeof o === "string") return _arrayLikeToArray(o, minLen);var n = Object.prototype.toString.call(o).slice(8, -1);if (n === "Object" && o.constructor) n = o.constructor.name;if (n === "Map" || n === "Set") return Array.from(o);if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
    }

    function _arrayLikeToArray(arr, len) {
      if (len == null || len > arr.length) len = arr.length;for (var i = 0, arr2 = new Array(len); i < len; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }

    function _iterableToArrayLimit(arr, i) {
      if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return;var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function getNextHandlerId(role) {
      var id = (0, _getNextUniqueId.getNextUniqueId)().toString();

      switch (role) {
        case _interfaces.HandlerRole.SOURCE:
          return "S".concat(id);

        case _interfaces.HandlerRole.TARGET:
          return "T".concat(id);

        default:
          throw new Error("Unknown Handler Role: ".concat(role));
      }
    }

    function parseRoleFromHandlerId(handlerId) {
      switch (handlerId[0]) {
        case 'S':
          return _interfaces.HandlerRole.SOURCE;

        case 'T':
          return _interfaces.HandlerRole.TARGET;

        default:
          (0, _invariant.invariant)(false, "Cannot parse handler ID: ".concat(handlerId));
      }
    }

    function mapContainsValue(map, searchValue) {
      var entries = map.entries();
      var isDone = false;

      do {
        var _entries$next = entries.next(),
            done = _entries$next.done,
            _entries$next$value = _slicedToArray(_entries$next.value, 2),
            value = _entries$next$value[1];

        if (value === searchValue) {
          return true;
        }

        isDone = !!done;
      } while (!isDone);

      return false;
    }

    var HandlerRegistryImpl = /*#__PURE__*/function () {
      function HandlerRegistryImpl(store) {
        _classCallCheck(this, HandlerRegistryImpl);

        this.types = new Map();
        this.dragSources = new Map();
        this.dropTargets = new Map();
        this.pinnedSourceId = null;
        this.pinnedSource = null;
        this.store = store;
      }

      _createClass(HandlerRegistryImpl, [{
        key: "addSource",
        value: function addSource(type, source) {
          (0, _contracts.validateType)(type);
          (0, _contracts.validateSourceContract)(source);
          var sourceId = this.addHandler(_interfaces.HandlerRole.SOURCE, type, source);
          this.store.dispatch((0, _registry.addSource)(sourceId));
          return sourceId;
        }
      }, {
        key: "addTarget",
        value: function addTarget(type, target) {
          (0, _contracts.validateType)(type, true);
          (0, _contracts.validateTargetContract)(target);
          var targetId = this.addHandler(_interfaces.HandlerRole.TARGET, type, target);
          this.store.dispatch((0, _registry.addTarget)(targetId));
          return targetId;
        }
      }, {
        key: "containsHandler",
        value: function containsHandler(handler) {
          return mapContainsValue(this.dragSources, handler) || mapContainsValue(this.dropTargets, handler);
        }
      }, {
        key: "getSource",
        value: function getSource(sourceId) {
          var includePinned = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
          (0, _invariant.invariant)(this.isSourceId(sourceId), 'Expected a valid source ID.');
          var isPinned = includePinned && sourceId === this.pinnedSourceId;
          var source = isPinned ? this.pinnedSource : this.dragSources.get(sourceId);
          return source;
        }
      }, {
        key: "getTarget",
        value: function getTarget(targetId) {
          (0, _invariant.invariant)(this.isTargetId(targetId), 'Expected a valid target ID.');
          return this.dropTargets.get(targetId);
        }
      }, {
        key: "getSourceType",
        value: function getSourceType(sourceId) {
          (0, _invariant.invariant)(this.isSourceId(sourceId), 'Expected a valid source ID.');
          return this.types.get(sourceId);
        }
      }, {
        key: "getTargetType",
        value: function getTargetType(targetId) {
          (0, _invariant.invariant)(this.isTargetId(targetId), 'Expected a valid target ID.');
          return this.types.get(targetId);
        }
      }, {
        key: "isSourceId",
        value: function isSourceId(handlerId) {
          var role = parseRoleFromHandlerId(handlerId);
          return role === _interfaces.HandlerRole.SOURCE;
        }
      }, {
        key: "isTargetId",
        value: function isTargetId(handlerId) {
          var role = parseRoleFromHandlerId(handlerId);
          return role === _interfaces.HandlerRole.TARGET;
        }
      }, {
        key: "removeSource",
        value: function removeSource(sourceId) {
          var _this = this;

          (0, _invariant.invariant)(this.getSource(sourceId), 'Expected an existing source.');
          this.store.dispatch((0, _registry.removeSource)(sourceId));
          (0, _asap.asap)(function () {
            _this.dragSources.delete(sourceId);

            _this.types.delete(sourceId);
          });
        }
      }, {
        key: "removeTarget",
        value: function removeTarget(targetId) {
          (0, _invariant.invariant)(this.getTarget(targetId), 'Expected an existing target.');
          this.store.dispatch((0, _registry.removeTarget)(targetId));
          this.dropTargets.delete(targetId);
          this.types.delete(targetId);
        }
      }, {
        key: "pinSource",
        value: function pinSource(sourceId) {
          var source = this.getSource(sourceId);
          (0, _invariant.invariant)(source, 'Expected an existing source.');
          this.pinnedSourceId = sourceId;
          this.pinnedSource = source;
        }
      }, {
        key: "unpinSource",
        value: function unpinSource() {
          (0, _invariant.invariant)(this.pinnedSource, 'No source is pinned at the time.');
          this.pinnedSourceId = null;
          this.pinnedSource = null;
        }
      }, {
        key: "addHandler",
        value: function addHandler(role, type, handler) {
          var id = getNextHandlerId(role);
          this.types.set(id, type);

          if (role === _interfaces.HandlerRole.SOURCE) {
            this.dragSources.set(id, handler);
          } else if (role === _interfaces.HandlerRole.TARGET) {
            this.dropTargets.set(id, handler);
          }

          return id;
        }
      }]);

      return HandlerRegistryImpl;
    }();

    exports.HandlerRegistryImpl = HandlerRegistryImpl;
  }
});
//# sourceMappingURL=HandlerRegistryImpl.js.map